/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.transport.Transport;
import org.mockito.Mockito;

public class ActionTestUtils {
    private ActionTestUtils() {
    }

    public static <Request extends ActionRequest, Response extends ActionResponse> Response executeBlocking(TransportAction<Request, Response> action, Request request) {
        PlainActionFuture future = PlainActionFuture.newFuture();
        Task task = (Task)Mockito.mock(Task.class);
        action.execute(task, request, (ActionListener)future);
        return (Response)((ActionResponse)future.actionGet());
    }

    public static <Request extends ActionRequest, Response extends ActionResponse> Response executeBlockingWithTask(TaskManager taskManager, Transport.Connection localConnection, TransportAction<Request, Response> action, Request request) {
        PlainActionFuture future = PlainActionFuture.newFuture();
        taskManager.registerAndExecute("transport", action, request, localConnection, (ActionListener)future);
        return (Response)((ActionResponse)future.actionGet());
    }

    public static <Request extends ActionRequest, Response extends ActionResponse> void execute(TransportAction<Request, Response> action, Task task, Request request, ActionListener<Response> listener) {
        action.execute(task, request, listener);
    }

    public static <T> ActionListener<T> assertNoFailureListener(CheckedConsumer<T, Exception> consumer) {
        return ActionListener.wrap(consumer, e -> {
            throw new AssertionError(e);
        });
    }

    public static ResponseListener wrapAsRestResponseListener(final ActionListener<Response> listener) {
        return new ResponseListener(){

            public void onSuccess(Response response) {
                listener.onResponse((Object)response);
            }

            public void onFailure(Exception exception) {
                listener.onFailure(exception);
            }
        };
    }
}

