/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.analysis;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.CharFilterFactory;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenizerFactory;
import org.elasticsearch.index.analysis.HunspellTokenFilterFactory;
import org.elasticsearch.index.analysis.ShingleTokenFilterFactory;
import org.elasticsearch.index.analysis.StandardTokenizerFactory;
import org.elasticsearch.index.analysis.StopTokenFilterFactory;
import org.elasticsearch.indices.analysis.PreBuiltTokenizers;
import org.elasticsearch.plugins.AnalysisPlugin;
import org.elasticsearch.test.ESTestCase;

public abstract class AnalysisFactoryTestCase
extends ESTestCase {
    private static final Map<String, Class<?>> KNOWN_TOKENIZERS = Map.ofEntries(Map.entry("classic", MovedToAnalysisCommon.class), Map.entry("edgengram", MovedToAnalysisCommon.class), Map.entry("keyword", MovedToAnalysisCommon.class), Map.entry("letter", MovedToAnalysisCommon.class), Map.entry("ngram", MovedToAnalysisCommon.class), Map.entry("pathhierarchy", MovedToAnalysisCommon.class), Map.entry("pattern", MovedToAnalysisCommon.class), Map.entry("simplepattern", MovedToAnalysisCommon.class), Map.entry("simplepatternsplit", MovedToAnalysisCommon.class), Map.entry("standard", StandardTokenizerFactory.class), Map.entry("thai", MovedToAnalysisCommon.class), Map.entry("uax29urlemail", MovedToAnalysisCommon.class), Map.entry("whitespace", MovedToAnalysisCommon.class), Map.entry("wikipedia", Void.class));
    static final Map<String, Class<?>> KNOWN_TOKENFILTERS = Map.ofEntries(Map.entry("apostrophe", MovedToAnalysisCommon.class), Map.entry("arabicnormalization", MovedToAnalysisCommon.class), Map.entry("arabicstem", MovedToAnalysisCommon.class), Map.entry("asciifolding", MovedToAnalysisCommon.class), Map.entry("bengalinormalization", MovedToAnalysisCommon.class), Map.entry("bengalistem", MovedToAnalysisCommon.class), Map.entry("brazilianstem", MovedToAnalysisCommon.class), Map.entry("bulgarianstem", MovedToAnalysisCommon.class), Map.entry("cjkbigram", MovedToAnalysisCommon.class), Map.entry("cjkwidth", MovedToAnalysisCommon.class), Map.entry("classic", MovedToAnalysisCommon.class), Map.entry("commongrams", MovedToAnalysisCommon.class), Map.entry("commongramsquery", MovedToAnalysisCommon.class), Map.entry("czechstem", MovedToAnalysisCommon.class), Map.entry("decimaldigit", MovedToAnalysisCommon.class), Map.entry("delimitedpayload", MovedToAnalysisCommon.class), Map.entry("dictionarycompoundword", MovedToAnalysisCommon.class), Map.entry("edgengram", MovedToAnalysisCommon.class), Map.entry("elision", MovedToAnalysisCommon.class), Map.entry("englishminimalstem", MovedToAnalysisCommon.class), Map.entry("englishpossessive", MovedToAnalysisCommon.class), Map.entry("finnishlightstem", MovedToAnalysisCommon.class), Map.entry("fixedshingle", MovedToAnalysisCommon.class), Map.entry("frenchlightstem", MovedToAnalysisCommon.class), Map.entry("frenchminimalstem", MovedToAnalysisCommon.class), Map.entry("galicianminimalstem", MovedToAnalysisCommon.class), Map.entry("galicianstem", MovedToAnalysisCommon.class), Map.entry("germanstem", MovedToAnalysisCommon.class), Map.entry("germanlightstem", MovedToAnalysisCommon.class), Map.entry("germanminimalstem", MovedToAnalysisCommon.class), Map.entry("germannormalization", MovedToAnalysisCommon.class), Map.entry("greeklowercase", MovedToAnalysisCommon.class), Map.entry("greekstem", MovedToAnalysisCommon.class), Map.entry("hindinormalization", MovedToAnalysisCommon.class), Map.entry("hindistem", MovedToAnalysisCommon.class), Map.entry("hungarianlightstem", MovedToAnalysisCommon.class), Map.entry("hunspellstem", HunspellTokenFilterFactory.class), Map.entry("hyphenationcompoundword", MovedToAnalysisCommon.class), Map.entry("indicnormalization", MovedToAnalysisCommon.class), Map.entry("irishlowercase", MovedToAnalysisCommon.class), Map.entry("indonesianstem", MovedToAnalysisCommon.class), Map.entry("italianlightstem", MovedToAnalysisCommon.class), Map.entry("keepword", MovedToAnalysisCommon.class), Map.entry("keywordmarker", MovedToAnalysisCommon.class), Map.entry("kstem", MovedToAnalysisCommon.class), Map.entry("latvianstem", MovedToAnalysisCommon.class), Map.entry("length", MovedToAnalysisCommon.class), Map.entry("limittokencount", MovedToAnalysisCommon.class), Map.entry("lowercase", MovedToAnalysisCommon.class), Map.entry("ngram", MovedToAnalysisCommon.class), Map.entry("norwegianlightstem", MovedToAnalysisCommon.class), Map.entry("norwegianminimalstem", MovedToAnalysisCommon.class), Map.entry("norwegiannormalization", MovedToAnalysisCommon.class), Map.entry("patterncapturegroup", MovedToAnalysisCommon.class), Map.entry("patternreplace", MovedToAnalysisCommon.class), Map.entry("persiannormalization", MovedToAnalysisCommon.class), Map.entry("porterstem", MovedToAnalysisCommon.class), Map.entry("portuguesestem", MovedToAnalysisCommon.class), Map.entry("portugueselightstem", MovedToAnalysisCommon.class), Map.entry("portugueseminimalstem", MovedToAnalysisCommon.class), Map.entry("reversestring", MovedToAnalysisCommon.class), Map.entry("russianlightstem", MovedToAnalysisCommon.class), Map.entry("scandinavianfolding", MovedToAnalysisCommon.class), Map.entry("scandinaviannormalization", MovedToAnalysisCommon.class), Map.entry("serbiannormalization", MovedToAnalysisCommon.class), Map.entry("shingle", ShingleTokenFilterFactory.class), Map.entry("minhash", MovedToAnalysisCommon.class), Map.entry("snowballporter", MovedToAnalysisCommon.class), Map.entry("soraninormalization", MovedToAnalysisCommon.class), Map.entry("soranistem", MovedToAnalysisCommon.class), Map.entry("spanishlightstem", MovedToAnalysisCommon.class), Map.entry("stemmeroverride", MovedToAnalysisCommon.class), Map.entry("stop", StopTokenFilterFactory.class), Map.entry("swedishlightstem", MovedToAnalysisCommon.class), Map.entry("swedishminimalstem", MovedToAnalysisCommon.class), Map.entry("synonym", MovedToAnalysisCommon.class), Map.entry("synonymgraph", MovedToAnalysisCommon.class), Map.entry("telugunormalization", MovedToAnalysisCommon.class), Map.entry("telugustem", MovedToAnalysisCommon.class), Map.entry("trim", MovedToAnalysisCommon.class), Map.entry("truncate", MovedToAnalysisCommon.class), Map.entry("turkishlowercase", MovedToAnalysisCommon.class), Map.entry("type", MovedToAnalysisCommon.class), Map.entry("uppercase", MovedToAnalysisCommon.class), Map.entry("worddelimiter", MovedToAnalysisCommon.class), Map.entry("worddelimitergraph", MovedToAnalysisCommon.class), Map.entry("flattengraph", MovedToAnalysisCommon.class), Map.entry("suggeststop", Void.class), Map.entry("capitalization", Void.class), Map.entry("codepointcount", Void.class), Map.entry("hyphenatedwords", Void.class), Map.entry("keywordrepeat", Void.class), Map.entry("limittokenoffset", Void.class), Map.entry("limittokenposition", Void.class), Map.entry("numericpayload", Void.class), Map.entry("removeduplicates", Void.class), Map.entry("tokenoffsetpayload", Void.class), Map.entry("typeaspayload", Void.class), Map.entry("typeassynonym", Void.class), Map.entry("fingerprint", Void.class), Map.entry("daterecognizer", Void.class), Map.entry("fixbrokenoffsets", Void.class), Map.entry("delimitedtermfrequency", Void.class), Map.entry("protectedterm", Void.class), Map.entry("concatenategraph", Void.class), Map.entry("spanishminimalstem", Void.class), Map.entry("delimitedboost", Void.class), Map.entry("dropifflagged", Void.class), Map.entry("japanesecompletion", Void.class), Map.entry("patterntyping", Void.class), Map.entry("spanishpluralstem", Void.class), Map.entry("daitchmokotoffsoundex", Void.class), Map.entry("persianstem", Void.class));
    static final Map<String, Class<?>> KNOWN_CHARFILTERS = Map.of("htmlstrip", MovedToAnalysisCommon.class, "mapping", MovedToAnalysisCommon.class, "patternreplace", MovedToAnalysisCommon.class, "persian", Void.class, "cjkwidth", Void.class);
    private final AnalysisPlugin plugin;

    public AnalysisFactoryTestCase(AnalysisPlugin plugin) {
        this.plugin = Objects.requireNonNull(plugin, "plugin is required. use an empty plugin for core");
    }

    protected Map<String, Class<?>> getCharFilters() {
        return KNOWN_CHARFILTERS;
    }

    protected Map<String, Class<?>> getTokenFilters() {
        return KNOWN_TOKENFILTERS;
    }

    protected Map<String, Class<?>> getTokenizers() {
        return KNOWN_TOKENIZERS;
    }

    protected Map<String, Class<?>> getPreConfiguredTokenFilters() {
        HashMap filters = new HashMap();
        filters.put("lowercase", null);
        filters.put("standard", Void.class);
        return filters;
    }

    protected Map<String, Class<?>> getPreConfiguredTokenizers() {
        HashMap tokenizers = new HashMap();
        for (PreBuiltTokenizers tokenizer : PreBuiltTokenizers.values()) {
            tokenizers.put(tokenizer.name().toLowerCase(Locale.ROOT), null);
        }
        return tokenizers;
    }

    public Map<String, Class<?>> getPreConfiguredCharFilters() {
        return Collections.emptyMap();
    }

    public void testTokenizers() {
        TreeSet missing = new TreeSet();
        missing.addAll(TokenizerFactory.availableTokenizers().stream().map(key -> key.toLowerCase(Locale.ROOT)).collect(Collectors.toSet()));
        missing.removeAll(this.getTokenizers().keySet());
        AnalysisFactoryTestCase.assertTrue((String)("new tokenizers found, please update KNOWN_TOKENIZERS: " + ((Object)missing).toString()), (boolean)missing.isEmpty());
    }

    public void testCharFilters() {
        TreeSet missing = new TreeSet();
        missing.addAll(CharFilterFactory.availableCharFilters().stream().map(key -> key.toLowerCase(Locale.ROOT)).collect(Collectors.toSet()));
        missing.removeAll(this.getCharFilters().keySet());
        AnalysisFactoryTestCase.assertTrue((String)("new charfilters found, please update KNOWN_CHARFILTERS: " + ((Object)missing).toString()), (boolean)missing.isEmpty());
    }

    public void testTokenFilters() {
        TreeSet missing = new TreeSet();
        missing.addAll(TokenFilterFactory.availableTokenFilters().stream().map(key -> key.toLowerCase(Locale.ROOT)).collect(Collectors.toSet()));
        missing.removeAll(this.getTokenFilters().keySet());
        AnalysisFactoryTestCase.assertTrue((String)("new tokenfilters found, please update KNOWN_TOKENFILTERS: " + missing), (boolean)missing.isEmpty());
    }

    protected static final class MovedToAnalysisCommon {
        private MovedToAnalysisCommon() {
        }
    }
}

