/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.action.search.SearchShardTask;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.indices.ExecutorSelector;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.node.ResponseCollectorService;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.internal.ReaderContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.tracing.Tracer;

public class MockSearchService
extends SearchService {
    private static final Map<ReaderContext, Throwable> ACTIVE_SEARCH_CONTEXTS = new ConcurrentHashMap<ReaderContext, Throwable>();
    private Consumer<ReaderContext> onPutContext = context -> {};
    private Consumer<SearchContext> onCreateSearchContext = context -> {};
    private Function<SearchShardTask, SearchShardTask> onCheckCancelled = Function.identity();

    public static void assertNoInFlightContext() {
        HashMap<ReaderContext, Throwable> copy = new HashMap<ReaderContext, Throwable>(ACTIVE_SEARCH_CONTEXTS);
        if (!copy.isEmpty()) {
            throw new AssertionError("There are still [" + copy.size() + "] in-flight contexts. The first one's creation site is listed as the cause of this exception.", (Throwable)copy.values().iterator().next());
        }
    }

    static void addActiveContext(ReaderContext context) {
        ACTIVE_SEARCH_CONTEXTS.put(context, new RuntimeException(context.toString()));
    }

    static void removeActiveContext(ReaderContext context) {
        ACTIVE_SEARCH_CONTEXTS.remove(context);
    }

    public MockSearchService(ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ScriptService scriptService, BigArrays bigArrays, FetchPhase fetchPhase, ResponseCollectorService responseCollectorService, CircuitBreakerService circuitBreakerService, ExecutorSelector executorSelector, Tracer tracer) {
        super(clusterService, indicesService, threadPool, scriptService, bigArrays, fetchPhase, responseCollectorService, circuitBreakerService, executorSelector, tracer);
    }

    protected void putReaderContext(ReaderContext context) {
        this.onPutContext.accept(context);
        MockSearchService.addActiveContext(context);
        super.putReaderContext(context);
    }

    protected ReaderContext removeReaderContext(long id) {
        ReaderContext removed = super.removeReaderContext(id);
        if (removed != null) {
            MockSearchService.removeActiveContext(removed);
        }
        return removed;
    }

    public void setOnPutContext(Consumer<ReaderContext> onPutContext) {
        this.onPutContext = onPutContext;
    }

    public void setOnCreateSearchContext(Consumer<SearchContext> onCreateSearchContext) {
        this.onCreateSearchContext = onCreateSearchContext;
    }

    protected SearchContext createContext(ReaderContext readerContext, ShardSearchRequest request, SearchShardTask task, boolean includeAggregations) throws IOException {
        SearchContext searchContext = super.createContext(readerContext, request, task, includeAggregations);
        this.onCreateSearchContext.accept(searchContext);
        return searchContext;
    }

    public void setOnCheckCancelled(Function<SearchShardTask, SearchShardTask> onCheckCancelled) {
        this.onCheckCancelled = onCheckCancelled;
    }

    protected void checkCancelled(SearchShardTask task) {
        super.checkCancelled(this.onCheckCancelled.apply(task));
    }

    public static class TestPlugin
    extends Plugin {
    }
}

