/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.generators.RandomNumbers;
import com.carrotsearch.randomizedtesting.generators.RandomStrings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class BackgroundIndexer
implements AutoCloseable {
    private final Logger logger = LogManager.getLogger(this.getClass());
    final Thread[] writers;
    final Client client;
    final CountDownLatch stopLatch;
    final Collection<Exception> failures = new ArrayList<Exception>();
    final AtomicBoolean stop = new AtomicBoolean(false);
    final AtomicLong idGenerator = new AtomicLong();
    final CountDownLatch startLatch = new CountDownLatch(1);
    final AtomicBoolean hasBudget = new AtomicBoolean(false);
    final Semaphore availableBudget = new Semaphore(0);
    final boolean useAutoGeneratedIDs;
    private final Set<String> ids = ConcurrentCollections.newConcurrentSet();
    private volatile Consumer<Exception> failureAssertion = null;
    volatile int minFieldSize = 10;
    volatile int maxFieldSize = 140;
    private volatile TimeValue timeout = BulkShardRequest.DEFAULT_TIMEOUT;
    private volatile boolean ignoreIndexingFailures;

    public BackgroundIndexer(String index, Client client, int numOfDocs) {
        this(index, client, numOfDocs, RandomizedTest.scaledRandomIntBetween((int)2, (int)5));
    }

    public BackgroundIndexer(String index, Client client, int numOfDocs, int writerCount) {
        this(index, client, numOfDocs, writerCount, true, null);
    }

    public BackgroundIndexer(final String index, final Client client, int numOfDocs, int writerCount, boolean autoStart, Random random) {
        if (random == null) {
            random = RandomizedTest.getRandom();
        }
        this.client = client;
        this.useAutoGeneratedIDs = random.nextBoolean();
        this.writers = new Thread[writerCount];
        this.stopLatch = new CountDownLatch(this.writers.length);
        this.logger.info("--> creating {} indexing threads (auto start: [{}], numOfDocs: [{}])", (Object)writerCount, (Object)autoStart, (Object)numOfDocs);
        for (int i = 0; i < this.writers.length; ++i) {
            final int indexerId = i;
            final boolean batch = random.nextBoolean();
            final Random threadRandom = new Random(random.nextLong());
            this.writers[i] = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long id = -1L;
                    try {
                        BackgroundIndexer.this.startLatch.await();
                        BackgroundIndexer.this.logger.info("**** starting indexing thread {}", (Object)indexerId);
                        while (!BackgroundIndexer.this.stop.get()) {
                            boolean add;
                            if (batch) {
                                int batchSize = threadRandom.nextInt(20) + 1;
                                if (BackgroundIndexer.this.hasBudget.get() && !BackgroundIndexer.this.availableBudget.tryAcquire(batchSize = Math.max(Math.min(batchSize, BackgroundIndexer.this.availableBudget.availablePermits()), 1), 250L, TimeUnit.MILLISECONDS)) continue;
                                BulkRequestBuilder bulkRequest = client.prepareBulk().setTimeout(BackgroundIndexer.this.timeout);
                                for (int i = 0; i < batchSize; ++i) {
                                    id = BackgroundIndexer.this.idGenerator.incrementAndGet();
                                    if (BackgroundIndexer.this.useAutoGeneratedIDs) {
                                        bulkRequest.add(client.prepareIndex(index).setSource(BackgroundIndexer.this.generateSource(id, threadRandom)));
                                        continue;
                                    }
                                    bulkRequest.add(client.prepareIndex(index).setId(Long.toString(id)).setSource(BackgroundIndexer.this.generateSource(id, threadRandom)));
                                }
                                try {
                                    BulkResponse bulkResponse = (BulkResponse)bulkRequest.get();
                                    for (BulkItemResponse bulkItemResponse : bulkResponse) {
                                        if (!bulkItemResponse.isFailed()) {
                                            boolean add2 = BackgroundIndexer.this.ids.add(bulkItemResponse.getId());
                                            assert (add2) : "ID: " + bulkItemResponse.getId() + " already used";
                                            continue;
                                        }
                                        BackgroundIndexer.this.trackFailure(bulkItemResponse.getFailure().getCause());
                                    }
                                    continue;
                                }
                                catch (Exception e) {
                                    if (BackgroundIndexer.this.ignoreIndexingFailures) continue;
                                    throw e;
                                }
                            }
                            if (BackgroundIndexer.this.hasBudget.get() && !BackgroundIndexer.this.availableBudget.tryAcquire(250L, TimeUnit.MILLISECONDS)) continue;
                            id = BackgroundIndexer.this.idGenerator.incrementAndGet();
                            if (BackgroundIndexer.this.useAutoGeneratedIDs) {
                                try {
                                    IndexResponse indexResponse = (IndexResponse)((IndexRequestBuilder)client.prepareIndex(index).setTimeout(BackgroundIndexer.this.timeout)).setSource(BackgroundIndexer.this.generateSource(id, threadRandom)).get();
                                    add = BackgroundIndexer.this.ids.add(indexResponse.getId());
                                    assert (add) : "ID: " + indexResponse.getId() + " already used";
                                    continue;
                                }
                                catch (Exception e) {
                                    if (BackgroundIndexer.this.ignoreIndexingFailures) continue;
                                    throw e;
                                }
                            }
                            try {
                                IndexResponse indexResponse = (IndexResponse)((IndexRequestBuilder)client.prepareIndex(index).setId(Long.toString(id)).setTimeout(BackgroundIndexer.this.timeout)).setSource(BackgroundIndexer.this.generateSource(id, threadRandom)).get();
                                add = BackgroundIndexer.this.ids.add(indexResponse.getId());
                                assert (add) : "ID: " + indexResponse.getId() + " already used";
                            }
                            catch (Exception e) {
                                if (BackgroundIndexer.this.ignoreIndexingFailures) continue;
                                throw e;
                            }
                        }
                        BackgroundIndexer.this.logger.info("**** done indexing thread {}  stop: {} numDocsIndexed: {}", (Object)indexerId, (Object)BackgroundIndexer.this.stop.get(), (Object)BackgroundIndexer.this.ids.size());
                    }
                    catch (Exception e) {
                        BackgroundIndexer.this.trackFailure(e);
                        long docId = id;
                        BackgroundIndexer.this.logger.warn(() -> Strings.format((String)"**** failed indexing thread %s on doc id %s", (Object[])new Object[]{indexerId, docId}), (Throwable)e);
                    }
                    finally {
                        BackgroundIndexer.this.stopLatch.countDown();
                    }
                }
            };
            this.writers[i].start();
        }
        if (autoStart) {
            this.start(numOfDocs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackFailure(Exception e) {
        Collection<Exception> collection = this.failures;
        synchronized (collection) {
            if (this.failureAssertion != null) {
                this.failureAssertion.accept(e);
            } else {
                this.failures.add(e);
            }
        }
    }

    private XContentBuilder generateSource(long id, Random random) throws IOException {
        int contentLength = RandomNumbers.randomIntBetween((Random)random, (int)this.minFieldSize, (int)this.maxFieldSize);
        StringBuilder text = new StringBuilder(contentLength);
        while (text.length() < contentLength) {
            int tokenLength = RandomNumbers.randomIntBetween((Random)random, (int)1, (int)Math.min(contentLength - text.length(), 10));
            text.append(" ").append(RandomStrings.randomRealisticUnicodeOfCodepointLength((Random)random, (int)tokenLength));
        }
        XContentBuilder builder = XContentFactory.smileBuilder();
        builder.startObject().field("test", "value" + id).field("text", text.toString()).field("id", id).endObject();
        return builder;
    }

    public void setRequestTimeout(TimeValue requestTimeout) {
        this.timeout = requestTimeout;
    }

    public void setIgnoreIndexingFailures(boolean ignoreIndexingFailures) {
        this.ignoreIndexingFailures = ignoreIndexingFailures;
    }

    private void setBudget(int numOfDocs) {
        this.logger.debug("updating budget to [{}]", (Object)numOfDocs);
        if (numOfDocs >= 0) {
            this.hasBudget.set(true);
            this.availableBudget.release(numOfDocs);
        } else {
            this.hasBudget.set(false);
        }
    }

    public void start(int numOfDocs) {
        assert (!this.stop.get()) : "background indexer can not be started after it has stopped";
        this.setBudget(numOfDocs);
        this.startLatch.countDown();
    }

    public void pauseIndexing() {
        this.availableBudget.drainPermits();
        this.setBudget(0);
    }

    public void continueIndexing(int numOfDocs) {
        this.setBudget(numOfDocs);
    }

    public void stop() {
        this.stop.set(true);
    }

    public void awaitStopped() throws InterruptedException {
        assert (this.stop.get());
        Assert.assertThat((String)"timeout while waiting for indexing threads to stop", (Object)this.stopLatch.await(6L, TimeUnit.MINUTES), (Matcher)Matchers.equalTo((Object)true));
        if (this.failureAssertion == null) {
            this.assertNoFailures();
        }
    }

    public void stopAndAwaitStopped() throws InterruptedException {
        this.stop();
        this.awaitStopped();
    }

    public long totalIndexedDocs() {
        return this.ids.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertNoFailures() {
        Collection<Exception> collection = this.failures;
        synchronized (collection) {
            Assert.assertThat(this.failures, (Matcher)Matchers.emptyIterable());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFailureAssertion(Consumer<Exception> failureAssertion) {
        Collection<Exception> collection = this.failures;
        synchronized (collection) {
            this.failureAssertion = failureAssertion;
            boolean success = false;
            try {
                for (Exception failure : this.failures) {
                    failureAssertion.accept(failure);
                }
                this.failures.clear();
                success = true;
            }
            finally {
                if (!success) {
                    this.stop();
                }
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.stopAndAwaitStopped();
    }

    public Client getClient() {
        return this.client;
    }

    public Set<String> getIds() {
        return this.ids;
    }
}

