/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.compiler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;
import org.elasticsearch.test.PrivilegedOperations;

public class InMemoryJavaCompiler {
    public static Map<String, byte[]> compile(Map<String, CharSequence> sources, String ... options) {
        List<InMemoryJavaFileObject> files = sources.entrySet().stream().map(e -> new InMemoryJavaFileObject((String)e.getKey(), (CharSequence)e.getValue())).toList();
        JavaCompiler.CompilationTask task = InMemoryJavaCompiler.getCompilationTask(files, options);
        boolean result = PrivilegedOperations.compilationTaskCall(task);
        if (!result) {
            throw new RuntimeException("Could not compile " + sources.entrySet().stream().toList());
        }
        return files.stream().collect(Collectors.toMap(InMemoryJavaFileObject::getClassName, InMemoryJavaFileObject::getByteCode));
    }

    public static byte[] compile(String className, CharSequence sourceCode, String ... options) {
        InMemoryJavaFileObject file = new InMemoryJavaFileObject(className, sourceCode);
        JavaCompiler.CompilationTask task = InMemoryJavaCompiler.getCompilationTask(file, options);
        boolean result = PrivilegedOperations.compilationTaskCall(task);
        if (!result) {
            throw new RuntimeException("Could not compile " + className + " with source code " + sourceCode);
        }
        return file.getByteCode();
    }

    private static JavaCompiler getCompiler() {
        return ToolProvider.getSystemJavaCompiler();
    }

    private static JavaCompiler.CompilationTask getCompilationTask(List<InMemoryJavaFileObject> files, String ... options) {
        return InMemoryJavaCompiler.getCompiler().getTask(null, new FileManagerWrapper(files), null, List.of(options), null, files);
    }

    private static JavaCompiler.CompilationTask getCompilationTask(InMemoryJavaFileObject file, String ... options) {
        return InMemoryJavaCompiler.getCompiler().getTask(null, new FileManagerWrapper(file), null, List.of(options), null, List.of(file));
    }

    private static class InMemoryJavaFileObject
    extends SimpleJavaFileObject {
        private final String className;
        private final CharSequence sourceCode;
        private final ByteArrayOutputStream byteCode;

        InMemoryJavaFileObject(String className, CharSequence sourceCode) {
            super(URI.create("string:///" + className.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.className = className;
            this.sourceCode = sourceCode;
            this.byteCode = new ByteArrayOutputStream();
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.sourceCode;
        }

        @Override
        public OutputStream openOutputStream() {
            return this.byteCode;
        }

        public byte[] getByteCode() {
            return this.byteCode.toByteArray();
        }

        public String getClassName() {
            return this.className;
        }
    }

    private static class FileManagerWrapper
    extends ForwardingJavaFileManager<JavaFileManager> {
        private final List<InMemoryJavaFileObject> files;

        FileManagerWrapper(List<InMemoryJavaFileObject> files) {
            super(InMemoryJavaCompiler.getCompiler().getStandardFileManager(null, null, null));
            this.files = List.copyOf(files);
        }

        FileManagerWrapper(InMemoryJavaFileObject file) {
            super(InMemoryJavaCompiler.getCompiler().getStandardFileManager(null, null, null));
            this.files = List.of(file);
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            return this.files.stream().filter(f -> f.getClassName().endsWith(className)).findFirst().orElseThrow(FileManagerWrapper.newIOException(className, this.files));
        }

        static Supplier<IOException> newIOException(String className, List<InMemoryJavaFileObject> files) {
            return () -> new IOException("Expected class with name " + className + ", in " + files.stream().map(InMemoryJavaFileObject::getClassName).toList());
        }
    }
}

