/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.test.rest.Stash;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class ObjectPath {
    private final Object object;

    public static ObjectPath createFromResponse(Response response) throws IOException {
        byte[] bytes = EntityUtils.toByteArray((HttpEntity)response.getEntity());
        String contentType = response.getHeader("Content-Type");
        XContentType xContentType = XContentType.fromMediaType((String)contentType);
        return ObjectPath.createFromXContent(xContentType.xContent(), (BytesReference)new BytesArray(bytes));
    }

    public static ObjectPath createFromXContent(XContent xContent, BytesReference input) throws IOException {
        try (XContentParser parser = xContent.createParser(XContentParserConfiguration.EMPTY, (InputStream)input.streamInput());){
            if (parser.nextToken() == XContentParser.Token.START_ARRAY) {
                ObjectPath objectPath = new ObjectPath(parser.listOrderedMap());
                return objectPath;
            }
            ObjectPath objectPath = new ObjectPath(parser.mapOrdered());
            return objectPath;
        }
    }

    public ObjectPath(Object object) {
        this.object = object;
    }

    public static <T> T evaluate(Object object, String path) throws IOException {
        return new ObjectPath(object).evaluate(path, Stash.EMPTY);
    }

    public <T> T evaluate(String path) throws IOException {
        return this.evaluate(path, Stash.EMPTY);
    }

    public <T> T evaluate(String path, Stash stash) throws IOException {
        String[] parts = this.parsePath(path);
        Object result = this.object;
        for (String part : parts) {
            if ((result = this.evaluate(part, result, stash)) != null) continue;
            return null;
        }
        return (T)result;
    }

    private Object evaluate(String key, Object objectToEvaluate, Stash stash) throws IOException {
        if (stash.containsStashedValue(key)) {
            key = stash.getValue(key).toString();
        }
        if (objectToEvaluate instanceof Map) {
            Map objectAsMap = (Map)objectToEvaluate;
            if ("_arbitrary_key_".equals(key)) {
                if (objectAsMap.isEmpty()) {
                    throw new IllegalArgumentException("requested [" + key + "] but the map was empty");
                }
                if (objectAsMap.containsKey(key)) {
                    throw new IllegalArgumentException("requested meta-key [" + key + "] but the map unexpectedly contains this key");
                }
                return objectAsMap.keySet().iterator().next();
            }
            return objectAsMap.get(key);
        }
        if (objectToEvaluate instanceof List) {
            List list = (List)objectToEvaluate;
            try {
                return list.get(Integer.parseInt(key));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("element was a list, but [" + key + "] was not numeric", e);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("element was a list with " + list.size() + " elements, but [" + key + "] was out of bounds", e);
            }
        }
        throw new IllegalArgumentException("no object found for [" + key + "] within object of class [" + objectToEvaluate.getClass() + "]");
    }

    private String[] parsePath(String path) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean escape = false;
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '\\') {
                escape = true;
                continue;
            }
            if (c == '.') {
                if (escape) {
                    escape = false;
                } else {
                    if (current.length() <= 0) continue;
                    list.add(current.toString());
                    current.setLength(0);
                    continue;
                }
            }
            current.append(c);
        }
        if (current.length() > 0) {
            list.add(current.toString());
        }
        return list.toArray(new String[0]);
    }

    public XContentBuilder toXContentBuilder(XContent xContent) throws IOException {
        XContentBuilder builder = XContentBuilder.builder((XContent)xContent);
        if (!(this.object instanceof Map)) {
            throw new UnsupportedOperationException("Only ObjectPath created from a map supported.");
        }
        builder.map((Map)this.object);
        return builder;
    }
}

