/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.replication.TransportWriteAction;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.translog.Translog;

public abstract class TransportWriteActionTestHelper {
    public static void performPostWriteActions(IndexShard indexShard, WriteRequest<?> request, @Nullable Translog.Location location, Logger logger) {
        final CountDownLatch latch = new CountDownLatch(1);
        TransportWriteAction.RespondingWriteResult writerResult = new TransportWriteAction.RespondingWriteResult(){

            public void onSuccess(boolean forcedRefresh) {
                latch.countDown();
            }

            public void onFailure(Exception ex) {
                throw new AssertionError((Object)ex);
            }
        };
        new TransportWriteAction.AsyncAfterWriteAction(indexShard, request, location, writerResult, logger, null).run();
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }
}

