/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;

public final class RoutingNodesHelper {
    private RoutingNodesHelper() {
    }

    public static List<ShardRouting> shardsWithState(RoutingNodes routingNodes, ShardRoutingState state) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (RoutingNode routingNode : routingNodes) {
            shards.addAll(routingNode.shardsWithState(state));
        }
        if (state == ShardRoutingState.UNASSIGNED) {
            routingNodes.unassigned().forEach(shards::add);
        }
        return shards;
    }

    public static List<ShardRouting> shardsWithState(RoutingNodes routingNodes, String index, ShardRoutingState ... state) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (RoutingNode routingNode : routingNodes) {
            shards.addAll(routingNode.shardsWithState(index, state));
        }
        for (ShardRoutingState s : state) {
            if (s != ShardRoutingState.UNASSIGNED) continue;
            for (ShardRouting unassignedShard : routingNodes.unassigned()) {
                if (!unassignedShard.index().getName().equals(index)) continue;
                shards.add(unassignedShard);
            }
            break;
        }
        return shards;
    }

    public static Stream<ShardRouting> asStream(IndexShardRoutingTable indexShardRoutingTable) {
        return IntStream.range(0, indexShardRoutingTable.size()).mapToObj(arg_0 -> ((IndexShardRoutingTable)indexShardRoutingTable).shard(arg_0));
    }

    public static RoutingNode routingNode(String nodeId, DiscoveryNode node, ShardRouting ... shards) {
        RoutingNode routingNode = new RoutingNode(nodeId, node, shards.length);
        for (ShardRouting shardRouting : shards) {
            routingNode.add(shardRouting);
        }
        return routingNode;
    }
}

