/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RelocationFailureInfo;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.UnassignedInfo;

public class ShardRoutingHelper {
    public static ShardRouting relocate(ShardRouting routing, String nodeId) {
        return ShardRoutingHelper.relocate(routing, nodeId, -1L);
    }

    public static ShardRouting relocate(ShardRouting routing, String nodeId, long expectedByteSize) {
        return routing.relocate(nodeId, expectedByteSize);
    }

    public static ShardRouting moveToStarted(ShardRouting routing) {
        return routing.moveToStarted(-1L);
    }

    public static ShardRouting moveToStarted(ShardRouting routing, long expectedShardSize) {
        return routing.moveToStarted(expectedShardSize);
    }

    public static ShardRouting initialize(ShardRouting routing, String nodeId) {
        return ShardRoutingHelper.initialize(routing, nodeId, -1L);
    }

    public static ShardRouting initialize(ShardRouting routing, String nodeId, long expectedSize) {
        return routing.initialize(nodeId, null, expectedSize);
    }

    public static ShardRouting initWithSameId(ShardRouting copy, RecoverySource recoverySource) {
        return new ShardRouting(copy.shardId(), copy.currentNodeId(), copy.relocatingNodeId(), copy.primary(), ShardRoutingState.INITIALIZING, recoverySource, new UnassignedInfo(UnassignedInfo.Reason.REINITIALIZED, null), RelocationFailureInfo.NO_FAILURES, copy.allocationId(), copy.getExpectedShardSize());
    }

    public static ShardRouting moveToUnassigned(ShardRouting routing, UnassignedInfo info) {
        return routing.moveToUnassigned(info);
    }

    public static ShardRouting newWithRestoreSource(ShardRouting routing, RecoverySource.SnapshotRecoverySource recoverySource) {
        return new ShardRouting(routing.shardId(), routing.currentNodeId(), routing.relocatingNodeId(), routing.primary(), routing.state(), (RecoverySource)recoverySource, routing.unassignedInfo(), routing.relocationFailureInfo(), routing.allocationId(), routing.getExpectedShardSize());
    }
}

