/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.plugins.AnalysisPlugin;
import org.elasticsearch.plugins.scanners.StablePluginsRegistry;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.IndexSettingsModule;

public class AnalysisTestsHelper {
    public static ESTestCase.TestAnalysis createTestAnalysisFromClassPath(Path baseDir, String resource, AnalysisPlugin ... plugins) throws IOException {
        Settings settings = Settings.builder().loadFromStream(resource, AnalysisTestsHelper.class.getResourceAsStream(resource), false).put(Environment.PATH_HOME_SETTING.getKey(), baseDir.toString()).build();
        return AnalysisTestsHelper.createTestAnalysisFromSettings(settings, plugins);
    }

    public static ESTestCase.TestAnalysis createTestAnalysisFromSettings(Settings settings, AnalysisPlugin ... plugins) throws IOException {
        return AnalysisTestsHelper.createTestAnalysisFromSettings(settings, null, plugins);
    }

    public static ESTestCase.TestAnalysis createTestAnalysisFromSettings(Settings settings, Path configPath, AnalysisPlugin ... plugins) throws IOException {
        Settings actualSettings = settings.get("index.version.created") == null ? Settings.builder().put(settings).put("index.version.created", Version.CURRENT).build() : settings;
        IndexSettings indexSettings = IndexSettingsModule.newIndexSettings("test", actualSettings, new Setting[0]);
        AnalysisRegistry analysisRegistry = new AnalysisModule(new Environment(actualSettings, configPath), Arrays.asList(plugins), new StablePluginsRegistry()).getAnalysisRegistry();
        return new ESTestCase.TestAnalysis(analysisRegistry.build(indexSettings), analysisRegistry.buildTokenFilterFactories(indexSettings), analysisRegistry.buildTokenizerFactories(indexSettings), analysisRegistry.buildCharFilterFactories(indexSettings));
    }
}

