/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.test.AbstractWireSerializingTestCase;
import org.elasticsearch.test.AbstractXContentTestCase;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.cbor.CborXContent;
import org.elasticsearch.xcontent.smile.SmileXContent;

public abstract class AbstractSerializationTestCase<T extends Writeable>
extends AbstractWireSerializingTestCase<T> {
    public final void testFromXContent() throws IOException {
        this.createXContentTester().numberOfTestRuns(20).supportsUnknownFields(this.supportsUnknownFields()).shuffleFieldsExceptions(this.getShuffleFieldsExceptions()).randomFieldsExcludeFilter(this.getRandomFieldsExcludeFilter()).assertEqualsConsumer(this::assertEqualInstances).assertToXContentEquivalence(this.assertToXContentEquivalence()).test();
    }

    public final void testConcurrentToXContent() throws IOException, InterruptedException, ExecutionException {
        XContentType xContentType = AbstractSerializationTestCase.randomValueOtherThanMany(type -> type.xContent() == SmileXContent.smileXContent, () -> AbstractSerializationTestCase.randomFrom(XContentType.values()));
        T testInstance = this.createXContextTestInstance(xContentType);
        ToXContent.DelegatingMapParams params = new ToXContent.DelegatingMapParams(Collections.singletonMap("typed_keys", "true"), this.getToXContentParams());
        boolean humanReadable = AbstractSerializationTestCase.randomBoolean();
        BytesRef firstTimeBytes = XContentHelper.toXContent((ToXContent)this.asXContent(testInstance), (XContentType)xContentType, (ToXContent.Params)params, (boolean)humanReadable).toBytesRef();
        int rounds = AbstractSerializationTestCase.scaledRandomIntBetween(300, 5000);
        this.concurrentTest(() -> this.lambda$testConcurrentToXContent$2(rounds, testInstance, xContentType, (ToXContent.Params)params, humanReadable, firstTimeBytes));
    }

    protected abstract ToXContent asXContent(T var1);

    protected abstract T createXContextTestInstance(XContentType var1);

    protected abstract AbstractXContentTestCase.XContentTester<T> createXContentTester();

    protected boolean supportsUnknownFields() {
        return false;
    }

    protected Predicate<String> getRandomFieldsExcludeFilter() {
        return field -> false;
    }

    protected String[] getShuffleFieldsExceptions() {
        return Strings.EMPTY_ARRAY;
    }

    protected ToXContent.Params getToXContentParams() {
        return ToXContent.EMPTY_PARAMS;
    }

    protected boolean assertToXContentEquivalence() {
        return true;
    }

    protected Date randomDate() {
        return new Date(AbstractSerializationTestCase.randomLongBetween(0L, 3000000000000L));
    }

    protected Instant randomInstant() {
        return Instant.ofEpochSecond(AbstractSerializationTestCase.randomLongBetween(0L, 3000000000L), AbstractSerializationTestCase.randomLongBetween(0L, 999999999L));
    }

    private /* synthetic */ void lambda$testConcurrentToXContent$2(int rounds, Writeable testInstance, XContentType xContentType, ToXContent.Params params, boolean humanReadable, BytesRef firstTimeBytes) {
        try {
            for (int r = 0; r < rounds; ++r) {
                BytesRef thisRoundBytes = XContentHelper.toXContent((ToXContent)this.asXContent(testInstance), (XContentType)xContentType, (ToXContent.Params)params, (boolean)humanReadable).toBytesRef();
                if (firstTimeBytes.bytesEquals(thisRoundBytes)) continue;
                StringBuilder error = new StringBuilder("Failed to round trip over ");
                if (humanReadable) {
                    error.append("human readable ");
                }
                error.append(xContentType);
                error.append("\nCanonical is:\n").append(Strings.toString((ToXContent)this.asXContent(testInstance), (boolean)true, (boolean)true));
                boolean showBytes = xContentType.xContent() == CborXContent.cborXContent;
                error.append("\nWanted : ").append(showBytes ? firstTimeBytes : firstTimeBytes.utf8ToString());
                error.append("\nBut got: ").append(showBytes ? thisRoundBytes : thisRoundBytes.utf8ToString());
                AbstractSerializationTestCase.fail((String)error.toString());
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

