/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.template.delete.DeleteComponentTemplateAction;
import org.elasticsearch.action.admin.indices.template.delete.DeleteComposableIndexTemplateAction;
import org.elasticsearch.action.admin.indices.template.get.GetComponentTemplateAction;
import org.elasticsearch.action.admin.indices.template.get.GetComposableIndexTemplateAction;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.elasticsearch.action.datastreams.DeleteDataStreamAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.indices.IndexTemplateMissingException;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;

public abstract class TestCluster
implements Closeable {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    private final long seed;
    protected Random random;

    public TestCluster(long seed) {
        this.seed = seed;
    }

    public long seed() {
        return this.seed;
    }

    public void beforeTest(Random randomGenerator) throws IOException, InterruptedException {
        this.random = new Random(randomGenerator.nextLong());
    }

    public void wipe(Set<String> excludeTemplates) {
        this.wipeAllDataStreams();
        this.wipeAllComposableIndexTemplates(excludeTemplates);
        this.wipeAllComponentTemplates(excludeTemplates);
        this.wipeIndices("_all");
        this.wipeAllTemplates(excludeTemplates);
        this.wipeRepositories(new String[0]);
    }

    public void beforeIndexDeletion() throws Exception {
    }

    public void assertAfterTest() throws Exception {
        this.ensureEstimatedStats();
    }

    public abstract void afterTest() throws IOException;

    public abstract Client client();

    public abstract int size();

    public abstract int numDataNodes();

    public abstract int numDataAndMasterNodes();

    public abstract InetSocketAddress[] httpAddresses();

    @Override
    public abstract void close() throws IOException;

    public void wipeIndices(String ... indices) {
        block6: {
            assert (indices != null && indices.length > 0);
            if (this.size() > 0) {
                try {
                    ElasticsearchAssertions.assertAcked(this.client().admin().indices().prepareDelete(indices).setIndicesOptions(IndicesOptions.fromOptions((boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)false, (boolean)false, (boolean)true, (boolean)false)));
                }
                catch (IndexNotFoundException indexNotFoundException) {
                }
                catch (IllegalArgumentException e) {
                    if (!"_all".equals(indices[0])) break block6;
                    ClusterStateResponse clusterStateResponse = (ClusterStateResponse)this.client().admin().cluster().prepareState().execute().actionGet();
                    ArrayList<String> concreteIndices = new ArrayList<String>();
                    for (IndexMetadata indexMetadata : clusterStateResponse.getState().metadata()) {
                        concreteIndices.add(indexMetadata.getIndex().getName());
                    }
                    if (concreteIndices.isEmpty()) break block6;
                    ElasticsearchAssertions.assertAcked(this.client().admin().indices().prepareDelete(concreteIndices.toArray(new String[0])));
                }
            }
        }
    }

    public void wipeAllTemplates(Set<String> exclude) {
        if (this.size() > 0) {
            GetIndexTemplatesResponse response = (GetIndexTemplatesResponse)this.client().admin().indices().prepareGetTemplates(new String[0]).get();
            for (IndexTemplateMetadata indexTemplate : response.getIndexTemplates()) {
                if (exclude.contains(indexTemplate.getName())) continue;
                try {
                    this.client().admin().indices().prepareDeleteTemplate(indexTemplate.getName()).execute().actionGet();
                }
                catch (IndexTemplateMissingException indexTemplateMissingException) {}
            }
        }
    }

    public void wipeTemplates(String ... templates) {
        if (this.size() > 0) {
            if (templates.length == 0) {
                templates = new String[]{"*"};
            }
            for (String template : templates) {
                try {
                    this.client().admin().indices().prepareDeleteTemplate(template).execute().actionGet();
                }
                catch (IndexTemplateMissingException indexTemplateMissingException) {
                    // empty catch block
                }
            }
        }
    }

    public void wipeRepositories(String ... repositories) {
        if (this.size() > 0) {
            if (repositories.length == 0) {
                repositories = new String[]{"*"};
            }
            for (String repository : repositories) {
                try {
                    this.client().admin().cluster().prepareDeleteRepository(repository).execute().actionGet();
                }
                catch (RepositoryMissingException repositoryMissingException) {
                    // empty catch block
                }
            }
        }
    }

    public void wipeAllDataStreams() {
        block3: {
            if (this.size() > 0) {
                DeleteDataStreamAction.Request request = new DeleteDataStreamAction.Request(new String[]{"*"});
                request.indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED_HIDDEN);
                try {
                    ElasticsearchAssertions.assertAcked((AcknowledgedResponse)this.client().execute((ActionType)DeleteDataStreamAction.INSTANCE, (ActionRequest)request).actionGet());
                }
                catch (IllegalStateException e) {
                    if (e.getMessage().startsWith("failed to find action")) break block3;
                    throw e;
                }
            }
        }
    }

    public void wipeAllComposableIndexTemplates(Set<String> excludeTemplates) {
        String[] templates;
        if (this.size() > 0 && (templates = (String[])((GetComposableIndexTemplateAction.Response)this.client().execute((ActionType)GetComposableIndexTemplateAction.INSTANCE, (ActionRequest)new GetComposableIndexTemplateAction.Request("*")).actionGet()).indexTemplates().keySet().stream().filter(template -> !excludeTemplates.contains(template)).toArray(String[]::new)).length != 0) {
            DeleteComposableIndexTemplateAction.Request request = new DeleteComposableIndexTemplateAction.Request(templates);
            ElasticsearchAssertions.assertAcked((AcknowledgedResponse)this.client().execute((ActionType)DeleteComposableIndexTemplateAction.INSTANCE, (ActionRequest)request).actionGet());
        }
    }

    public void wipeAllComponentTemplates(Set<String> excludeTemplates) {
        String[] templates;
        if (this.size() > 0 && (templates = (String[])((GetComponentTemplateAction.Response)this.client().execute((ActionType)GetComponentTemplateAction.INSTANCE, (ActionRequest)new GetComponentTemplateAction.Request("*")).actionGet()).getComponentTemplates().keySet().stream().filter(template -> !excludeTemplates.contains(template)).toArray(String[]::new)).length != 0) {
            DeleteComponentTemplateAction.Request request = new DeleteComponentTemplateAction.Request(templates);
            ElasticsearchAssertions.assertAcked((AcknowledgedResponse)this.client().execute((ActionType)DeleteComponentTemplateAction.INSTANCE, (ActionRequest)request).actionGet());
        }
    }

    public abstract void ensureEstimatedStats();

    public abstract String getClusterName();

    public abstract Iterable<Client> getClients();

    public abstract NamedWriteableRegistry getNamedWriteableRegistry();
}

