/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.disruption;

import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.core.util.Throwables;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.test.InternalTestCluster;
import org.elasticsearch.test.disruption.SingleNodeDisruption;

public class BlockMasterServiceOnMaster
extends SingleNodeDisruption {
    AtomicReference<CountDownLatch> disruptionLatch = new AtomicReference();

    public BlockMasterServiceOnMaster(Random random) {
        super(random);
    }

    @Override
    public void startDisrupting() {
        this.disruptedNode = this.cluster.getMasterName();
        String disruptionNodeCopy = this.disruptedNode;
        if (disruptionNodeCopy == null) {
            return;
        }
        ClusterService clusterService = this.cluster.getInstance(ClusterService.class, disruptionNodeCopy);
        if (clusterService == null) {
            return;
        }
        this.logger.info("blocking master service on node [{}]", (Object)disruptionNodeCopy);
        boolean success = this.disruptionLatch.compareAndSet(null, new CountDownLatch(1));
        assert (success) : "startDisrupting called without waiting on stopDisrupting to complete";
        final CountDownLatch started = new CountDownLatch(1);
        clusterService.getMasterService().submitUnbatchedStateUpdateTask("service_disruption_block", new ClusterStateUpdateTask(Priority.IMMEDIATE){

            public ClusterState execute(ClusterState currentState) throws Exception {
                started.countDown();
                CountDownLatch latch = BlockMasterServiceOnMaster.this.disruptionLatch.get();
                if (latch != null) {
                    try {
                        latch.await();
                    }
                    catch (InterruptedException e) {
                        Throwables.rethrow((Throwable)e);
                    }
                }
                return currentState;
            }

            public void onFailure(Exception e) {
                BlockMasterServiceOnMaster.this.logger.error("unexpected error during disruption", (Throwable)e);
            }
        });
        try {
            started.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void stopDisrupting() {
        CountDownLatch latch = this.disruptionLatch.get();
        if (latch != null) {
            latch.countDown();
        }
    }

    @Override
    public void removeAndEnsureHealthy(InternalTestCluster cluster) {
        this.removeFromCluster(cluster);
    }

    @Override
    public TimeValue expectedTimeToHeal() {
        return TimeValue.timeValueMinutes((long)0L);
    }
}

