/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination.stateless;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.coordination.stateless.Heartbeat;
import org.elasticsearch.cluster.coordination.stateless.HeartbeatStore;

public abstract class DisruptibleHeartbeatStore
implements HeartbeatStore {
    private final HeartbeatStore delegate;

    protected DisruptibleHeartbeatStore(HeartbeatStore delegate) {
        this.delegate = delegate;
    }

    protected abstract boolean isDisrupted();

    public final void writeHeartbeat(Heartbeat newHeartbeat, ActionListener<Void> listener) {
        if (this.isDisrupted()) {
            listener.onFailure((Exception)new IOException("simulating disrupted access to shared store"));
        } else {
            this.delegate.writeHeartbeat(newHeartbeat, listener);
        }
    }

    public final void readLatestHeartbeat(ActionListener<Heartbeat> listener) {
        if (this.isDisrupted()) {
            listener.onFailure((Exception)new IOException("simulating disrupted access to shared store"));
        } else {
            this.delegate.readLatestHeartbeat(listener);
        }
    }
}

