/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.lookup.FieldLookup;
import org.elasticsearch.search.lookup.LeafSearchLookup;
import org.elasticsearch.search.lookup.LeafStoredFieldsLookup;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.xcontent.XContentType;
import org.mockito.Mockito;

public abstract class FieldTypeTestCase
extends ESTestCase {
    public static final SearchExecutionContext MOCK_CONTEXT = FieldTypeTestCase.createMockSearchExecutionContext(true);
    public static final SearchExecutionContext MOCK_CONTEXT_DISALLOW_EXPENSIVE = FieldTypeTestCase.createMockSearchExecutionContext(false);

    protected SearchExecutionContext randomMockContext() {
        return FieldTypeTestCase.randomFrom(MOCK_CONTEXT, MOCK_CONTEXT_DISALLOW_EXPENSIVE);
    }

    private static SearchExecutionContext createMockSearchExecutionContext(boolean allowExpensiveQueries) {
        SearchExecutionContext searchExecutionContext = (SearchExecutionContext)Mockito.mock(SearchExecutionContext.class);
        Mockito.when((Object)searchExecutionContext.allowExpensiveQueries()).thenReturn((Object)allowExpensiveQueries);
        Mockito.when((Object)searchExecutionContext.isSourceEnabled()).thenReturn((Object)true);
        SearchLookup searchLookup = (SearchLookup)Mockito.mock(SearchLookup.class);
        Mockito.when((Object)searchExecutionContext.lookup()).thenReturn((Object)searchLookup);
        Mockito.when((Object)searchExecutionContext.indexVersionCreated()).thenReturn((Object)Version.CURRENT);
        return searchExecutionContext;
    }

    public static List<?> fetchSourceValue(MappedFieldType fieldType, Object sourceValue) throws IOException {
        return FieldTypeTestCase.fetchSourceValue(fieldType, sourceValue, null);
    }

    public static List<?> fetchSourceValue(MappedFieldType fieldType, Object sourceValue, String format) throws IOException {
        String field = fieldType.name();
        SearchExecutionContext searchExecutionContext = (SearchExecutionContext)Mockito.mock(SearchExecutionContext.class);
        Mockito.when((Object)searchExecutionContext.isSourceEnabled()).thenReturn((Object)true);
        Mockito.when((Object)searchExecutionContext.sourcePath(field)).thenReturn(Set.of(field));
        ValueFetcher fetcher = fieldType.valueFetcher(searchExecutionContext, format);
        Source source = Source.fromMap(Collections.singletonMap(field, sourceValue), (XContentType)FieldTypeTestCase.randomFrom(XContentType.values()));
        return fetcher.fetchValues(source, -1, new ArrayList());
    }

    public static List<?> fetchSourceValues(MappedFieldType fieldType, Object ... values) throws IOException {
        String field = fieldType.name();
        SearchExecutionContext searchExecutionContext = (SearchExecutionContext)Mockito.mock(SearchExecutionContext.class);
        Mockito.when((Object)searchExecutionContext.isSourceEnabled()).thenReturn((Object)true);
        Mockito.when((Object)searchExecutionContext.sourcePath(field)).thenReturn(Set.of(field));
        ValueFetcher fetcher = fieldType.valueFetcher(searchExecutionContext, null);
        Source source = Source.fromMap(Collections.singletonMap(field, List.of(values)), (XContentType)FieldTypeTestCase.randomFrom(XContentType.values()));
        return fetcher.fetchValues(source, -1, new ArrayList());
    }

    public static List<?> fetchStoredValue(MappedFieldType fieldType, List<Object> storedValues, String format) throws IOException {
        String field = fieldType.name();
        SearchExecutionContext searchExecutionContext = (SearchExecutionContext)Mockito.mock(SearchExecutionContext.class);
        SearchLookup searchLookup = (SearchLookup)Mockito.mock(SearchLookup.class);
        LeafSearchLookup leafSearchLookup = (LeafSearchLookup)Mockito.mock(LeafSearchLookup.class);
        LeafStoredFieldsLookup leafStoredFieldsLookup = (LeafStoredFieldsLookup)Mockito.mock(LeafStoredFieldsLookup.class);
        FieldLookup fieldLookup = (FieldLookup)Mockito.mock(FieldLookup.class);
        Mockito.when((Object)searchExecutionContext.lookup()).thenReturn((Object)searchLookup);
        Mockito.when((Object)searchLookup.getLeafSearchLookup(null)).thenReturn((Object)leafSearchLookup);
        Mockito.when((Object)leafSearchLookup.fields()).thenReturn((Object)leafStoredFieldsLookup);
        Mockito.when((Object)leafStoredFieldsLookup.get((Object)field)).thenReturn((Object)fieldLookup);
        Mockito.when((Object)fieldLookup.getValues()).thenReturn(storedValues);
        ValueFetcher fetcher = fieldType.valueFetcher(searchExecutionContext, format);
        fetcher.setNextReader(null);
        return fetcher.fetchValues(null, -1, new ArrayList());
    }
}

