/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collections;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.TermBasedFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;

public class MockFieldMapper
extends FieldMapper {
    public MockFieldMapper(String fullName) {
        this((MappedFieldType)new FakeFieldType(fullName));
    }

    public MockFieldMapper(MappedFieldType fieldType) {
        this(MockFieldMapper.findSimpleName(fieldType.name()), fieldType, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
    }

    public MockFieldMapper(String fullName, MappedFieldType fieldType, FieldMapper.MultiFields multifields, FieldMapper.CopyTo copyTo) {
        super(MockFieldMapper.findSimpleName(fullName), fieldType, multifields, copyTo, false, null);
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName());
    }

    static String findSimpleName(String fullName) {
        int ndx = fullName.lastIndexOf(46);
        return fullName.substring(ndx + 1);
    }

    protected String contentType() {
        return null;
    }

    protected void parseCreateField(DocumentParserContext context) {
    }

    public static class FakeFieldType
    extends TermBasedFieldType {
        public FakeFieldType(String name) {
            super(name, true, false, false, TextSearchInfo.SIMPLE_MATCH_ONLY, Collections.emptyMap());
        }

        public String typeName() {
            return "faketype";
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            throw new UnsupportedOperationException();
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final MappedFieldType fieldType;

        protected Builder(String name) {
            super(name);
            this.fieldType = new FakeFieldType(name);
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return FieldMapper.EMPTY_PARAMETERS;
        }

        public Builder addMultiField(Builder builder) {
            this.multiFieldsBuilder.add((FieldMapper.Builder)builder);
            return this;
        }

        public Builder copyTo(String field) {
            this.copyTo.add(field);
            return this;
        }

        public MockFieldMapper build(MapperBuilderContext context) {
            FieldMapper.MultiFields multiFields = this.multiFieldsBuilder.build((Mapper.Builder)this, context);
            return new MockFieldMapper(this.name(), this.fieldType, multiFields, this.copyTo.build());
        }
    }
}

