/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.CompositeReaderContext;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.sandbox.document.HalfFloatPoint;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.Directory;
import org.apache.lucene.tests.analysis.MockAnalyzer;
import org.apache.lucene.tests.index.AssertingDirectoryReader;
import org.apache.lucene.tests.index.RandomIndexWriter;
import org.apache.lucene.tests.search.AssertingIndexSearcher;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.TriConsumer;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.index.ElasticsearchDirectoryReader;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.MockBigArrays;
import org.elasticsearch.common.util.MockPageCacheRecycler;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.cache.query.DisabledQueryCache;
import org.elasticsearch.index.cache.query.TrivialQueryCachingPolicy;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.mapper.BinaryFieldMapper;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.FieldAliasMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.GeoPointFieldMapper;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.MockFieldMapper;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.RangeFieldMapper;
import org.elasticsearch.index.mapper.RangeType;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.CrankyCircuitBreakerService;
import org.elasticsearch.indices.IndicesModule;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.NestedDocuments;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.MultiBucketCollector;
import org.elasticsearch.search.aggregations.MultiBucketConsumerService;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.MultiValueAggregation;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.search.aggregations.support.TimeSeriesIndexSearcher;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.fetch.subphase.FetchDocValuesPhase;
import org.elasticsearch.search.fetch.subphase.FetchSourcePhase;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.SubSearchContext;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.InternalAggregationTestCase;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.mockito.Mockito;

public abstract class AggregatorTestCase
extends ESTestCase {
    private NamedWriteableRegistry namedWriteableRegistry;
    private List<AggregationContext> releasables = new ArrayList<AggregationContext>();
    protected ValuesSourceRegistry valuesSourceRegistry;
    private AnalysisModule analysisModule;
    private static final List<String> TYPE_TEST_BLACKLIST = List.of("object", "geo_shape", "dense_vector", "sparse_vector", "nested", "completion", "alias");

    @Before
    public final void initPlugins() {
        ArrayList<SearchPlugin> plugins = new ArrayList<SearchPlugin>(this.getSearchPlugins());
        plugins.add(new AggCardinalityUpperBoundPlugin());
        SearchModule searchModule = new SearchModule(Settings.EMPTY, plugins);
        this.valuesSourceRegistry = searchModule.getValuesSourceRegistry();
        this.namedWriteableRegistry = new NamedWriteableRegistry(Stream.concat(searchModule.getNamedWriteables().stream(), plugins.stream().flatMap(p -> p instanceof Plugin ? ((Plugin)p).getNamedWriteables().stream() : Stream.empty())).collect(Collectors.toList()));
    }

    @Before
    public void initAnalysisRegistry() throws Exception {
        this.analysisModule = this.createAnalysisModule();
    }

    protected AnalysisModule createAnalysisModule() throws Exception {
        return null;
    }

    protected List<SearchPlugin> getSearchPlugins() {
        return List.of();
    }

    @Deprecated
    protected <A extends Aggregator> A createAggregator(AggregationBuilder aggregationBuilder, IndexSearcher searcher, MappedFieldType ... fieldTypes) throws IOException {
        return this.createAggregator(aggregationBuilder, this.createAggregationContext(searcher, (Query)new MatchAllDocsQuery(), fieldTypes));
    }

    @Deprecated
    protected <A extends Aggregator> A createAggregator(AggregationBuilder builder, AggregationContext context) throws IOException {
        QueryRewriteContext rewriteContext = new QueryRewriteContext(this.parserConfig(), new NamedWriteableRegistry(List.of()), null, () -> ((AggregationContext)context).nowInMillis());
        Aggregator aggregator = ((AggregationBuilder)Rewriteable.rewrite((Rewriteable)builder, (QueryRewriteContext)rewriteContext, (boolean)true)).build(context, null).create(null, CardinalityUpperBound.ONE);
        return (A)aggregator;
    }

    @Deprecated
    protected AggregationContext createAggregationContext(IndexSearcher indexSearcher, Query query, MappedFieldType ... fieldTypes) throws IOException {
        return this.createAggregationContext(indexSearcher, this.createIndexSettings(), query, (CircuitBreakerService)new NoneCircuitBreakerService(), 30720L, 100000, false, fieldTypes);
    }

    @Deprecated
    protected AggregationContext createAggregationContext(IndexSearcher indexSearcher, IndexSettings indexSettings, Query query, CircuitBreakerService breakerService, long bytesToPreallocate, int maxBucket, boolean isInSortOrderExecutionRequired, MappedFieldType ... fieldTypes) throws IOException {
        MappingLookup mappingLookup = MappingLookup.fromMappers((Mapping)Mapping.EMPTY, (Collection)Arrays.stream(fieldTypes).map(this::buildMockFieldMapper).collect(Collectors.toList()), this.objectMappers(), (Collection)Arrays.stream(fieldTypes).map(ft -> new FieldAliasMapper(ft.name() + "-alias", ft.name() + "-alias", ft.name())).collect(Collectors.toList()));
        BiFunction<MappedFieldType, FieldDataContext, IndexFieldData> fieldDataBuilder = (fieldType, context) -> fieldType.fielddataBuilder(new FieldDataContext(indexSettings.getIndex().getName(), context.lookupSupplier(), context.sourcePathsLookup(), context.fielddataOperation())).build((IndexFieldDataCache)new IndexFieldDataCache.None(), breakerService);
        BitsetFilterCache bitsetFilterCache = new BitsetFilterCache(indexSettings, new BitsetFilterCache.Listener(){

            public void onRemoval(ShardId shardId, Accountable accountable) {
            }

            public void onCache(ShardId shardId, Accountable accountable) {
            }
        });
        SearchExecutionContext searchExecutionContext = new SearchExecutionContext(0, -1, indexSettings, bitsetFilterCache, fieldDataBuilder, null, mappingLookup, null, this.getMockScriptService(), this.parserConfig(), this.writableRegistry(), null, indexSearcher, System::currentTimeMillis, null, null, () -> true, this.valuesSourceRegistry, Collections.emptyMap());
        MultiBucketConsumerService.MultiBucketConsumer consumer = new MultiBucketConsumerService.MultiBucketConsumer(maxBucket, breakerService.getBreaker("request"));
        AggregationContext.ProductionAggregationContext context2 = new AggregationContext.ProductionAggregationContext((AnalysisRegistry)Optional.ofNullable(this.analysisModule).map(AnalysisModule::getAnalysisRegistry).orElse(null), searchExecutionContext, (BigArrays)new MockBigArrays((PageCacheRecycler)new MockPageCacheRecycler(Settings.EMPTY), breakerService), bytesToPreallocate, () -> query, null, consumer, () -> this.buildSubSearchContext(indexSettings, searchExecutionContext, bitsetFilterCache), bitsetFilterCache, AggregatorTestCase.randomInt(), () -> 0L, () -> false, q -> q, true, isInSortOrderExecutionRequired);
        return context2;
    }

    protected FieldMapper buildMockFieldMapper(MappedFieldType ft) {
        return new MockFieldMapper(ft);
    }

    protected List<ObjectMapper> objectMappers() {
        return List.of();
    }

    private SubSearchContext buildSubSearchContext(IndexSettings indexSettings, SearchExecutionContext searchExecutionContext, BitsetFilterCache bitsetFilterCache) {
        SearchContext ctx = (SearchContext)Mockito.mock(SearchContext.class);
        try {
            Mockito.when((Object)ctx.searcher()).thenReturn((Object)new ContextIndexSearcher(searchExecutionContext.searcher().getIndexReader(), searchExecutionContext.searcher().getSimilarity(), (QueryCache)DisabledQueryCache.INSTANCE, (QueryCachingPolicy)TrivialQueryCachingPolicy.NEVER, false));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Mockito.when((Object)ctx.fetchPhase()).thenReturn((Object)new FetchPhase(Arrays.asList(new FetchSourcePhase(), new FetchDocValuesPhase())));
        SearchExecutionContext subContext = (SearchExecutionContext)Mockito.spy((Object)searchExecutionContext);
        MappingLookup disableNestedLookup = MappingLookup.fromMappers((Mapping)Mapping.EMPTY, Set.of(), Set.of(), Set.of());
        ((SearchExecutionContext)Mockito.doReturn((Object)new NestedDocuments(disableNestedLookup, arg_0 -> ((BitsetFilterCache)bitsetFilterCache).getBitSetProducer(arg_0), indexSettings.getIndexVersionCreated())).when((Object)subContext)).getNestedDocuments();
        Mockito.when((Object)ctx.getSearchExecutionContext()).thenReturn((Object)subContext);
        IndexShard indexShard = (IndexShard)Mockito.mock(IndexShard.class);
        Mockito.when((Object)indexShard.shardId()).thenReturn((Object)new ShardId("test", "test", 0));
        Mockito.when((Object)indexShard.indexSettings()).thenReturn((Object)indexSettings);
        Mockito.when((Object)ctx.indexShard()).thenReturn((Object)indexShard);
        Mockito.when((Object)ctx.newSourceLoader()).thenAnswer(inv -> searchExecutionContext.newSourceLoader(false));
        return new SubSearchContext(ctx);
    }

    protected IndexSettings createIndexSettings() {
        return new IndexSettings(IndexMetadata.builder((String)"_index").settings(Settings.builder().put("index.version.created", Version.CURRENT)).numberOfShards(1).numberOfReplicas(0).creationDate(System.currentTimeMillis()).build(), Settings.EMPTY);
    }

    protected ScriptService getMockScriptService() {
        return null;
    }

    protected <A extends InternalAggregation, C extends Aggregator> A searchAndReduce(IndexSearcher searcher, AggTestConfig aggTestConfig) throws IOException {
        IndexSettings indexSettings = this.createIndexSettings();
        this.runWithCrankyCircuitBreaker(indexSettings, searcher, aggTestConfig);
        NoneCircuitBreakerService breakerService = new NoneCircuitBreakerService();
        return this.searchAndReduce(indexSettings, searcher, (CircuitBreakerService)breakerService, aggTestConfig);
    }

    private void runWithCrankyCircuitBreaker(IndexSettings indexSettings, IndexSearcher searcher, AggTestConfig aggTestConfig) throws IOException {
        CrankyCircuitBreakerService crankyService = new CrankyCircuitBreakerService();
        for (int i = 0; i < 5; ++i) {
            try {
                this.searchAndReduce(indexSettings, searcher, crankyService, aggTestConfig);
                continue;
            }
            catch (CircuitBreakingException e) {
                AggregatorTestCase.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"cranky breaker"));
                continue;
            }
            catch (IOException e) {
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <A extends InternalAggregation, C extends Aggregator> A searchAndReduce(IndexSettings indexSettings, IndexSearcher searcher, CircuitBreakerService breakerService, AggTestConfig aggTestConfig) throws IOException {
        Query query = aggTestConfig.query();
        AggregationBuilder builder = aggTestConfig.builder();
        int maxBucket = aggTestConfig.maxBuckets();
        boolean splitLeavesIntoSeparateAggregators = aggTestConfig.splitLeavesIntoSeparateAggregators();
        boolean shouldBeCached = aggTestConfig.shouldBeCached();
        MappedFieldType[] fieldTypes = aggTestConfig.fieldTypes();
        IndexReaderContext ctx = searcher.getTopReaderContext();
        PipelineAggregator.PipelineTree pipelines = builder.buildPipelineTree();
        ArrayList<Object> aggs = new ArrayList<InternalAggregation>();
        Query rewritten = searcher.rewrite(query);
        if (splitLeavesIntoSeparateAggregators && searcher.getIndexReader().leaves().size() > 0 && !builder.isInSortOrderExecutionRequired()) {
            AggregatorTestCase.assertThat((Object)ctx, (Matcher)Matchers.instanceOf(CompositeReaderContext.class));
            CompositeReaderContext compCTX = (CompositeReaderContext)ctx;
            int size = compCTX.leaves().size();
            ShardSearcher[] subSearchers = new ShardSearcher[size];
            for (int searcherIDX = 0; searcherIDX < subSearchers.length; ++searcherIDX) {
                LeafReaderContext leave = (LeafReaderContext)compCTX.leaves().get(searcherIDX);
                subSearchers[searcherIDX] = new ShardSearcher(leave, (IndexReaderContext)compCTX);
            }
            for (ShardSearcher subSearcher : subSearchers) {
                AggregationContext context = this.createAggregationContext((IndexSearcher)subSearcher, indexSettings, query, breakerService, AggregatorTestCase.randomBoolean() ? 0L : builder.bytesToPreallocate(), maxBucket, builder.isInSortOrderExecutionRequired(), fieldTypes);
                try {
                    A a = this.createAggregator(builder, context);
                    a.preCollection();
                    if (context.isInSortOrderExecutionRequired()) {
                        new TimeSeriesIndexSearcher((IndexSearcher)subSearcher, List.of()).search(rewritten, a);
                    } else {
                        Weight weight = subSearcher.createWeight(rewritten, ScoreMode.COMPLETE, 1.0f);
                        subSearcher.search(weight, a.asCollector());
                    }
                    a.postCollection();
                    AggregatorTestCase.assertEquals((Object)shouldBeCached, (Object)context.isCacheable());
                    aggs.add(a.buildTopLevel());
                }
                finally {
                    Releasables.close((Releasable)context);
                }
            }
        } else {
            AggregationContext context = this.createAggregationContext(searcher, indexSettings, query, breakerService, AggregatorTestCase.randomBoolean() ? 0L : builder.bytesToPreallocate(), maxBucket, builder.isInSortOrderExecutionRequired(), fieldTypes);
            try {
                A root = this.createAggregator(builder, context);
                root.preCollection();
                if (context.isInSortOrderExecutionRequired()) {
                    new TimeSeriesIndexSearcher(searcher, List.of()).search(rewritten, MultiBucketCollector.wrap((boolean)true, List.of(root)));
                } else {
                    searcher.search(rewritten, MultiBucketCollector.wrap((boolean)true, List.of(root)).asCollector());
                }
                root.postCollection();
                aggs.add(root.buildTopLevel());
            }
            finally {
                Releasables.close((Releasable)context);
            }
        }
        this.assertRoundTrip(aggs);
        MockBigArrays bigArraysForReduction = new MockBigArrays((PageCacheRecycler)new MockPageCacheRecycler(Settings.EMPTY), breakerService);
        try {
            if (aggTestConfig.incrementalReduce() && aggs.size() > 1) {
                int toReduceSize = aggs.size();
                Collections.shuffle(aggs, AggregatorTestCase.random());
                int r = AggregatorTestCase.randomIntBetween(1, toReduceSize);
                List toReduce = aggs.subList(0, r);
                AggregationReduceContext.ForPartial reduceContext = new AggregationReduceContext.ForPartial((BigArrays)bigArraysForReduction, this.getMockScriptService(), () -> false, builder);
                InternalAggregation reduced = ((InternalAggregation)aggs.get(0)).reduce(toReduce, (AggregationReduceContext)reduceContext);
                aggs = new ArrayList(aggs.subList(r, toReduceSize));
                aggs.add(reduced);
                this.assertRoundTrip(aggs);
            }
            MultiBucketConsumerService.MultiBucketConsumer reduceBucketConsumer = new MultiBucketConsumerService.MultiBucketConsumer(maxBucket, new NoneCircuitBreakerService().getBreaker("request"));
            AggregationReduceContext.ForFinal reduceContext = new AggregationReduceContext.ForFinal((BigArrays)bigArraysForReduction, this.getMockScriptService(), () -> false, builder, (IntConsumer)reduceBucketConsumer, pipelines);
            InternalAggregation internalAgg = ((InternalAggregation)aggs.get(0)).reduce(aggs, (AggregationReduceContext)reduceContext);
            this.assertRoundTrip(internalAgg);
            internalAgg = internalAgg.reducePipelines(internalAgg, (AggregationReduceContext)reduceContext, pipelines);
            for (PipelineAggregator pipelineAggregator : pipelines.aggregators()) {
                internalAgg = pipelineAggregator.reduce(internalAgg, (AggregationReduceContext)reduceContext);
            }
            this.doAssertReducedMultiBucketConsumer((Aggregation)internalAgg, reduceBucketConsumer);
            this.assertRoundTrip(internalAgg);
            if (builder instanceof ValuesSourceAggregationBuilder.MetricsAggregationBuilder) {
                this.verifyMetricNames((ValuesSourceAggregationBuilder.MetricsAggregationBuilder)builder, internalAgg);
            }
            InternalAggregation internalAggregation = internalAgg;
            return (A)internalAggregation;
        }
        finally {
            Releasables.close((Releasable)breakerService);
        }
    }

    protected void doAssertReducedMultiBucketConsumer(Aggregation agg, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer) {
        InternalAggregationTestCase.assertMultiBucketConsumer(agg, bucketConsumer);
    }

    protected <T extends AggregationBuilder, V extends InternalAggregation> void testCase(CheckedConsumer<RandomIndexWriter, IOException> buildIndex, Consumer<V> verify, AggTestConfig aggTestConfig) throws IOException {
        boolean timeSeries = aggTestConfig.builder().isInSortOrderExecutionRequired();
        try (BaseDirectoryWrapper directory = AggregatorTestCase.newDirectory();){
            IndexWriterConfig config = LuceneTestCase.newIndexWriterConfig((Random)AggregatorTestCase.random(), (Analyzer)new MockAnalyzer(AggregatorTestCase.random()));
            if (timeSeries) {
                Sort sort = new Sort(new SortField[]{new SortField("_tsid", SortField.Type.STRING, false), new SortedNumericSortField("@timestamp", SortField.Type.LONG, true)});
                config.setIndexSort(sort);
            }
            RandomIndexWriter indexWriter = new RandomIndexWriter(AggregatorTestCase.random(), (Directory)directory, config);
            buildIndex.accept((Object)indexWriter);
            indexWriter.close();
            try (DirectoryReader unwrapped = DirectoryReader.open((Directory)directory);
                 IndexReader indexReader = this.wrapDirectoryReader(unwrapped);){
                IndexSearcher indexSearcher = AggregatorTestCase.newIndexSearcher(indexReader);
                Object agg = this.searchAndReduce(indexSearcher, aggTestConfig);
                verify.accept(agg);
                this.verifyOutputFieldNames((T)aggTestConfig.builder(), (V)agg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends AggregationBuilder, V extends InternalAggregation> void multiIndexTestCase(T aggregationBuilder, Query query, List<CheckedConsumer<RandomIndexWriter, IOException>> indexBuilders, Consumer<V> verify, MappedFieldType ... fieldTypes) throws IOException {
        IndexWriterConfig directories = new Directory[indexBuilders.size()];
        boolean timeSeries = aggregationBuilder.isInSortOrderExecutionRequired();
        try {
            for (int i = 0; i < indexBuilders.size(); ++i) {
                directories[i] = AggregatorTestCase.newDirectory();
                IndexWriterConfig config = LuceneTestCase.newIndexWriterConfig((Random)AggregatorTestCase.random(), (Analyzer)new MockAnalyzer(AggregatorTestCase.random()));
                if (timeSeries) {
                    Sort sort = new Sort(new SortField[]{new SortField("_tsid", SortField.Type.STRING, false), new SortedNumericSortField("@timestamp", SortField.Type.LONG, true)});
                    config.setIndexSort(sort);
                }
                RandomIndexWriter indexWriter = new RandomIndexWriter(AggregatorTestCase.random(), (Directory)directories[i], config);
                indexBuilders.get(i).accept((Object)indexWriter);
                indexWriter.close();
            }
            ArrayList<DirectoryReader> directoryReaders = new ArrayList<DirectoryReader>();
            try {
                for (IndexWriterConfig directory : directories) {
                    DirectoryReader open = DirectoryReader.open((Directory)directory);
                    directoryReaders.add(open);
                }
                DirectoryReader[] readers = directoryReaders.toArray(new DirectoryReader[0]);
                try (MultiReader multiReader = new MultiReader((IndexReader[])readers);){
                    IndexSearcher indexSearcher = AggregatorTestCase.newIndexSearcher((IndexReader)multiReader);
                    Object agg = this.searchAndReduce(indexSearcher, new AggTestConfig(aggregationBuilder, fieldTypes).withQuery(query));
                    verify.accept(agg);
                    this.verifyOutputFieldNames(aggregationBuilder, (V)agg);
                }
            }
            finally {
                IOUtils.close(directoryReaders);
            }
        }
        finally {
            IOUtils.close((Closeable[])directories);
        }
    }

    protected void withIndex(CheckedConsumer<RandomIndexWriter, IOException> buildIndex, CheckedConsumer<IndexSearcher, IOException> consume) throws IOException {
        try (BaseDirectoryWrapper directory = AggregatorTestCase.newDirectory();){
            RandomIndexWriter iw = new RandomIndexWriter(AggregatorTestCase.random(), (Directory)directory);
            buildIndex.accept((Object)iw);
            iw.close();
            try (DirectoryReader unwrapped = DirectoryReader.open((Directory)directory);
                 IndexReader indexReader = this.wrapDirectoryReader(unwrapped);){
                consume.accept((Object)AggregatorTestCase.newIndexSearcher(indexReader));
            }
        }
    }

    protected void withNonMergingIndex(CheckedConsumer<RandomIndexWriter, IOException> buildIndex, CheckedConsumer<IndexSearcher, IOException> consume) throws IOException {
        try (BaseDirectoryWrapper directory = AggregatorTestCase.newDirectory();){
            RandomIndexWriter iw = new RandomIndexWriter(AggregatorTestCase.random(), (Directory)directory, LuceneTestCase.newIndexWriterConfig((Random)AggregatorTestCase.random(), (Analyzer)new StandardAnalyzer()).setMergePolicy(NoMergePolicy.INSTANCE));
            buildIndex.accept((Object)iw);
            iw.close();
            try (DirectoryReader unwrapped = DirectoryReader.open((Directory)directory);
                 IndexReader indexReader = this.wrapDirectoryReader(unwrapped);){
                consume.accept((Object)AggregatorTestCase.newIndexSearcher(indexReader));
            }
        }
    }

    protected <R extends InternalAggregation> void debugTestCase(AggregationBuilder builder, Query query, CheckedConsumer<RandomIndexWriter, IOException> buildIndex, TriConsumer<R, Class<? extends Aggregator>, Map<String, Map<String, Object>>> verify, MappedFieldType ... fieldTypes) throws IOException {
        this.withIndex(buildIndex, (CheckedConsumer<IndexSearcher, IOException>)((CheckedConsumer)searcher -> this.debugTestCase(builder, query, (IndexSearcher)searcher, verify, fieldTypes)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <R extends InternalAggregation> void debugTestCase(AggregationBuilder builder, Query query, IndexSearcher searcher, TriConsumer<R, Class<? extends Aggregator>, Map<String, Map<String, Object>>> verify, MappedFieldType ... fieldTypes) throws IOException {
        NoneCircuitBreakerService breakerService = new NoneCircuitBreakerService();
        AggregationContext context = this.createAggregationContext(searcher, this.createIndexSettings(), searcher.rewrite(query), (CircuitBreakerService)breakerService, builder.bytesToPreallocate(), 100000, builder.isInSortOrderExecutionRequired(), fieldTypes);
        try {
            Object aggregator = this.createAggregator(builder, context);
            aggregator.preCollection();
            searcher.search(context.query(), aggregator.asCollector());
            aggregator.postCollection();
            InternalAggregation r = aggregator.buildTopLevel();
            InternalAggregation result = r = r.reduce(List.of(r), (AggregationReduceContext)new AggregationReduceContext.ForFinal(context.bigArrays(), this.getMockScriptService(), () -> false, builder, (IntConsumer)context.multiBucketConsumer(), builder.buildPipelineTree()));
            this.assertRoundTrip(result);
            HashMap<String, Map<String, Object>> debug = new HashMap<String, Map<String, Object>>();
            this.collectDebugInfo("", (Aggregator)aggregator, (Map<String, Map<String, Object>>)debug);
            verify.apply((Object)result, aggregator.getClass(), debug);
            this.verifyOutputFieldNames(builder, result);
        }
        finally {
            Releasables.close((Releasable)context);
        }
    }

    private void collectDebugInfo(String prefix, Aggregator aggregator, Map<String, Map<String, Object>> allDebug) {
        HashMap debug = new HashMap();
        aggregator.collectDebugInfo((key, value) -> {
            Object old = debug.put(key, value);
            AggregatorTestCase.assertNull((String)("debug info duplicate key [" + key + "] was [" + old + "] is [" + value + "]"), (Object)old);
        });
        allDebug.put(prefix + aggregator.name(), debug);
        for (Aggregator sub : aggregator.subAggregators()) {
            this.collectDebugInfo(aggregator.name() + ".", sub, allDebug);
        }
    }

    protected void withAggregator(AggregationBuilder aggregationBuilder, Query query, CheckedConsumer<RandomIndexWriter, IOException> buildIndex, CheckedBiConsumer<IndexSearcher, Aggregator, IOException> verify, MappedFieldType ... fieldTypes) throws IOException {
        try (BaseDirectoryWrapper directory = AggregatorTestCase.newDirectory();){
            RandomIndexWriter indexWriter = new RandomIndexWriter(AggregatorTestCase.random(), (Directory)directory);
            buildIndex.accept((Object)indexWriter);
            indexWriter.close();
            try (DirectoryReader unwrapped = DirectoryReader.open((Directory)directory);
                 IndexReader indexReader = this.wrapDirectoryReader(unwrapped);){
                IndexSearcher searcher = AggregatorTestCase.newIndexSearcher(indexReader);
                try (AggregationContext context = this.createAggregationContext(searcher, query, fieldTypes);){
                    verify.accept((Object)searcher, this.createAggregator(aggregationBuilder, context));
                }
            }
        }
    }

    private void verifyMetricNames(ValuesSourceAggregationBuilder.MetricsAggregationBuilder<?> aggregationBuilder, InternalAggregation agg) {
        for (String metric : aggregationBuilder.metricNames()) {
            try {
                agg.getProperty(List.of(metric));
            }
            catch (IllegalArgumentException ex) {
                AggregatorTestCase.fail((String)("Cannot access metric [" + metric + "]"));
            }
        }
    }

    protected <T extends AggregationBuilder, V extends InternalAggregation> void verifyOutputFieldNames(T aggregationBuilder, V agg) throws IOException {
        if (aggregationBuilder.getOutputFieldNames().isEmpty()) {
            return;
        }
        HashSet<String> valueNames = new HashSet<String>();
        if (agg instanceof NumericMetricsAggregation.MultiValue) {
            NumericMetricsAggregation.MultiValue multiValueAgg = (NumericMetricsAggregation.MultiValue)agg;
            for (String name : multiValueAgg.valueNames()) {
                valueNames.add(name);
            }
        } else if (agg instanceof MultiValueAggregation) {
            MultiValueAggregation multiValueAgg = (MultiValueAggregation)agg;
            for (String name : multiValueAgg.valueNames()) {
                valueNames.add(name);
            }
        } else assert (false) : "only multi value aggs are supported";
        AggregatorTestCase.assertEquals(aggregationBuilder.getOutputFieldNames().get(), valueNames);
    }

    protected IndexReader wrapDirectoryReader(DirectoryReader reader) throws IOException {
        return reader;
    }

    protected static DirectoryReader wrapInMockESDirectoryReader(DirectoryReader directoryReader) throws IOException {
        return ElasticsearchDirectoryReader.wrap((DirectoryReader)directoryReader, (ShardId)new ShardId(new Index("_index", "_na_"), 0));
    }

    protected static IndexSearcher newIndexSearcher(IndexReader indexReader) {
        if (AggregatorTestCase.randomBoolean()) {
            return new AssertingIndexSearcher(AggregatorTestCase.random(), indexReader);
        }
        return new IndexSearcher(indexReader);
    }

    protected static IndexReader maybeWrapReaderEs(DirectoryReader reader) throws IOException {
        if (AggregatorTestCase.randomBoolean()) {
            return new AssertingDirectoryReader(reader);
        }
        return reader;
    }

    protected List<ValuesSourceType> getSupportedValuesSourceTypes() {
        return Collections.emptyList();
    }

    protected AggregationBuilder createAggBuilderForTypeTest(MappedFieldType fieldType, String fieldName) {
        throw new UnsupportedOperationException("If getSupportedValuesSourceTypes() is implemented, createAggBuilderForTypeTest() must be implemented as well.");
    }

    protected List<String> unsupportedMappedFieldTypes() {
        return Collections.emptyList();
    }

    public void testSupportedFieldTypes() throws IOException {
        String fieldName = "typeTestFieldName";
        List<ValuesSourceType> supportedVSTypes = this.getSupportedValuesSourceTypes();
        List<String> unsupportedMappedFieldTypes = this.unsupportedMappedFieldTypes();
        if (supportedVSTypes.isEmpty()) {
            return;
        }
        for (Map.Entry mappedType : IndicesModule.getMappers(List.of()).entrySet()) {
            if (TYPE_TEST_BLACKLIST.contains(mappedType.getKey())) continue;
            HashMap source = new HashMap();
            source.put("type", mappedType.getKey());
            if (!((String)mappedType.getKey()).equals("text")) {
                source.put("doc_values", "true");
            }
            IndexSettings indexSettings = this.createIndexSettings();
            Mapper.Builder builder = ((Mapper.TypeParser)mappedType.getValue()).parse(fieldName, source, (MappingParserContext)new MockParserContext(indexSettings));
            FieldMapper mapper = (FieldMapper)builder.build(MapperBuilderContext.root((boolean)false));
            MappedFieldType fieldType = mapper.fieldType();
            if (!fieldType.isAggregatable()) continue;
            BaseDirectoryWrapper directory = AggregatorTestCase.newDirectory();
            try {
                RandomIndexWriter indexWriter = new RandomIndexWriter(AggregatorTestCase.random(), (Directory)directory);
                this.writeTestDoc(fieldType, fieldName, indexWriter);
                indexWriter.close();
                DirectoryReader indexReader = DirectoryReader.open((Directory)directory);
                try {
                    AssertionError failure;
                    block17: {
                        IndexSearcher indexSearcher = AggregatorTestCase.newIndexSearcher((IndexReader)indexReader);
                        AggregationBuilder aggregationBuilder = this.createAggBuilderForTypeTest(fieldType, fieldName);
                        ValuesSourceType vst = this.fieldToVST(fieldType);
                        failure = null;
                        try {
                            Object internalAggregation = this.searchAndReduce(indexSearcher, new AggTestConfig(aggregationBuilder, fieldType));
                            if (aggregationBuilder.supportsSampling()) {
                                SamplingContext randomSamplingContext = new SamplingContext(AggregatorTestCase.randomDoubleBetween(1.0E-8, 0.1, false), AggregatorTestCase.randomInt());
                                InternalAggregation sampledResult = internalAggregation.finalizeSampling(randomSamplingContext);
                                AggregatorTestCase.assertThat(sampledResult.getClass(), (Matcher)Matchers.equalTo(internalAggregation.getClass()));
                            }
                            if (!supportedVSTypes.contains(vst) || unsupportedMappedFieldTypes.contains(fieldType.typeName())) {
                                failure = new AssertionError((Object)("Aggregator [" + aggregationBuilder.getType() + "] should not support field type [" + fieldType.typeName() + "] but executing against the field did not throw an exception"));
                            }
                        }
                        catch (AssertionError | Exception e) {
                            if (!supportedVSTypes.contains(vst) || unsupportedMappedFieldTypes.contains(fieldType.typeName())) break block17;
                            failure = new AssertionError("Aggregator [" + aggregationBuilder.getType() + "] supports field type [" + fieldType.typeName() + "] but executing against the field threw an exception: [" + ((Throwable)e).getMessage() + "]", (Throwable)e);
                        }
                    }
                    if (failure == null) continue;
                    throw failure;
                }
                finally {
                    if (indexReader == null) continue;
                    indexReader.close();
                }
            }
            finally {
                if (directory == null) continue;
                directory.close();
            }
        }
    }

    private ValuesSourceType fieldToVST(MappedFieldType fieldType) {
        return fieldType.fielddataBuilder(FieldDataContext.noRuntimeFields((String)"test")).build(null, null).getValuesSourceType();
    }

    private void writeTestDoc(MappedFieldType fieldType, String fieldName, RandomIndexWriter iw) throws IOException {
        Object json;
        String typeName = fieldType.typeName();
        ValuesSourceType vst = this.fieldToVST(fieldType);
        Document doc = new Document();
        if (vst.equals(CoreValuesSourceType.NUMERIC)) {
            long v;
            if (typeName.equals(NumberFieldMapper.NumberType.DOUBLE.typeName())) {
                double d = Math.abs(AggregatorTestCase.randomDouble());
                v = NumericUtils.doubleToSortableLong((double)d);
                json = "{ \"" + fieldName + "\" : \"" + d + "\" }";
            } else if (typeName.equals(NumberFieldMapper.NumberType.FLOAT.typeName())) {
                float f = Math.abs(AggregatorTestCase.randomFloat());
                v = NumericUtils.floatToSortableInt((float)f);
                json = "{ \"" + fieldName + "\" : \"" + f + "\" }";
            } else if (typeName.equals(NumberFieldMapper.NumberType.HALF_FLOAT.typeName())) {
                float f = Math.abs((AggregatorTestCase.randomFloat() * 2.0f - 1.0f) * 65504.0f);
                v = HalfFloatPoint.halfFloatToSortableShort((float)f);
                json = "{ \"" + fieldName + "\" : \"" + f + "\" }";
            } else {
                v = Math.abs(AggregatorTestCase.randomByte());
                json = "{ \"" + fieldName + "\" : \"" + v + "\" }";
            }
            doc.add((IndexableField)new SortedNumericDocValuesField(fieldName, v));
        } else if (vst.equals(CoreValuesSourceType.KEYWORD)) {
            if (typeName.equals("binary")) {
                doc.add((IndexableField)new BinaryFieldMapper.CustomBinaryDocValuesField(fieldName, new BytesRef((CharSequence)"a").bytes));
                json = "{ \"" + fieldName + "\" : \"a\" }";
            } else {
                doc.add((IndexableField)new SortedSetDocValuesField(fieldName, new BytesRef((CharSequence)"a")));
                json = "{ \"" + fieldName + "\" : \"a\" }";
            }
        } else if (vst.equals(CoreValuesSourceType.DATE)) {
            long v = Math.abs(AggregatorTestCase.randomInt());
            doc.add((IndexableField)new SortedNumericDocValuesField(fieldName, v));
            json = "{ \"" + fieldName + "\" : \"" + v + "\" }";
        } else if (vst.equals(CoreValuesSourceType.BOOLEAN)) {
            long v = AggregatorTestCase.randomBoolean() ? 0L : 1L;
            doc.add((IndexableField)new SortedNumericDocValuesField(fieldName, v));
            json = "{ \"" + fieldName + "\" : \"" + (v == 0L ? "false" : "true") + "\" }";
        } else if (vst.equals(CoreValuesSourceType.IP)) {
            InetAddress ip = AggregatorTestCase.randomIp(AggregatorTestCase.randomBoolean());
            json = "{ \"" + fieldName + "\" : \"" + NetworkAddress.format((InetAddress)ip) + "\" }";
            doc.add((IndexableField)new SortedSetDocValuesField(fieldName, new BytesRef(InetAddressPoint.encode((InetAddress)ip))));
        } else if (vst.equals(CoreValuesSourceType.RANGE)) {
            RangeType rangeType;
            Object end;
            Serializable start;
            if (typeName.equals(RangeType.DOUBLE.typeName())) {
                start = AggregatorTestCase.randomDouble();
                end = RangeType.DOUBLE.nextUp((Object)start);
                rangeType = RangeType.DOUBLE;
            } else if (typeName.equals(RangeType.FLOAT.typeName())) {
                start = Float.valueOf(AggregatorTestCase.randomFloat());
                end = RangeType.FLOAT.nextUp((Object)start);
                rangeType = RangeType.DOUBLE;
            } else if (typeName.equals(RangeType.IP.typeName())) {
                boolean v4 = AggregatorTestCase.randomBoolean();
                start = AggregatorTestCase.randomIp(v4);
                end = RangeType.IP.nextUp((Object)start);
                rangeType = RangeType.IP;
            } else if (typeName.equals(RangeType.LONG.typeName())) {
                start = AggregatorTestCase.randomLong();
                end = RangeType.LONG.nextUp((Object)start);
                rangeType = RangeType.LONG;
            } else if (typeName.equals(RangeType.INTEGER.typeName())) {
                start = AggregatorTestCase.randomInt();
                end = RangeType.INTEGER.nextUp((Object)start);
                rangeType = RangeType.INTEGER;
            } else if (typeName.equals(RangeType.DATE.typeName())) {
                start = AggregatorTestCase.randomNonNegativeLong();
                end = RangeType.DATE.nextUp((Object)start);
                rangeType = RangeType.DATE;
            } else {
                throw new IllegalStateException("Unknown type of range [" + typeName + "]");
            }
            RangeFieldMapper.Range range = new RangeFieldMapper.Range(rangeType, (Object)start, end, true, true);
            doc.add((IndexableField)new BinaryDocValuesField(fieldName, rangeType.encodeRanges(Collections.singleton(range))));
            json = Strings.format((String)"{ \"%s\" : { \"gte\" : \"%s\", \"lte\" : \"%s\" } }\n", (Object[])new Object[]{fieldName, start, end});
        } else if (vst.equals(CoreValuesSourceType.GEOPOINT)) {
            double lat = AggregatorTestCase.randomDouble();
            double lon = AggregatorTestCase.randomDouble();
            doc.add((IndexableField)new LatLonDocValuesField(fieldName, lat, lon));
            json = Strings.format((String)"{ \"%s\" : \"[%s,%s]\" }", (Object[])new Object[]{fieldName, lon, lat});
        } else {
            throw new IllegalStateException("Unknown field type [" + typeName + "]");
        }
        doc.add((IndexableField)new StoredField("_source", new BytesRef((CharSequence)json)));
        iw.addDocument((Iterable)doc);
    }

    @After
    public void cleanupReleasables() {
        Releasables.close(this.releasables);
        this.releasables.clear();
    }

    protected void afterClose() {
    }

    protected DateFieldMapper.DateFieldType dateField(String name, DateFieldMapper.Resolution resolution) {
        return new DateFieldMapper.DateFieldType(name, resolution);
    }

    protected NumberFieldMapper.NumberFieldType doubleField(String name) {
        return new NumberFieldMapper.NumberFieldType(name, NumberFieldMapper.NumberType.DOUBLE);
    }

    protected GeoPointFieldMapper.GeoPointFieldType geoPointField(String name) {
        return new GeoPointFieldMapper.GeoPointFieldType(name);
    }

    protected KeywordFieldMapper.KeywordFieldType keywordField(String name) {
        return new KeywordFieldMapper.KeywordFieldType(name);
    }

    protected NumberFieldMapper.NumberFieldType longField(String name) {
        return new NumberFieldMapper.NumberFieldType(name, NumberFieldMapper.NumberType.LONG);
    }

    protected RangeFieldMapper.RangeFieldType rangeField(String name, RangeType rangeType) {
        if (rangeType == RangeType.DATE) {
            return new RangeFieldMapper.RangeFieldType(name, RangeFieldMapper.Defaults.DATE_FORMATTER);
        }
        return new RangeFieldMapper.RangeFieldType(name, rangeType);
    }

    private void assertRoundTrip(List<InternalAggregation> result) throws IOException {
        for (InternalAggregation i : result) {
            this.assertRoundTrip(i);
        }
    }

    private void assertRoundTrip(InternalAggregation result) throws IOException {
        InternalAggregation roundTripped = AggregatorTestCase.copyNamedWriteable(result, this.writableRegistry(), InternalAggregation.class);
        AggregatorTestCase.assertThat((Object)roundTripped, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)result)));
        AggregatorTestCase.assertThat((Object)roundTripped, (Matcher)Matchers.equalTo((Object)result));
        AggregatorTestCase.assertThat((Object)roundTripped.hashCode(), (Matcher)Matchers.equalTo((Object)result.hashCode()));
    }

    @Override
    protected final NamedWriteableRegistry writableRegistry() {
        return this.namedWriteableRegistry;
    }

    public static AggregationBuilder aggCardinalityUpperBound(String name) {
        return new AggCardinalityUpperBoundAggregationBuilder(name);
    }

    private static class AggCardinalityUpperBoundPlugin
    implements SearchPlugin {
        private AggCardinalityUpperBoundPlugin() {
        }

        public List<SearchPlugin.AggregationSpec> getAggregations() {
            return Collections.singletonList(new SearchPlugin.AggregationSpec("ctor_cardinality_upper_bound", in -> null, (p, c) -> null).addResultReader(InternalAggCardinalityUpperBound::new));
        }
    }

    public record AggTestConfig(Query query, AggregationBuilder builder, int maxBuckets, boolean splitLeavesIntoSeparateAggregators, boolean shouldBeCached, boolean incrementalReduce, MappedFieldType[] fieldTypes) {
        public AggTestConfig(AggregationBuilder builder, MappedFieldType ... fieldTypes) {
            this((Query)new MatchAllDocsQuery(), builder, 100000, ESTestCase.randomBoolean(), true, ESTestCase.randomBoolean(), fieldTypes);
        }

        public AggTestConfig withQuery(Query query) {
            return new AggTestConfig(query, this.builder, this.maxBuckets, this.splitLeavesIntoSeparateAggregators, this.shouldBeCached, this.incrementalReduce, this.fieldTypes);
        }

        public AggTestConfig withSplitLeavesIntoSeperateAggregators(boolean splitLeavesIntoSeparateAggregators) {
            return new AggTestConfig(this.query, this.builder, this.maxBuckets, splitLeavesIntoSeparateAggregators, this.shouldBeCached, this.incrementalReduce, this.fieldTypes);
        }

        public AggTestConfig withShouldBeCached(boolean shouldBeCached) {
            return new AggTestConfig(this.query, this.builder, this.maxBuckets, this.splitLeavesIntoSeparateAggregators, shouldBeCached, this.incrementalReduce, this.fieldTypes);
        }

        public AggTestConfig withMaxBuckets(int maxBuckets) {
            return new AggTestConfig(this.query, this.builder, maxBuckets, this.splitLeavesIntoSeparateAggregators, this.shouldBeCached, this.incrementalReduce, this.fieldTypes);
        }

        public AggTestConfig withIncrementalReduce(boolean incrementalReduce) {
            return new AggTestConfig(this.query, this.builder, this.maxBuckets, this.splitLeavesIntoSeparateAggregators, this.shouldBeCached, incrementalReduce, this.fieldTypes);
        }
    }

    private static class ShardSearcher
    extends IndexSearcher {
        private final List<LeafReaderContext> ctx;

        ShardSearcher(LeafReaderContext ctx, IndexReaderContext parent) {
            super(parent);
            this.ctx = Collections.singletonList(ctx);
        }

        public void search(Weight weight, Collector collector) throws IOException {
            this.search(this.ctx, weight, collector);
        }

        public String toString() {
            return "ShardSearcher(" + this.ctx.get(0) + ")";
        }
    }

    private static class MockParserContext
    extends MappingParserContext {
        MockParserContext(IndexSettings indexSettings) {
            super(null, null, null, Version.CURRENT, () -> TransportVersion.CURRENT, null, ScriptCompiler.NONE, null, indexSettings, null);
        }

        public Settings getSettings() {
            return Settings.EMPTY;
        }

        public IndexAnalyzers getIndexAnalyzers() {
            return (type, name) -> Lucene.STANDARD_ANALYZER;
        }
    }

    private static class AggCardinalityUpperBoundAggregationBuilder
    extends AbstractAggregationBuilder<AggCardinalityUpperBoundAggregationBuilder> {
        AggCardinalityUpperBoundAggregationBuilder(String name) {
            super(name);
        }

        protected AggregatorFactory doBuild(AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subfactoriesBuilder) throws IOException {
            return new AggregatorFactory(this.name, context, parent, subfactoriesBuilder, this.metadata){

                protected Aggregator createInternal(Aggregator parent, final CardinalityUpperBound cardinality, final Map<String, Object> metadata) throws IOException {
                    return new MetricsAggregator(this.name, this.context, parent, metadata){

                        protected LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) {
                            return LeafBucketCollector.NO_OP_COLLECTOR;
                        }

                        public InternalAggregation buildAggregation(long owningBucketOrd) throws IOException {
                            return new InternalAggCardinalityUpperBound(this.name, cardinality, metadata);
                        }

                        public InternalAggregation buildEmptyAggregation() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }

        protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder;
        }

        public AggregationBuilder.BucketCardinality bucketCardinality() {
            return AggregationBuilder.BucketCardinality.ONE;
        }

        public String getType() {
            return "ctor_cardinality_upper_bound";
        }

        protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
            throw new UnsupportedOperationException();
        }

        protected void doWriteTo(StreamOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }

        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersion.ZERO;
        }
    }

    public static class InternalAggCardinalityUpperBound
    extends InternalAggregation {
        private static final String NAME = "ctor_cardinality_upper_bound";
        private final CardinalityUpperBound cardinality;

        protected InternalAggCardinalityUpperBound(String name, CardinalityUpperBound cardinality, Map<String, Object> metadata) {
            super(name, metadata);
            this.cardinality = cardinality;
        }

        public InternalAggCardinalityUpperBound(StreamInput in) throws IOException {
            super(in);
            this.cardinality = CardinalityUpperBound.ONE.multiply(in.readVInt());
        }

        protected void doWriteTo(StreamOutput out) throws IOException {
            out.writeVInt(((Integer)this.cardinality.map(i -> i)).intValue());
        }

        public CardinalityUpperBound cardinality() {
            return this.cardinality;
        }

        public InternalAggregation reduce(List<InternalAggregation> aggregations, AggregationReduceContext reduceContext) {
            aggregations.forEach(ia -> Assert.assertThat((Object)((InternalAggCardinalityUpperBound)ia).cardinality, (Matcher)Matchers.equalTo((Object)this.cardinality)));
            return new InternalAggCardinalityUpperBound(this.name, this.cardinality, this.metadata);
        }

        protected boolean mustReduceOnSingleInternalAgg() {
            return true;
        }

        public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.array("cardinality", new Object[]{this.cardinality});
        }

        public Object getProperty(List<String> path) {
            throw new UnsupportedOperationException();
        }

        public String getWriteableName() {
            return NAME;
        }
    }
}

