/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.geo;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Streams;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Polygon;
import org.elasticsearch.geometry.utils.WellKnownText;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.mapper.AbstractShapeGeometryFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractGeometryQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.geo.SpatialQueryBuilders;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class BaseShapeIntegTestCase<T extends AbstractGeometryQueryBuilder<T>>
extends ESIntegTestCase {
    protected abstract SpatialQueryBuilders<T> queryBuilder();

    protected abstract String getFieldTypeName();

    protected abstract void getGeoShapeMapping(XContentBuilder var1) throws IOException;

    protected abstract Version randomSupportedVersion();

    protected abstract boolean allowExpensiveQueries();

    @Override
    protected boolean forbidPrivateIndexSettings() {
        return false;
    }

    public void testOrientationPersistence() throws Exception {
        String idxName = "orientation";
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("properties").startObject("location");
        this.getGeoShapeMapping(mapping);
        mapping.field("orientation", "left").endObject().endObject().endObject();
        ElasticsearchAssertions.assertAcked(this.prepareCreate(idxName).setMapping(mapping).setSettings(BaseShapeIntegTestCase.settings(this.randomSupportedVersion()).build()));
        mapping = XContentFactory.jsonBuilder().startObject().startObject("properties").startObject("location");
        this.getGeoShapeMapping(mapping);
        mapping.field("orientation", "right").endObject().endObject().endObject();
        ElasticsearchAssertions.assertAcked(this.prepareCreate(idxName + "2").setMapping(mapping).setSettings(BaseShapeIntegTestCase.settings(this.randomSupportedVersion()).build()));
        this.ensureGreen(idxName, idxName + "2");
        BaseShapeIntegTestCase.internalCluster().fullRestart();
        this.ensureGreen(idxName, idxName + "2");
        IndicesService indicesService = BaseShapeIntegTestCase.internalCluster().getInstance(IndicesService.class, this.findNodeName(idxName));
        IndexService indexService = indicesService.indexService(BaseShapeIntegTestCase.resolveIndex(idxName));
        MappedFieldType fieldType = indexService.mapperService().fieldType("location");
        BaseShapeIntegTestCase.assertThat((Object)fieldType, (Matcher)Matchers.instanceOf(AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType.class));
        AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType gsfm = (AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType)fieldType;
        Orientation orientation = gsfm.orientation();
        BaseShapeIntegTestCase.assertThat((Object)orientation, (Matcher)Matchers.equalTo((Object)Orientation.CLOCKWISE));
        BaseShapeIntegTestCase.assertThat((Object)orientation, (Matcher)Matchers.equalTo((Object)Orientation.LEFT));
        BaseShapeIntegTestCase.assertThat((Object)orientation, (Matcher)Matchers.equalTo((Object)Orientation.CW));
        indicesService = BaseShapeIntegTestCase.internalCluster().getInstance(IndicesService.class, this.findNodeName(idxName + "2"));
        indexService = indicesService.indexService(BaseShapeIntegTestCase.resolveIndex(idxName + "2"));
        fieldType = indexService.mapperService().fieldType("location");
        BaseShapeIntegTestCase.assertThat((Object)fieldType, (Matcher)Matchers.instanceOf(AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType.class));
        gsfm = (AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType)fieldType;
        orientation = gsfm.orientation();
        BaseShapeIntegTestCase.assertThat((Object)orientation, (Matcher)Matchers.equalTo((Object)Orientation.COUNTER_CLOCKWISE));
        BaseShapeIntegTestCase.assertThat((Object)orientation, (Matcher)Matchers.equalTo((Object)Orientation.RIGHT));
        BaseShapeIntegTestCase.assertThat((Object)orientation, (Matcher)Matchers.equalTo((Object)Orientation.CCW));
    }

    public void testIgnoreMalformed() throws Exception {
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("properties").startObject("shape");
        this.getGeoShapeMapping(mapping);
        mapping.field("ignore_malformed", true).endObject().endObject().endObject();
        ElasticsearchAssertions.assertAcked(this.prepareCreate("test").setMapping(mapping).setSettings(BaseShapeIntegTestCase.settings(this.randomSupportedVersion()).build()));
        this.ensureGreen(new String[0]);
        String polygonGeoJson = Strings.toString((XContentBuilder)XContentFactory.jsonBuilder().startObject().field("type", "Polygon").startArray("coordinates").startArray().startArray().value(176.0).value(15.0).endArray().startArray().value(-177.0).value(10.0).endArray().startArray().value(-177.0).value(-10.0).endArray().startArray().value(176.0).value(-15.0).endArray().startArray().value(-177.0).value(15.0).endArray().startArray().value(172.0).value(0.0).endArray().startArray().value(176.0).value(15.0).endArray().endArray().endArray().endObject());
        this.indexRandom(true, BaseShapeIntegTestCase.client().prepareIndex("test").setId("0").setSource(new Object[]{"shape", polygonGeoJson}));
        SearchResponse searchResponse = (SearchResponse)BaseShapeIntegTestCase.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).get();
        BaseShapeIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
    }

    public void testIndexShapeRouting() throws Exception {
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("_doc").startObject("_routing").field("required", true).endObject().startObject("properties").startObject("shape");
        this.getGeoShapeMapping(mapping);
        mapping.endObject().endObject().endObject().endObject();
        ElasticsearchAssertions.assertAcked(this.prepareCreate("test").setMapping(mapping).setSettings(BaseShapeIntegTestCase.settings(this.randomSupportedVersion()).build()));
        this.ensureGreen(new String[0]);
        String source = "{\n    \"shape\" : {\n        \"type\" : \"bbox\",\n        \"coordinates\" : [[-45.0, 45.0], [45.0, -45.0]]\n    }\n}";
        this.indexRandom(true, BaseShapeIntegTestCase.client().prepareIndex("test").setId("0").setSource(source, XContentType.JSON).setRouting("ABC"));
        SearchResponse searchResponse = (SearchResponse)BaseShapeIntegTestCase.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery("shape", "0").indexedShapeIndex("test").indexedShapeRouting("ABC")).get();
        BaseShapeIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDisallowExpensiveQueries() throws InterruptedException, IOException {
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("properties").startObject("shape");
        this.getGeoShapeMapping(mapping);
        mapping.endObject().endObject().endObject();
        ElasticsearchAssertions.assertAcked((CreateIndexResponse)BaseShapeIntegTestCase.client().admin().indices().prepareCreate("test").setSettings(BaseShapeIntegTestCase.settings(this.randomSupportedVersion()).build()).setMapping(mapping).get());
        this.ensureGreen(new String[0]);
        String source = "{\n    \"shape\" : {\n        \"type\" : \"bbox\",\n        \"coordinates\" : [[-45.0, 45.0], [45.0, -45.0]]\n    }\n}";
        this.indexRandom(true, BaseShapeIntegTestCase.client().prepareIndex("test").setId("0").setSource(source, XContentType.JSON));
        this.refresh(new String[0]);
        try {
            BaseShapeIntegTestCase.updateClusterSettings(Settings.builder().put("search.allow_expensive_queries", false));
            SearchRequestBuilder builder = BaseShapeIntegTestCase.client().prepareSearch(new String[]{"test"}).setQuery(this.queryBuilder().shapeQuery("shape", (Geometry)new Circle(0.0, 0.0, 77000.0)));
            if (this.allowExpensiveQueries()) {
                BaseShapeIntegTestCase.assertThat((Object)((SearchResponse)builder.get()).getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
            } else {
                ElasticsearchException e = (ElasticsearchException)BaseShapeIntegTestCase.expectThrows(ElasticsearchException.class, () -> ((SearchRequestBuilder)builder).get());
                BaseShapeIntegTestCase.assertEquals((Object)"[geo-shape] queries on [PrefixTree geo shapes] cannot be executed when 'search.allow_expensive_queries' is set to false.", (Object)e.getCause().getMessage());
            }
            BaseShapeIntegTestCase.updateClusterSettings(Settings.builder().put("search.allow_expensive_queries", (String)null));
            BaseShapeIntegTestCase.assertThat((Object)((SearchResponse)builder.get()).getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
            BaseShapeIntegTestCase.updateClusterSettings(Settings.builder().put("search.allow_expensive_queries", true));
            BaseShapeIntegTestCase.assertThat((Object)((SearchResponse)builder.get()).getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        }
        finally {
            BaseShapeIntegTestCase.updateClusterSettings(Settings.builder().put("search.allow_expensive_queries", (String)null));
        }
    }

    public void testShapeRelations() throws Exception {
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("properties").startObject("area");
        this.getGeoShapeMapping(mapping);
        mapping.endObject().endObject().endObject();
        Version version = this.randomSupportedVersion();
        CreateIndexRequestBuilder mappingRequest = BaseShapeIntegTestCase.client().admin().indices().prepareCreate("shapes").setMapping(mapping).setSettings(BaseShapeIntegTestCase.settings(version).build());
        mappingRequest.get();
        BaseShapeIntegTestCase.client().admin().cluster().prepareHealth(new String[0]).setWaitForEvents(Priority.LANGUID).setWaitForGreenStatus().get();
        List<Polygon> polygons = List.of(new Polygon(new LinearRing(new double[]{-10.0, -10.0, 10.0, 10.0, -10.0}, new double[]{-10.0, 10.0, 10.0, -10.0, -10.0}), List.of(new LinearRing(new double[]{-5.0, -5.0, 5.0, 5.0, -5.0}, new double[]{-5.0, 5.0, 5.0, -5.0, -5.0}))), new Polygon(new LinearRing(new double[]{-4.0, -4.0, 4.0, 4.0, -4.0}, new double[]{-4.0, 4.0, 4.0, -4.0, -4.0})));
        BytesReference data = BytesReference.bytes((XContentBuilder)XContentFactory.jsonBuilder().startObject().field("area", WellKnownText.toWKT((Geometry)new MultiPolygon(polygons))).endObject());
        BaseShapeIntegTestCase.client().prepareIndex("shapes").setId("1").setSource(data, XContentType.JSON).get();
        BaseShapeIntegTestCase.client().admin().indices().prepareRefresh(new String[0]).get();
        SearchResponse result = (SearchResponse)BaseShapeIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter(this.queryBuilder().intersectionQuery("area", (Geometry)new Point(3.0, 3.0))).get();
        ElasticsearchAssertions.assertHitCount(result, 1L);
        ElasticsearchAssertions.assertFirstHit(result, ElasticsearchAssertions.hasId("1"));
        result = (SearchResponse)BaseShapeIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter(this.queryBuilder().intersectionQuery("area", (Geometry)new Point(4.5, 4.5))).get();
        ElasticsearchAssertions.assertHitCount(result, 0L);
        result = (SearchResponse)BaseShapeIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter(this.queryBuilder().intersectionQuery("area", (Geometry)new Point(10.0, 5.0))).get();
        ElasticsearchAssertions.assertHitCount(result, 1L);
        ElasticsearchAssertions.assertFirstHit(result, ElasticsearchAssertions.hasId("1"));
        result = (SearchResponse)BaseShapeIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter(this.queryBuilder().intersectionQuery("area", (Geometry)new Point(5.0, 2.0))).get();
        ElasticsearchAssertions.assertHitCount(result, 1L);
        ElasticsearchAssertions.assertFirstHit(result, ElasticsearchAssertions.hasId("1"));
        result = (SearchResponse)BaseShapeIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter(this.queryBuilder().disjointQuery("area", (Geometry)new Point(3.0, 3.0))).get();
        ElasticsearchAssertions.assertHitCount(result, 0L);
        result = (SearchResponse)BaseShapeIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter(this.queryBuilder().disjointQuery("area", (Geometry)new Point(4.5, 4.5))).get();
        ElasticsearchAssertions.assertHitCount(result, 1L);
        ElasticsearchAssertions.assertFirstHit(result, ElasticsearchAssertions.hasId("1"));
        Polygon inverse = new Polygon(new LinearRing(new double[]{-5.0, -5.0, 5.0, 5.0, -5.0}, new double[]{-5.0, 5.0, 5.0, -5.0, -5.0}), List.of(new LinearRing(new double[]{-4.0, -4.0, 4.0, 4.0, -4.0}, new double[]{-4.0, 4.0, 4.0, -4.0, -4.0})));
        data = BytesReference.bytes((XContentBuilder)XContentFactory.jsonBuilder().startObject().field("area", WellKnownText.toWKT((Geometry)inverse)).endObject());
        BaseShapeIntegTestCase.client().prepareIndex("shapes").setId("2").setSource(data, XContentType.JSON).get();
        BaseShapeIntegTestCase.client().admin().indices().prepareRefresh(new String[0]).get();
        result = (SearchResponse)BaseShapeIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter(this.queryBuilder().intersectionQuery("area", (Geometry)new Point(4.5, 4.5))).get();
        ElasticsearchAssertions.assertHitCount(result, 1L);
        ElasticsearchAssertions.assertFirstHit(result, ElasticsearchAssertions.hasId("2"));
        Polygon WithIn = new Polygon(new LinearRing(new double[]{-30.0, -30.0, 30.0, 30.0, -30.0}, new double[]{-30.0, 30.0, 30.0, -30.0, -30.0}));
        result = (SearchResponse)BaseShapeIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter(this.queryBuilder().withinQuery("area", (Geometry)WithIn)).get();
        ElasticsearchAssertions.assertHitCount(result, 2L);
        Polygon crossing = new Polygon(new LinearRing(new double[]{170.0, 190.0, 190.0, 170.0, 170.0}, new double[]{-10.0, -10.0, 10.0, 10.0, -10.0}));
        data = BytesReference.bytes((XContentBuilder)XContentFactory.jsonBuilder().startObject().field("area", WellKnownText.toWKT((Geometry)crossing)).endObject());
        BaseShapeIntegTestCase.client().prepareIndex("shapes").setId("1").setSource(data, XContentType.JSON).get();
        BaseShapeIntegTestCase.client().admin().indices().prepareRefresh(new String[0]).get();
        crossing = new Polygon(new LinearRing(new double[]{170.0, 190.0, 190.0, 170.0, 170.0}, new double[]{-10.0, -10.0, 10.0, 10.0, -10.0}), List.of(new LinearRing(new double[]{175.0, 185.0, 185.0, 175.0, 175.0}, new double[]{-5.0, -5.0, 5.0, 5.0, -5.0})));
        data = BytesReference.bytes((XContentBuilder)XContentFactory.jsonBuilder().startObject().field("area", WellKnownText.toWKT((Geometry)crossing)).endObject());
        BaseShapeIntegTestCase.client().prepareIndex("shapes").setId("1").setSource(data, XContentType.JSON).get();
        BaseShapeIntegTestCase.client().admin().indices().prepareRefresh(new String[0]).get();
        result = (SearchResponse)BaseShapeIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter(this.queryBuilder().intersectionQuery("area", (Geometry)new Point(174.0, -4.0))).get();
        ElasticsearchAssertions.assertHitCount(result, 1L);
        double xWrapped = this.getFieldTypeName().contains("geo") ? -174.0 : 186.0;
        result = (SearchResponse)BaseShapeIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter(this.queryBuilder().intersectionQuery("area", (Geometry)new Point(xWrapped, -4.0))).get();
        ElasticsearchAssertions.assertHitCount(result, 1L);
        result = (SearchResponse)BaseShapeIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter(this.queryBuilder().intersectionQuery("area", (Geometry)new Point(180.0, -4.0))).get();
        ElasticsearchAssertions.assertHitCount(result, 0L);
        result = (SearchResponse)BaseShapeIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter(this.queryBuilder().intersectionQuery("area", (Geometry)new Point(180.0, -6.0))).get();
        ElasticsearchAssertions.assertHitCount(result, 1L);
    }

    public void testBulk() throws Exception {
        byte[] bulkAction = this.unZipData("/org/elasticsearch/search/geo/gzippedmap.gz");
        Version version = this.randomSupportedVersion();
        Settings settings = Settings.builder().put("index.version.created", version).build();
        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().startObject().startObject("_doc").startObject("properties").startObject("pin").field("type", this.getFieldTypeName());
        xContentBuilder.field("store", true).endObject().startObject("location");
        this.getGeoShapeMapping(xContentBuilder);
        xContentBuilder.field("ignore_malformed", true).endObject().endObject().endObject().endObject();
        BaseShapeIntegTestCase.client().admin().indices().prepareCreate("countries").setSettings(settings).setMapping(xContentBuilder).get();
        BulkResponse bulk = (BulkResponse)BaseShapeIntegTestCase.client().prepareBulk().add(bulkAction, 0, bulkAction.length, null, xContentBuilder.contentType()).get();
        for (BulkItemResponse item : bulk.getItems()) {
            BaseShapeIntegTestCase.assertFalse((String)("unable to index data: " + item.getFailureMessage()), (boolean)item.isFailed());
        }
        BaseShapeIntegTestCase.client().admin().indices().prepareRefresh(new String[0]).get();
        String key = "DE";
        SearchResponse searchResponse = (SearchResponse)BaseShapeIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.matchQuery((String)"_id", (Object)key)).get();
        ElasticsearchAssertions.assertHitCount(searchResponse, 1L);
        for (SearchHit hit : searchResponse.getHits()) {
            BaseShapeIntegTestCase.assertThat((Object)hit.getId(), (Matcher)Matchers.equalTo((Object)key));
        }
        this.doDistanceAndBoundingBoxTest(key);
    }

    protected abstract void doDistanceAndBoundingBoxTest(String var1);

    private String findNodeName(String index) {
        ClusterState state = ((ClusterStateResponse)BaseShapeIntegTestCase.client().admin().cluster().prepareState().get()).getState();
        IndexShardRoutingTable shard = state.getRoutingTable().index(index).shard(0);
        String nodeId = ((ShardRouting)shard.assignedShards().get(0)).currentNodeId();
        return state.getNodes().get(nodeId).getName();
    }

    private byte[] unZipData(String path) throws IOException {
        InputStream is = Streams.class.getResourceAsStream(path);
        if (is == null) {
            throw new FileNotFoundException("Resource [" + path + "] not found in classpath");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPInputStream in = new GZIPInputStream(is);
        Streams.copy((InputStream)in, (OutputStream)out);
        is.close();
        out.close();
        return this.convertTestData(out);
    }

    protected byte[] convertTestData(ByteArrayOutputStream out) {
        return out.toByteArray();
    }
}

