/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.geo;

import java.io.IOException;
import java.util.Locale;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.geo.GeometryTestUtils;
import org.elasticsearch.index.query.GeoDistanceQueryBuilder;
import org.elasticsearch.index.query.GeoValidationMethod;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.test.AbstractQueryTestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public abstract class GeoDistanceQueryBuilderTestCase
extends AbstractQueryTestCase<GeoDistanceQueryBuilder> {
    protected abstract String getFieldName();

    @Override
    protected GeoDistanceQueryBuilder doCreateTestQueryBuilder() {
        String fieldName = this.getFieldName();
        GeoDistanceQueryBuilder qb = new GeoDistanceQueryBuilder(fieldName);
        String distance = "" + GeoDistanceQueryBuilderTestCase.randomDouble();
        if (GeoDistanceQueryBuilderTestCase.randomBoolean()) {
            DistanceUnit unit = GeoDistanceQueryBuilderTestCase.randomFrom(DistanceUnit.values());
            distance = distance + unit.toString();
        }
        int selector = GeoDistanceQueryBuilderTestCase.randomIntBetween(0, 2);
        switch (selector) {
            case 0: {
                qb.distance(GeoDistanceQueryBuilderTestCase.randomDouble(), GeoDistanceQueryBuilderTestCase.randomFrom(DistanceUnit.values()));
                break;
            }
            case 1: {
                qb.distance(distance, GeoDistanceQueryBuilderTestCase.randomFrom(DistanceUnit.values()));
                break;
            }
            case 2: {
                qb.distance(distance);
            }
        }
        qb.point(new GeoPoint(GeometryTestUtils.randomLat(), GeometryTestUtils.randomLon()));
        if (GeoDistanceQueryBuilderTestCase.randomBoolean()) {
            qb.setValidationMethod(GeoDistanceQueryBuilderTestCase.randomFrom(GeoValidationMethod.values()));
        }
        if (GeoDistanceQueryBuilderTestCase.randomBoolean()) {
            qb.geoDistance(GeoDistanceQueryBuilderTestCase.randomFrom(GeoDistance.values()));
        }
        if (GeoDistanceQueryBuilderTestCase.randomBoolean()) {
            qb.ignoreUnmapped(GeoDistanceQueryBuilderTestCase.randomBoolean());
        }
        return qb;
    }

    public void testIllegalValues() {
        IllegalArgumentException e = (IllegalArgumentException)GeoDistanceQueryBuilderTestCase.expectThrows(IllegalArgumentException.class, () -> new GeoDistanceQueryBuilder(""));
        GeoDistanceQueryBuilderTestCase.assertEquals((Object)"fieldName must not be null or empty", (Object)e.getMessage());
        e = (IllegalArgumentException)GeoDistanceQueryBuilderTestCase.expectThrows(IllegalArgumentException.class, () -> new GeoDistanceQueryBuilder((String)null));
        GeoDistanceQueryBuilderTestCase.assertEquals((Object)"fieldName must not be null or empty", (Object)e.getMessage());
        GeoDistanceQueryBuilder query = new GeoDistanceQueryBuilder("fieldName");
        e = (IllegalArgumentException)GeoDistanceQueryBuilderTestCase.expectThrows(IllegalArgumentException.class, () -> query.distance(""));
        GeoDistanceQueryBuilderTestCase.assertEquals((Object)"distance must not be null or empty", (Object)e.getMessage());
        e = (IllegalArgumentException)GeoDistanceQueryBuilderTestCase.expectThrows(IllegalArgumentException.class, () -> query.distance(null));
        GeoDistanceQueryBuilderTestCase.assertEquals((Object)"distance must not be null or empty", (Object)e.getMessage());
        e = (IllegalArgumentException)GeoDistanceQueryBuilderTestCase.expectThrows(IllegalArgumentException.class, () -> query.distance("", DistanceUnit.DEFAULT));
        GeoDistanceQueryBuilderTestCase.assertEquals((Object)"distance must not be null or empty", (Object)e.getMessage());
        e = (IllegalArgumentException)GeoDistanceQueryBuilderTestCase.expectThrows(IllegalArgumentException.class, () -> query.distance(null, DistanceUnit.DEFAULT));
        GeoDistanceQueryBuilderTestCase.assertEquals((Object)"distance must not be null or empty", (Object)e.getMessage());
        e = (IllegalArgumentException)GeoDistanceQueryBuilderTestCase.expectThrows(IllegalArgumentException.class, () -> query.distance("1", null));
        GeoDistanceQueryBuilderTestCase.assertEquals((Object)"distance unit must not be null", (Object)e.getMessage());
        e = (IllegalArgumentException)GeoDistanceQueryBuilderTestCase.expectThrows(IllegalArgumentException.class, () -> query.distance(1.0, null));
        GeoDistanceQueryBuilderTestCase.assertEquals((Object)"distance unit must not be null", (Object)e.getMessage());
        e = (IllegalArgumentException)GeoDistanceQueryBuilderTestCase.expectThrows(IllegalArgumentException.class, () -> query.distance((double)GeoDistanceQueryBuilderTestCase.randomIntBetween(Integer.MIN_VALUE, 0), DistanceUnit.DEFAULT));
        GeoDistanceQueryBuilderTestCase.assertEquals((Object)"distance must be greater than zero", (Object)e.getMessage());
        e = (IllegalArgumentException)GeoDistanceQueryBuilderTestCase.expectThrows(IllegalArgumentException.class, () -> query.geohash(null));
        GeoDistanceQueryBuilderTestCase.assertEquals((Object)"geohash must not be null or empty", (Object)e.getMessage());
        e = (IllegalArgumentException)GeoDistanceQueryBuilderTestCase.expectThrows(IllegalArgumentException.class, () -> query.geohash(""));
        GeoDistanceQueryBuilderTestCase.assertEquals((Object)"geohash must not be null or empty", (Object)e.getMessage());
        e = (IllegalArgumentException)GeoDistanceQueryBuilderTestCase.expectThrows(IllegalArgumentException.class, () -> query.geoDistance(null));
        GeoDistanceQueryBuilderTestCase.assertEquals((Object)"geoDistance must not be null", (Object)e.getMessage());
    }

    @Override
    public void testToQuery() throws IOException {
        super.testToQuery();
    }

    @LuceneTestCase.AwaitsFix(bugUrl="https://github.com/elastic/elasticsearch/issues/86834")
    public void testParsingAndToQueryGeoJSON() throws IOException {
        String query = String.format(Locale.ROOT, "{\n    \"geo_distance\":{\n        \"distance\":\"12mi\",\n        \"%s\":{\n            \"type\": \"Point\",\n            \"coordinates\": [-70,40]\n        }\n    }\n}\n", "mapped_geo_point");
        this.assertGeoDistanceRangeQuery(query, 40.0, -70.0, 12.0, DistanceUnit.MILES);
    }

    public void testParsingAndToQueryWKT() throws IOException {
        String query = String.format(Locale.ROOT, "{\n    \"geo_distance\":{\n        \"distance\":\"12mi\",\n        \"%s\":\"POINT(-70 40)\"\n    }\n}\n", "mapped_geo_point");
        this.assertGeoDistanceRangeQuery(query, 40.0, -70.0, 12.0, DistanceUnit.MILES);
    }

    public void testParsingAndToQuery1() throws IOException {
        String query = String.format(Locale.ROOT, "{\n    \"geo_distance\":{\n        \"distance\":\"12mi\",\n        \"%s\":{\n            \"lat\":40,\n            \"lon\":-70\n        }\n    }\n}\n", "mapped_geo_point");
        this.assertGeoDistanceRangeQuery(query, 40.0, -70.0, 12.0, DistanceUnit.MILES);
    }

    public void testParsingAndToQuery2() throws IOException {
        String query = String.format(Locale.ROOT, "{\n    \"geo_distance\":{\n        \"distance\":\"12mi\",\n        \"%s\":[-70, 40]\n    }\n}\n", "mapped_geo_point");
        this.assertGeoDistanceRangeQuery(query, 40.0, -70.0, 12.0, DistanceUnit.MILES);
    }

    public void testParsingAndToQuery3() throws IOException {
        String query = String.format(Locale.ROOT, "{\n    \"geo_distance\":{\n        \"distance\":\"12mi\",\n        \"%s\":\"40, -70\"\n    }\n}\n", "mapped_geo_point");
        this.assertGeoDistanceRangeQuery(query, 40.0, -70.0, 12.0, DistanceUnit.MILES);
    }

    public void testParsingAndToQuery4() throws IOException {
        String query = String.format(Locale.ROOT, "{\n    \"geo_distance\":{\n        \"distance\":\"12mi\",\n        \"%s\":\"drn5x1g8cu2y\"\n    }\n}\n", "mapped_geo_point");
        GeoPoint geoPoint = GeoPoint.fromGeohash((String)"drn5x1g8cu2y");
        this.assertGeoDistanceRangeQuery(query, geoPoint.getLat(), geoPoint.getLon(), 12.0, DistanceUnit.MILES);
    }

    public void testParsingAndToQuery5() throws IOException {
        String query = String.format(Locale.ROOT, "{\n    \"geo_distance\":{\n        \"distance\":12,\n        \"unit\":\"mi\",\n        \"%s\":{\n            \"lat\":40,\n            \"lon\":-70\n        }\n    }\n}\n", "mapped_geo_point");
        this.assertGeoDistanceRangeQuery(query, 40.0, -70.0, 12.0, DistanceUnit.MILES);
    }

    public void testParsingAndToQuery6() throws IOException {
        String query = String.format(Locale.ROOT, "{\n    \"geo_distance\":{\n        \"distance\":\"12\",\n        \"unit\":\"mi\",\n        \"%s\":{\n            \"lat\":40,\n            \"lon\":-70\n        }\n    }\n}\n", "mapped_geo_point");
        this.assertGeoDistanceRangeQuery(query, 40.0, -70.0, 12.0, DistanceUnit.MILES);
    }

    public void testParsingAndToQuery7() throws IOException {
        String query = String.format(Locale.ROOT, "{\n  \"geo_distance\":{\n      \"distance\":\"19.312128\",\n      \"%s\":{\n          \"lat\":40,\n          \"lon\":-70\n      }\n  }\n}\n", "mapped_geo_point");
        this.assertGeoDistanceRangeQuery(query, 40.0, -70.0, 19.312128, DistanceUnit.DEFAULT);
    }

    public void testParsingAndToQuery8() throws IOException {
        String query = String.format(Locale.ROOT, "{\n    \"geo_distance\":{\n        \"distance\":19.312128,\n        \"%s\":{\n            \"lat\":40,\n            \"lon\":-70\n        }\n    }\n}\n", "mapped_geo_point");
        this.assertGeoDistanceRangeQuery(query, 40.0, -70.0, 19.312128, DistanceUnit.DEFAULT);
    }

    public void testParsingAndToQuery9() throws IOException {
        String query = String.format(Locale.ROOT, "{\n    \"geo_distance\":{\n        \"distance\":\"19.312128\",\n        \"unit\":\"km\",\n        \"%s\":{\n            \"lat\":40,\n            \"lon\":-70\n        }\n    }\n}\n", "mapped_geo_point");
        this.assertGeoDistanceRangeQuery(query, 40.0, -70.0, 19.312128, DistanceUnit.KILOMETERS);
    }

    public void testParsingAndToQuery10() throws IOException {
        String query = String.format(Locale.ROOT, "{\n    \"geo_distance\":{\n        \"distance\":19.312128,\n        \"unit\":\"km\",\n        \"%s\":{\n            \"lat\":40,\n            \"lon\":-70\n        }\n    }\n}\n", "mapped_geo_point");
        this.assertGeoDistanceRangeQuery(query, 40.0, -70.0, 19.312128, DistanceUnit.KILOMETERS);
    }

    public void testParsingAndToQuery11() throws IOException {
        String query = String.format(Locale.ROOT, "{\n    \"geo_distance\":{\n        \"distance\":\"19.312128km\",\n        \"%s\":{\n            \"lat\":40,\n            \"lon\":-70\n        }\n    }\n}\n", "mapped_geo_point");
        this.assertGeoDistanceRangeQuery(query, 40.0, -70.0, 19.312128, DistanceUnit.KILOMETERS);
    }

    public void testParsingAndToQuery12() throws IOException {
        String query = String.format(Locale.ROOT, "{\n    \"geo_distance\":{\n        \"distance\":\"12mi\",\n        \"unit\":\"km\",\n        \"%s\":{\n            \"lat\":40,\n            \"lon\":-70\n        }\n    }\n}\n", "mapped_geo_point");
        this.assertGeoDistanceRangeQuery(query, 40.0, -70.0, 12.0, DistanceUnit.MILES);
    }

    private void assertGeoDistanceRangeQuery(String query, double lat, double lon, double distance, DistanceUnit distanceUnit) throws IOException {
        Query parsedQuery = this.parseQuery(query).toQuery(GeoDistanceQueryBuilderTestCase.createSearchExecutionContext());
        double qLat = GeoEncodingUtils.decodeLatitude((int)GeoEncodingUtils.encodeLatitude((double)lat));
        double qLon = GeoEncodingUtils.decodeLongitude((int)GeoEncodingUtils.encodeLongitude((double)lon));
        GeoDistanceQueryBuilderTestCase.assertEquals((Object)parsedQuery.toString(), (Object)("mapped_geo_point:" + qLat + "," + qLon + " +/- " + distanceUnit.toMeters(distance) + " meters"));
    }

    public void testFromJson() throws IOException {
        String json = "{\n  \"geo_distance\" : {\n    \"pin.location\" : [ -70.0, 40.0 ],\n    \"distance\" : 12000.0,\n    \"distance_type\" : \"arc\",\n    \"validation_method\" : \"STRICT\",\n    \"ignore_unmapped\" : false,\n    \"boost\" : 1.0\n  }\n}";
        GeoDistanceQueryBuilder parsed = (GeoDistanceQueryBuilder)this.parseQuery(json);
        GeoDistanceQueryBuilderTestCase.checkGeneratedJson(json, (QueryBuilder)parsed);
        GeoDistanceQueryBuilderTestCase.assertEquals((String)json, (double)-70.0, (double)parsed.point().getLon(), (double)1.0E-4);
        GeoDistanceQueryBuilderTestCase.assertEquals((String)json, (double)40.0, (double)parsed.point().getLat(), (double)1.0E-4);
        GeoDistanceQueryBuilderTestCase.assertEquals((String)json, (double)12000.0, (double)parsed.distance(), (double)1.0E-4);
    }

    public void testIgnoreUnmapped() throws IOException {
        GeoDistanceQueryBuilder queryBuilder = new GeoDistanceQueryBuilder("unmapped").point(0.0, 0.0).distance("20m");
        queryBuilder.ignoreUnmapped(true);
        SearchExecutionContext searchExecutionContext = GeoDistanceQueryBuilderTestCase.createSearchExecutionContext();
        Query query = queryBuilder.toQuery(searchExecutionContext);
        GeoDistanceQueryBuilderTestCase.assertThat((Object)query, (Matcher)CoreMatchers.notNullValue());
        GeoDistanceQueryBuilderTestCase.assertThat((Object)query, (Matcher)CoreMatchers.instanceOf(MatchNoDocsQuery.class));
        GeoDistanceQueryBuilder failingQueryBuilder = new GeoDistanceQueryBuilder("unmapped").point(0.0, 0.0).distance("20m");
        failingQueryBuilder.ignoreUnmapped(false);
        QueryShardException e = (QueryShardException)GeoDistanceQueryBuilderTestCase.expectThrows(QueryShardException.class, () -> failingQueryBuilder.toQuery(searchExecutionContext));
        GeoDistanceQueryBuilderTestCase.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"failed to find geo field [unmapped]"));
    }

    public void testParseFailsWithMultipleFields() throws IOException {
        String json = "{\n  \"geo_distance\" : {\n    \"point1\" : {\n      \"lat\" : 30, \"lon\" : 12\n    },\n    \"point2\" : {\n      \"lat\" : 30, \"lon\" : 12\n    }\n  }\n}";
        ParsingException e = (ParsingException)GeoDistanceQueryBuilderTestCase.expectThrows(ParsingException.class, () -> this.parseQuery(json));
        GeoDistanceQueryBuilderTestCase.assertEquals((Object)"[geo_distance] query doesn't support multiple fields, found [point1] and [point2]", (Object)e.getMessage());
    }
}

