/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequestBuilder;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksResponse;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequestBuilder;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.MockScriptPlugin;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.lookup.LeafStoredFieldsLookup;
import org.elasticsearch.tasks.TaskInfo;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;

public class AbstractSearchCancellationTestCase
extends ESIntegTestCase {
    protected static boolean lowLevelCancellation;

    @BeforeClass
    public static void init() {
        lowLevelCancellation = AbstractSearchCancellationTestCase.randomBoolean();
    }

    @Override
    protected Collection<Class<? extends Plugin>> nodePlugins() {
        return Collections.singleton(ScriptedBlockPlugin.class);
    }

    @Override
    protected Settings nodeSettings(int nodeOrdinal, Settings otherSettings) {
        this.logger.info("Using lowLevelCancellation: {}", (Object)lowLevelCancellation);
        return Settings.builder().put(super.nodeSettings(nodeOrdinal, otherSettings)).put(SearchService.LOW_LEVEL_CANCELLATION_SETTING.getKey(), lowLevelCancellation).build();
    }

    protected void indexTestData() {
        for (int i = 0; i < 5; ++i) {
            BulkRequestBuilder bulkRequestBuilder = (BulkRequestBuilder)AbstractSearchCancellationTestCase.client().prepareBulk().setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            for (int j = 0; j < 20; ++j) {
                bulkRequestBuilder.add(AbstractSearchCancellationTestCase.client().prepareIndex("test").setId(Integer.toString(i * 5 + j)).setSource(new Object[]{"field", "value"}));
            }
            ElasticsearchAssertions.assertNoFailures((BulkResponse)bulkRequestBuilder.get());
        }
    }

    protected List<ScriptedBlockPlugin> initBlockFactory() {
        ArrayList<ScriptedBlockPlugin> plugins = new ArrayList<ScriptedBlockPlugin>();
        for (PluginsService pluginsService : AbstractSearchCancellationTestCase.internalCluster().getInstances(PluginsService.class)) {
            plugins.addAll(pluginsService.filterPlugins(ScriptedBlockPlugin.class));
        }
        for (ScriptedBlockPlugin plugin : plugins) {
            plugin.reset();
            plugin.enableBlock();
        }
        return plugins;
    }

    protected void awaitForBlock(List<ScriptedBlockPlugin> plugins) throws Exception {
        int numberOfShards = this.getNumShards((String)"test").numPrimaries;
        AbstractSearchCancellationTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            int numberOfBlockedPlugins = 0;
            for (ScriptedBlockPlugin plugin : plugins) {
                numberOfBlockedPlugins += plugin.hits.get();
            }
            this.logger.info("The plugin blocked on {} out of {} shards", (Object)numberOfBlockedPlugins, (Object)numberOfShards);
            AbstractSearchCancellationTestCase.assertThat((Object)numberOfBlockedPlugins, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        }));
    }

    protected void disableBlocks(List<ScriptedBlockPlugin> plugins) throws Exception {
        for (ScriptedBlockPlugin plugin : plugins) {
            plugin.disableBlock();
        }
    }

    protected void cancelSearch(String action) {
        ListTasksResponse listTasksResponse = (ListTasksResponse)((ListTasksRequestBuilder)AbstractSearchCancellationTestCase.client().admin().cluster().prepareListTasks(new String[0]).setActions(new String[]{action})).get();
        AbstractSearchCancellationTestCase.assertThat((Object)listTasksResponse.getTasks(), (Matcher)Matchers.hasSize((int)1));
        TaskInfo searchTask = (TaskInfo)listTasksResponse.getTasks().get(0);
        this.logger.info("Cancelling search");
        CancelTasksResponse cancelTasksResponse = (CancelTasksResponse)((CancelTasksRequestBuilder)AbstractSearchCancellationTestCase.client().admin().cluster().prepareCancelTasks(new String[0]).setTargetTaskId(searchTask.taskId())).get();
        AbstractSearchCancellationTestCase.assertThat((Object)cancelTasksResponse.getTasks(), (Matcher)Matchers.hasSize((int)1));
        AbstractSearchCancellationTestCase.assertThat((Object)((TaskInfo)cancelTasksResponse.getTasks().get(0)).taskId(), (Matcher)Matchers.equalTo((Object)searchTask.taskId()));
    }

    protected SearchResponse ensureSearchWasCancelled(ActionFuture<SearchResponse> searchResponse) {
        try {
            SearchResponse response = (SearchResponse)searchResponse.actionGet();
            this.logger.info("Search response {}", (Object)response);
            AbstractSearchCancellationTestCase.assertNotEquals((String)"At least one shard should have failed", (long)0L, (long)response.getFailedShards());
            for (ShardSearchFailure failure : response.getShardFailures()) {
                AbstractSearchCancellationTestCase.assertThat((Object)ExceptionsHelper.status((Throwable)failure.getCause()), (Matcher)Matchers.equalTo((Object)RestStatus.BAD_REQUEST));
            }
            return response;
        }
        catch (SearchPhaseExecutionException ex) {
            AbstractSearchCancellationTestCase.assertThat((Object)ExceptionsHelper.status((Throwable)ex), (Matcher)Matchers.equalTo((Object)RestStatus.BAD_REQUEST));
            this.logger.info("All shards failed with", (Throwable)ex);
            return null;
        }
    }

    public static class ScriptedBlockPlugin
    extends MockScriptPlugin {
        public static final String SEARCH_BLOCK_SCRIPT_NAME = "search_block";
        public static final String INIT_SCRIPT_NAME = "init";
        public static final String MAP_SCRIPT_NAME = "map";
        public static final String MAP_BLOCK_SCRIPT_NAME = "map_block";
        public static final String COMBINE_SCRIPT_NAME = "combine";
        static final String REDUCE_SCRIPT_NAME = "reduce";
        public static final String REDUCE_FAIL_SCRIPT_NAME = "reduce_fail";
        public static final String REDUCE_BLOCK_SCRIPT_NAME = "reduce_block";
        public static final String TERM_SCRIPT_NAME = "term";
        private final AtomicInteger hits = new AtomicInteger();
        private final AtomicBoolean shouldBlock = new AtomicBoolean(true);
        private final AtomicReference<Runnable> beforeExecution = new AtomicReference();

        public void reset() {
            this.hits.set(0);
        }

        public void disableBlock() {
            this.shouldBlock.set(false);
        }

        public void enableBlock() {
            this.shouldBlock.set(true);
        }

        public void setBeforeExecution(Runnable runnable) {
            this.beforeExecution.set(runnable);
        }

        @Override
        public Map<String, Function<Map<String, Object>, Object>> pluginScripts() {
            return Map.of(SEARCH_BLOCK_SCRIPT_NAME, this::searchBlockScript, INIT_SCRIPT_NAME, this::nullScript, MAP_SCRIPT_NAME, this::nullScript, MAP_BLOCK_SCRIPT_NAME, this::mapBlockScript, COMBINE_SCRIPT_NAME, this::nullScript, REDUCE_BLOCK_SCRIPT_NAME, this::blockScript, REDUCE_SCRIPT_NAME, this::termScript, REDUCE_FAIL_SCRIPT_NAME, this::reduceFailScript, TERM_SCRIPT_NAME, this::termScript);
        }

        private Object searchBlockScript(Map<String, Object> params) {
            Runnable runnable = this.beforeExecution.get();
            if (runnable != null) {
                runnable.run();
            }
            LeafStoredFieldsLookup fieldsLookup = (LeafStoredFieldsLookup)params.get("_fields");
            LogManager.getLogger(AbstractSearchCancellationTestCase.class).info("Blocking on the document {}", (Object)fieldsLookup.get((Object)"_id"));
            this.hits.incrementAndGet();
            try {
                ESTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> Assert.assertFalse((boolean)this.shouldBlock.get())));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return true;
        }

        private Object reduceFailScript(Map<String, Object> params) {
            Assert.fail((String)"Shouldn't reach reduce");
            return true;
        }

        private Object nullScript(Map<String, Object> params) {
            return null;
        }

        private Object blockScript(Map<String, Object> params) {
            Runnable runnable = this.beforeExecution.get();
            if (runnable != null) {
                runnable.run();
            }
            if (this.shouldBlock.get()) {
                LogManager.getLogger(AbstractSearchCancellationTestCase.class).info("Blocking in reduce");
            }
            this.hits.incrementAndGet();
            try {
                ESTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> Assert.assertFalse((boolean)this.shouldBlock.get())));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return 42;
        }

        private Object mapBlockScript(Map<String, Object> params) {
            Runnable runnable = this.beforeExecution.get();
            if (runnable != null) {
                runnable.run();
            }
            if (this.shouldBlock.get()) {
                LogManager.getLogger(AbstractSearchCancellationTestCase.class).info("Blocking in map");
            }
            this.hits.incrementAndGet();
            try {
                ESTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> Assert.assertFalse((boolean)this.shouldBlock.get())));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return 1;
        }

        private Object termScript(Map<String, Object> params) {
            return 1;
        }
    }
}

