/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.EqualsHashCodeTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class AbstractWireTestCase<T>
extends ESTestCase {
    protected static final int NUMBER_OF_TEST_RUNS = 20;

    protected abstract T createTestInstance();

    protected abstract T mutateInstance(T var1) throws IOException;

    public final void testEqualsAndHashcode() {
        for (int runs = 0; runs < 20; ++runs) {
            EqualsHashCodeTestUtils.checkEqualsAndHashCode(this.createTestInstance(), this::copyInstance, this::mutateInstance);
        }
    }

    public final void testConcurrentEquals() throws IOException, InterruptedException, ExecutionException {
        Object testInstance = this.createTestInstance();
        Object copy = this.copyInstance(testInstance);
        int rounds = AbstractWireTestCase.scaledRandomIntBetween(300, 5000);
        this.concurrentTest(() -> {
            for (int r = 0; r < rounds; ++r) {
                AbstractWireTestCase.assertEquals((Object)testInstance, (Object)copy);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void concurrentTest(Runnable r) throws InterruptedException, ExecutionException {
        int threads = 5;
        int tasks = threads * 2;
        ExecutorService exec = Executors.newFixedThreadPool(threads);
        try {
            ArrayList results = new ArrayList();
            for (int t = 0; t < tasks; ++t) {
                results.add(exec.submit(r));
            }
            for (Future future : results) {
                future.get();
            }
        }
        finally {
            exec.shutdown();
        }
    }

    public final void testConcurrentHashCode() throws InterruptedException, ExecutionException {
        Object testInstance = this.createTestInstance();
        int firstHashCode = testInstance.hashCode();
        int rounds = AbstractWireTestCase.scaledRandomIntBetween(300, 5000);
        this.concurrentTest(() -> {
            for (int r = 0; r < rounds; ++r) {
                AbstractWireTestCase.assertEquals((long)firstHashCode, (long)testInstance.hashCode());
            }
        });
    }

    public void testToString() throws Exception {
        String toString = this.createTestInstance().toString();
        AbstractWireTestCase.assertNotNull((Object)toString);
        AbstractWireTestCase.assertThat((Object)toString, (Matcher)Matchers.not((Matcher)Matchers.emptyString()));
    }

    public final void testSerialization() throws IOException {
        for (int runs = 0; runs < 20; ++runs) {
            T testInstance = this.createTestInstance();
            this.assertSerialization(testInstance);
        }
    }

    public final void testConcurrentSerialization() throws InterruptedException, ExecutionException {
        T testInstance = this.createTestInstance();
        int rounds = AbstractWireTestCase.scaledRandomIntBetween(300, 2000);
        this.concurrentTest(() -> {
            try {
                for (int r = 0; r < rounds; ++r) {
                    this.assertSerialization(testInstance);
                }
            }
            catch (IOException e) {
                throw new AssertionError("error serializing", e);
            }
        });
    }

    protected final void assertSerialization(T testInstance) throws IOException {
        this.assertSerialization(testInstance, TransportVersion.CURRENT);
    }

    protected final void assertSerialization(T testInstance, TransportVersion version) throws IOException {
        T deserializedInstance = this.copyInstance(testInstance, version);
        this.assertEqualInstances(testInstance, deserializedInstance);
    }

    protected void assertEqualInstances(T expectedInstance, T newInstance) {
        AbstractWireTestCase.assertNotSame(newInstance, expectedInstance);
        AbstractWireTestCase.assertThat(newInstance, (Matcher)Matchers.equalTo(expectedInstance));
        AbstractWireTestCase.assertThat((Object)newInstance.hashCode(), (Matcher)Matchers.equalTo((Object)expectedInstance.hashCode()));
    }

    protected final T copyInstance(T instance) throws IOException {
        return this.copyInstance(instance, TransportVersion.CURRENT);
    }

    protected abstract T copyInstance(T var1, TransportVersion var2) throws IOException;

    protected NamedWriteableRegistry getNamedWriteableRegistry() {
        return new NamedWriteableRegistry(Collections.emptyList());
    }
}

