/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.MockBigArrays;
import org.elasticsearch.common.util.MockPageCacheRecycler;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.MultiBucketConsumerService;
import org.elasticsearch.search.aggregations.ParsedAggregation;
import org.elasticsearch.search.aggregations.bucket.composite.ParsedComposite;
import org.elasticsearch.search.aggregations.bucket.filter.ParsedFilter;
import org.elasticsearch.search.aggregations.bucket.filter.ParsedFilters;
import org.elasticsearch.search.aggregations.bucket.geogrid.ParsedGeoHashGrid;
import org.elasticsearch.search.aggregations.bucket.geogrid.ParsedGeoTileGrid;
import org.elasticsearch.search.aggregations.bucket.global.ParsedGlobal;
import org.elasticsearch.search.aggregations.bucket.histogram.ParsedDateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.ParsedHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.ParsedVariableWidthHistogram;
import org.elasticsearch.search.aggregations.bucket.missing.ParsedMissing;
import org.elasticsearch.search.aggregations.bucket.nested.ParsedNested;
import org.elasticsearch.search.aggregations.bucket.nested.ParsedReverseNested;
import org.elasticsearch.search.aggregations.bucket.range.ParsedBinaryRange;
import org.elasticsearch.search.aggregations.bucket.range.ParsedDateRange;
import org.elasticsearch.search.aggregations.bucket.range.ParsedGeoDistance;
import org.elasticsearch.search.aggregations.bucket.range.ParsedRange;
import org.elasticsearch.search.aggregations.bucket.sampler.ParsedSampler;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedDoubleTerms;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedLongRareTerms;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedLongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedSignificantLongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedSignificantStringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedStringRareTerms;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedStringTerms;
import org.elasticsearch.search.aggregations.metrics.ParsedAvg;
import org.elasticsearch.search.aggregations.metrics.ParsedCardinality;
import org.elasticsearch.search.aggregations.metrics.ParsedExtendedStats;
import org.elasticsearch.search.aggregations.metrics.ParsedGeoBounds;
import org.elasticsearch.search.aggregations.metrics.ParsedGeoCentroid;
import org.elasticsearch.search.aggregations.metrics.ParsedHDRPercentileRanks;
import org.elasticsearch.search.aggregations.metrics.ParsedHDRPercentiles;
import org.elasticsearch.search.aggregations.metrics.ParsedMax;
import org.elasticsearch.search.aggregations.metrics.ParsedMedianAbsoluteDeviation;
import org.elasticsearch.search.aggregations.metrics.ParsedMin;
import org.elasticsearch.search.aggregations.metrics.ParsedScriptedMetric;
import org.elasticsearch.search.aggregations.metrics.ParsedStats;
import org.elasticsearch.search.aggregations.metrics.ParsedSum;
import org.elasticsearch.search.aggregations.metrics.ParsedTDigestPercentileRanks;
import org.elasticsearch.search.aggregations.metrics.ParsedTDigestPercentiles;
import org.elasticsearch.search.aggregations.metrics.ParsedTopHits;
import org.elasticsearch.search.aggregations.metrics.ParsedValueCount;
import org.elasticsearch.search.aggregations.metrics.ParsedWeightedAvg;
import org.elasticsearch.search.aggregations.pipeline.ParsedBucketMetricValue;
import org.elasticsearch.search.aggregations.pipeline.ParsedExtendedStatsBucket;
import org.elasticsearch.search.aggregations.pipeline.ParsedPercentilesBucket;
import org.elasticsearch.search.aggregations.pipeline.ParsedSimpleValue;
import org.elasticsearch.search.aggregations.pipeline.ParsedStatsBucket;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.test.AbstractNamedWriteableTestCase;
import org.elasticsearch.test.XContentTestUtils;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.elasticsearch.xcontent.ContextParser;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class InternalAggregationTestCase<T extends InternalAggregation>
extends AbstractNamedWriteableTestCase<T> {
    public static final int DEFAULT_MAX_BUCKETS = 100000;
    protected static final double TOLERANCE = 1.0E-10;
    private static final Comparator<InternalAggregation> INTERNAL_AGG_COMPARATOR = (agg1, agg2) -> {
        if (agg1.canLeadReduction() == agg2.canLeadReduction()) {
            return 0;
        }
        if (agg1.canLeadReduction() && !agg2.canLeadReduction()) {
            return -1;
        }
        return 1;
    };
    private final NamedWriteableRegistry namedWriteableRegistry = new NamedWriteableRegistry(this.getNamedWriteables());
    private final NamedXContentRegistry namedXContentRegistry = new NamedXContentRegistry(this.getNamedXContents());
    private static final List<NamedXContentRegistry.Entry> namedXContents;

    public static AggregationReduceContext.Builder emptyReduceContextBuilder() {
        return InternalAggregationTestCase.emptyReduceContextBuilder(AggregatorFactories.builder());
    }

    public static AggregationReduceContext.Builder emptyReduceContextBuilder(final AggregatorFactories.Builder aggs) {
        return new AggregationReduceContext.Builder(){

            public AggregationReduceContext forPartialReduction() {
                return new AggregationReduceContext.ForPartial(BigArrays.NON_RECYCLING_INSTANCE, null, () -> false, aggs);
            }

            public AggregationReduceContext forFinalReduction() {
                return new AggregationReduceContext.ForFinal(BigArrays.NON_RECYCLING_INSTANCE, null, () -> false, aggs, b -> {});
            }
        };
    }

    public static AggregationReduceContext.Builder mockReduceContext(final AggregationBuilder agg) {
        return new AggregationReduceContext.Builder(){

            public AggregationReduceContext forPartialReduction() {
                return new AggregationReduceContext.ForPartial(BigArrays.NON_RECYCLING_INSTANCE, null, () -> false, agg);
            }

            public AggregationReduceContext forFinalReduction() {
                return new AggregationReduceContext.ForFinal(BigArrays.NON_RECYCLING_INSTANCE, null, () -> false, agg, b -> {}, PipelineAggregator.PipelineTree.EMPTY);
            }
        };
    }

    public static List<NamedXContentRegistry.Entry> getDefaultNamedXContents() {
        return namedXContents;
    }

    protected List<NamedXContentRegistry.Entry> getNamedXContents() {
        return namedXContents;
    }

    @Override
    protected NamedXContentRegistry xContentRegistry() {
        return this.namedXContentRegistry;
    }

    @Override
    protected final NamedWriteableRegistry getNamedWriteableRegistry() {
        return this.namedWriteableRegistry;
    }

    protected List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        SearchPlugin plugin = this.registerPlugin();
        SearchModule searchModule = new SearchModule(Settings.EMPTY, plugin == null ? Collections.emptyList() : List.of(plugin));
        ArrayList<NamedWriteableRegistry.Entry> entries = new ArrayList<NamedWriteableRegistry.Entry>(searchModule.getNamedWriteables());
        if (plugin != null) {
            entries.addAll(((Plugin)plugin).getNamedWriteables());
        }
        return entries;
    }

    protected SearchPlugin registerPlugin() {
        return null;
    }

    protected abstract T createTestInstance(String var1, Map<String, Object> var2);

    protected T createUnmappedInstance(String name, Map<String, Object> metadata) {
        return this.createTestInstance(name, metadata);
    }

    @Override
    protected final Class<T> categoryClass() {
        return InternalAggregation.class;
    }

    protected BuilderAndToReduce<T> randomResultsToReduce(String name, int size) {
        ArrayList<T> inputs = new ArrayList<T>();
        for (int i = 0; i < size; ++i) {
            T t = InternalAggregationTestCase.randomBoolean() ? this.createUnmappedInstance(name) : this.createTestInstance(name);
            inputs.add(t);
        }
        return new BuilderAndToReduce(this.mockBuilder(inputs), inputs);
    }

    protected final AggregationBuilder mockBuilder(List<? extends InternalAggregation> results) {
        HashMap<String, Object> subNames = new HashMap<String, Object>();
        results.forEach(a -> this.collectSubBuilderNames((Map<String, Object>)subNames, (InternalAggregation)a));
        return this.mockBuilder(results.get(0).getName(), subNames);
    }

    private AggregationBuilder mockBuilder(String name, Map<String, Object> subNames) {
        MockAggregationBuilder b = new MockAggregationBuilder(name);
        for (Map.Entry<String, Object> s : subNames.entrySet()) {
            Map subSubNames = (Map)s.getValue();
            b.subAggregation(this.mockBuilder(s.getKey(), subSubNames));
        }
        return b;
    }

    private void collectSubBuilderNames(Map<String, Object> names, InternalAggregation result) {
        result.forEachBucket(ia -> {
            for (InternalAggregation a : ia.copyResults()) {
                Map sub = (Map)names.computeIfAbsent(a.getName(), k -> new HashMap());
                this.collectSubBuilderNames(sub, a);
            }
        });
    }

    protected boolean supportsOutOfOrderReduce() {
        return true;
    }

    public void testReduceRandom() throws IOException {
        String name = InternalAggregationTestCase.randomAlphaOfLength(5);
        int size = InternalAggregationTestCase.between(1, 200);
        BuilderAndToReduce<T> inputs = this.randomResultsToReduce(name, size);
        InternalAggregationTestCase.assertThat(inputs.toReduce(), (Matcher)Matchers.hasSize((int)size));
        ArrayList<Object> toReduce = new ArrayList<Object>();
        toReduce.addAll(inputs.toReduce());
        ScriptService mockScriptService = this.mockScriptService();
        MockBigArrays bigArrays = new MockBigArrays((PageCacheRecycler)new MockPageCacheRecycler(Settings.EMPTY), (CircuitBreakerService)new NoneCircuitBreakerService());
        if (InternalAggregationTestCase.randomBoolean() && toReduce.size() > 1) {
            if (this.supportsOutOfOrderReduce()) {
                Collections.shuffle(toReduce, InternalAggregationTestCase.random());
            }
            int r = InternalAggregationTestCase.randomIntBetween(1, toReduce.size());
            List<InternalAggregation> toPartialReduce = toReduce.subList(0, r);
            toPartialReduce.sort(INTERNAL_AGG_COMPARATOR);
            AggregationReduceContext.ForPartial context = new AggregationReduceContext.ForPartial((BigArrays)bigArrays, mockScriptService, () -> false, inputs.builder());
            InternalAggregation reduced = ((InternalAggregation)toPartialReduce.get(0)).reduce(toPartialReduce, (AggregationReduceContext)context);
            int initialBucketCount = 0;
            for (InternalAggregation internalAggregation : toPartialReduce) {
                initialBucketCount += InternalMultiBucketAggregation.countInnerBucket((Aggregation)internalAggregation);
            }
            int reducedBucketCount = InternalMultiBucketAggregation.countInnerBucket((Aggregation)reduced);
            InternalAggregationTestCase.assertThat((Object)reducedBucketCount, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(initialBucketCount)));
            if (InternalAggregationTestCase.randomBoolean()) {
                reduced = (InternalAggregation)InternalAggregationTestCase.copyNamedWriteable(reduced, this.getNamedWriteableRegistry(), this.categoryClass());
            }
            toReduce = new ArrayList(toReduce.subList(r, toReduce.size()));
            toReduce.add(reduced);
        }
        MultiBucketConsumerService.MultiBucketConsumer bucketConsumer = new MultiBucketConsumerService.MultiBucketConsumer(100000, new NoneCircuitBreakerService().getBreaker("request"));
        AggregationReduceContext.ForFinal context = new AggregationReduceContext.ForFinal((BigArrays)bigArrays, mockScriptService, () -> false, inputs.builder(), (IntConsumer)bucketConsumer, PipelineAggregator.PipelineTree.EMPTY);
        inputs.toReduce().sort(INTERNAL_AGG_COMPARATOR);
        InternalAggregation reduced = ((InternalAggregation)inputs.toReduce().get(0)).reduce(toReduce, (AggregationReduceContext)context);
        this.doAssertReducedMultiBucketConsumer((Aggregation)reduced, bucketConsumer);
        this.assertReduced(reduced, inputs.toReduce());
        if (this.supportsSampling()) {
            SamplingContext randomContext = new SamplingContext(InternalAggregationTestCase.randomDoubleBetween(1.0E-8, 0.1, false), InternalAggregationTestCase.randomInt());
            InternalAggregation sampled = reduced.finalizeSampling(randomContext);
            this.assertSampled(sampled, reduced, randomContext);
        }
    }

    protected void doAssertReducedMultiBucketConsumer(Aggregation agg, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer) {
        InternalAggregationTestCase.assertMultiBucketConsumer(agg, bucketConsumer);
    }

    protected ScriptService mockScriptService() {
        return null;
    }

    protected abstract void assertReduced(T var1, List<T> var2);

    protected void assertSampled(T sampled, T reduced, SamplingContext samplingContext) {
        throw new UnsupportedOperationException("aggregation supports sampling but does not implement assertSampled");
    }

    @Override
    public final T createTestInstance() {
        return this.createTestInstance(InternalAggregationTestCase.randomAlphaOfLength(5));
    }

    protected boolean supportsSampling() {
        return false;
    }

    public final Map<String, Object> createTestMetadata() {
        HashMap<String, String> metadata = null;
        if (InternalAggregationTestCase.randomBoolean()) {
            metadata = new HashMap<String, String>();
            int metadataCount = InternalAggregationTestCase.between(0, 10);
            while (metadata.size() < metadataCount) {
                metadata.put(InternalAggregationTestCase.randomAlphaOfLength(5), InternalAggregationTestCase.randomAlphaOfLength(5));
            }
        }
        return metadata;
    }

    private T createTestInstance(String name) {
        return this.createTestInstance(name, this.createTestMetadata());
    }

    protected final T createUnmappedInstance(String name) {
        int metadataCount;
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        int n = metadataCount = InternalAggregationTestCase.randomBoolean() ? 0 : InternalAggregationTestCase.between(1, 10);
        while (metadata.size() < metadataCount) {
            metadata.put(InternalAggregationTestCase.randomAlphaOfLength(5), InternalAggregationTestCase.randomAlphaOfLength(5));
        }
        return this.createUnmappedInstance(name, metadata);
    }

    public T createTestInstanceForXContent() {
        return this.createTestInstance();
    }

    public final void testFromXContent() throws IOException {
        T aggregation = this.createTestInstanceForXContent();
        Object parsedAggregation = this.parseAndAssert((InternalAggregation)aggregation, InternalAggregationTestCase.randomBoolean(), false);
        this.assertFromXContent(aggregation, (ParsedAggregation)parsedAggregation);
    }

    public final void testFromXContentWithRandomFields() throws IOException {
        T aggregation = this.createTestInstanceForXContent();
        Object parsedAggregation = this.parseAndAssert((InternalAggregation)aggregation, InternalAggregationTestCase.randomBoolean(), true);
        this.assertFromXContent(aggregation, (ParsedAggregation)parsedAggregation);
    }

    protected abstract void assertFromXContent(T var1, ParsedAggregation var2) throws IOException;

    public final void testConcurrentToXContent() throws IOException, InterruptedException, ExecutionException {
        T testInstance = this.createTestInstanceForXContent();
        ToXContent.MapParams params = new ToXContent.MapParams(Collections.singletonMap("typed_keys", "true"));
        XContentType xContentType = InternalAggregationTestCase.randomFrom(XContentType.values());
        boolean humanReadable = InternalAggregationTestCase.randomBoolean();
        BytesRef firstTimeBytes = XContentHelper.toXContent(testInstance, (XContentType)xContentType, (ToXContent.Params)params, (boolean)humanReadable).toBytesRef();
        int rounds = InternalAggregationTestCase.scaledRandomIntBetween(300, 5000);
        this.concurrentTest(() -> InternalAggregationTestCase.lambda$testConcurrentToXContent$54(rounds, firstTimeBytes, testInstance, xContentType, (ToXContent.Params)params, humanReadable));
    }

    protected <P extends ParsedAggregation> P parseAndAssert(InternalAggregation aggregation, boolean shuffled, boolean addRandomFields) throws IOException {
        BytesReference mutated;
        BytesReference originalBytes;
        ToXContent.MapParams params = new ToXContent.MapParams(Collections.singletonMap("typed_keys", "true"));
        XContentType xContentType = InternalAggregationTestCase.randomFrom(XContentType.values());
        boolean humanReadable = InternalAggregationTestCase.randomBoolean();
        try {
            originalBytes = shuffled ? this.toShuffledXContent((ToXContent)aggregation, xContentType, (ToXContent.Params)params, humanReadable, new String[0]) : XContentHelper.toXContent((ToXContent)aggregation, (XContentType)xContentType, (ToXContent.Params)params, (boolean)humanReadable);
        }
        catch (IOException e) {
            throw new IOException("error converting " + aggregation, e);
        }
        if (addRandomFields) {
            Predicate<String> basicExcludes = path -> path.isEmpty() || path.endsWith(Aggregation.CommonFields.META.getPreferredName()) || path.endsWith(Aggregation.CommonFields.BUCKETS.getPreferredName()) || path.contains("top_hits");
            Predicate<String> excludes = basicExcludes.or(this.excludePathsFromXContentInsertion());
            mutated = XContentTestUtils.insertRandomFields(xContentType, originalBytes, excludes, InternalAggregationTestCase.random());
        } else {
            mutated = originalBytes;
        }
        SetOnce parsedAggregation = new SetOnce();
        try (XContentParser parser = this.createParser(xContentType.xContent(), mutated);){
            InternalAggregationTestCase.assertEquals((Object)XContentParser.Token.START_OBJECT, (Object)parser.nextToken());
            InternalAggregationTestCase.assertEquals((Object)XContentParser.Token.FIELD_NAME, (Object)parser.nextToken());
            InternalAggregationTestCase.assertEquals((Object)XContentParser.Token.START_OBJECT, (Object)parser.nextToken());
            XContentParserUtils.parseTypedKeysObject((XContentParser)parser, (String)"#", Aggregation.class, arg_0 -> ((SetOnce)parsedAggregation).set(arg_0));
            InternalAggregationTestCase.assertEquals((Object)XContentParser.Token.END_OBJECT, (Object)parser.currentToken());
            InternalAggregationTestCase.assertEquals((Object)XContentParser.Token.END_OBJECT, (Object)parser.nextToken());
            InternalAggregationTestCase.assertNull((Object)parser.nextToken());
            Aggregation agg = (Aggregation)parsedAggregation.get();
            InternalAggregationTestCase.assertEquals((Object)aggregation.getName(), (Object)agg.getName());
            InternalAggregationTestCase.assertEquals((Object)aggregation.getMetadata(), (Object)agg.getMetadata());
            InternalAggregationTestCase.assertTrue((boolean)(agg instanceof ParsedAggregation));
            InternalAggregationTestCase.assertEquals((Object)aggregation.getType(), (Object)agg.getType());
            BytesReference parsedBytes = XContentHelper.toXContent((ToXContent)agg, (XContentType)xContentType, (ToXContent.Params)params, (boolean)humanReadable);
            ElasticsearchAssertions.assertToXContentEquivalent(originalBytes, parsedBytes, xContentType);
            ParsedAggregation parsedAggregation2 = (ParsedAggregation)agg;
            return (P)parsedAggregation2;
        }
    }

    protected Predicate<String> excludePathsFromXContentInsertion() {
        return path -> false;
    }

    public static DocValueFormat randomNumericDocValueFormat() {
        ArrayList<Supplier<DocValueFormat>> formats = new ArrayList<Supplier<DocValueFormat>>(3);
        formats.add(() -> DocValueFormat.RAW);
        formats.add(() -> new DocValueFormat.Decimal(InternalAggregationTestCase.randomFrom("###.##", "###,###.##")));
        return (DocValueFormat)((Supplier)InternalAggregationTestCase.randomFrom(formats)).get();
    }

    public static DocValueFormat randomDateDocValueFormat() {
        DocValueFormat.DateTime format = new DocValueFormat.DateTime(DateFormatter.forPattern((String)InternalAggregationTestCase.randomDateFormatterPattern()), InternalAggregationTestCase.randomZone(), InternalAggregationTestCase.randomFrom(DateFieldMapper.Resolution.values()));
        if (InternalAggregationTestCase.randomBoolean()) {
            return DocValueFormat.enableFormatSortValues((DocValueFormat)format);
        }
        return format;
    }

    public static void assertMultiBucketConsumer(Aggregation agg, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer) {
        InternalAggregationTestCase.assertMultiBucketConsumer(InternalMultiBucketAggregation.countInnerBucket((Aggregation)agg), bucketConsumer);
    }

    private static void assertMultiBucketConsumer(int innerBucketCount, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer) {
        InternalAggregationTestCase.assertThat((Object)bucketConsumer.getCount(), (Matcher)Matchers.equalTo((Object)innerBucketCount));
    }

    private static /* synthetic */ void lambda$testConcurrentToXContent$54(int rounds, BytesRef firstTimeBytes, InternalAggregation testInstance, XContentType xContentType, ToXContent.Params params, boolean humanReadable) {
        try {
            for (int r = 0; r < rounds; ++r) {
                InternalAggregationTestCase.assertEquals((Object)firstTimeBytes, (Object)XContentHelper.toXContent((ToXContent)testInstance, (XContentType)xContentType, (ToXContent.Params)params, (boolean)humanReadable).toBytesRef());
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        HashMap<String, ContextParser> map = new HashMap<String, ContextParser>();
        map.put("cardinality", (p, c) -> ParsedCardinality.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("hdr_percentiles", (p, c) -> ParsedHDRPercentiles.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("hdr_percentile_ranks", (p, c) -> ParsedHDRPercentileRanks.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("tdigest_percentiles", (p, c) -> ParsedTDigestPercentiles.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("tdigest_percentile_ranks", (p, c) -> ParsedTDigestPercentileRanks.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("percentiles_bucket", (p, c) -> ParsedPercentilesBucket.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("median_absolute_deviation", (p, c) -> ParsedMedianAbsoluteDeviation.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("min", (p, c) -> ParsedMin.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("max", (p, c) -> ParsedMax.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("sum", (p, c) -> ParsedSum.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("avg", (p, c) -> ParsedAvg.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("weighted_avg", (p, c) -> ParsedWeightedAvg.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("value_count", (p, c) -> ParsedValueCount.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("simple_value", (p, c) -> ParsedSimpleValue.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("bucket_metric_value", (p, c) -> ParsedBucketMetricValue.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("stats", (p, c) -> ParsedStats.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("stats_bucket", (p, c) -> ParsedStatsBucket.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("extended_stats", (p, c) -> ParsedExtendedStats.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("extended_stats_bucket", (p, c) -> ParsedExtendedStatsBucket.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("geo_bounds", (p, c) -> ParsedGeoBounds.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("geo_centroid", (p, c) -> ParsedGeoCentroid.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("histogram", (p, c) -> ParsedHistogram.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("date_histogram", (p, c) -> ParsedDateHistogram.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("variable_width_histogram", (p, c) -> ParsedVariableWidthHistogram.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("sterms", (p, c) -> ParsedStringTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("lterms", (p, c) -> ParsedLongTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("dterms", (p, c) -> ParsedDoubleTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("lrareterms", (p, c) -> ParsedLongRareTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("srareterms", (p, c) -> ParsedStringRareTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("missing", (p, c) -> ParsedMissing.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("nested", (p, c) -> ParsedNested.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("reverse_nested", (p, c) -> ParsedReverseNested.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("global", (p, c) -> ParsedGlobal.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("filter", (p, c) -> ParsedFilter.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("sampler", (p, c) -> ParsedSampler.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("geohash_grid", (p, c) -> ParsedGeoHashGrid.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("geotile_grid", (p, c) -> ParsedGeoTileGrid.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("range", (p, c) -> ParsedRange.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("date_range", (p, c) -> ParsedDateRange.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("geo_distance", (p, c) -> ParsedGeoDistance.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("filters", (p, c) -> ParsedFilters.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("siglterms", (p, c) -> ParsedSignificantLongTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("sigsterms", (p, c) -> ParsedSignificantStringTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("scripted_metric", (p, c) -> ParsedScriptedMetric.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("ip_range", (p, c) -> ParsedBinaryRange.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("top_hits", (p, c) -> ParsedTopHits.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("composite", (p, c) -> ParsedComposite.fromXContent((XContentParser)p, (String)((String)c)));
        namedXContents = map.entrySet().stream().map(entry -> new NamedXContentRegistry.Entry(Aggregation.class, new ParseField((String)entry.getKey(), new String[0]), (ContextParser)entry.getValue())).collect(Collectors.toList());
    }

    public record BuilderAndToReduce<T>(AggregationBuilder builder, List<T> toReduce) {
    }

    private class MockAggregationBuilder
    extends AbstractAggregationBuilder<MockAggregationBuilder> {
        MockAggregationBuilder(String name) {
            super(name);
        }

        public String getType() {
            throw new UnsupportedOperationException();
        }

        protected void doWriteTo(StreamOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }

        protected AggregatorFactory doBuild(AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subfactoriesBuilder) throws IOException {
            throw new UnsupportedOperationException();
        }

        protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            throw new UnsupportedOperationException();
        }

        protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
            throw new UnsupportedOperationException();
        }

        public AggregationBuilder.BucketCardinality bucketCardinality() {
            throw new UnsupportedOperationException();
        }

        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersion.ZERO;
        }
    }
}

