/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.core.Releasable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class MockLogAppender
extends AbstractAppender {
    private static final String COMMON_PREFIX = System.getProperty("es.logger.prefix", "org.elasticsearch.");
    private final List<WrappedLoggingExpectation> expectations = new CopyOnWriteArrayList<WrappedLoggingExpectation>();

    public MockLogAppender() {
        super("mock", null, null, false, Property.EMPTY_ARRAY);
    }

    public void addExpectation(LoggingExpectation expectation) {
        this.expectations.add(new WrappedLoggingExpectation(expectation));
    }

    public void append(LogEvent event) {
        for (LoggingExpectation loggingExpectation : this.expectations) {
            loggingExpectation.match(event);
        }
    }

    public void assertAllExpectationsMatched() {
        for (LoggingExpectation loggingExpectation : this.expectations) {
            loggingExpectation.assertMatched();
        }
    }

    private static String getLoggerName(String name) {
        if (name.startsWith("org.elasticsearch.")) {
            name = name.substring("org.elasticsearch.".length());
        }
        return COMMON_PREFIX + name;
    }

    public Releasable capturing(Class<?> ... classes) {
        Logger[] loggers;
        this.start();
        for (Logger logger : loggers = (Logger[])Arrays.stream(classes).map(LogManager::getLogger).toArray(Logger[]::new)) {
            Loggers.addAppender((Logger)logger, (Appender)this);
        }
        return () -> {
            for (Logger logger : loggers) {
                Loggers.removeAppender((Logger)logger, (Appender)this);
            }
            this.stop();
            for (WrappedLoggingExpectation expectation : this.expectations) {
                MatcherAssert.assertThat((String)("Method assertMatched() not called on LoggingExpectation instance before release: " + expectation), (Object)expectation.assertMatchedCalled.get(), (Matcher)Matchers.is((Object)true));
            }
        };
    }

    public static void assertThatLogger(Runnable action, Class<?> loggerOwner, AbstractEventExpectation expectation) {
        MockLogAppender mockAppender = new MockLogAppender();
        try (Releasable ignored = mockAppender.capturing(loggerOwner);){
            mockAppender.addExpectation(expectation);
            action.run();
            mockAppender.assertAllExpectationsMatched();
        }
    }

    private static class WrappedLoggingExpectation
    implements LoggingExpectation {
        private final AtomicBoolean assertMatchedCalled = new AtomicBoolean(false);
        private final LoggingExpectation delegate;

        private WrappedLoggingExpectation(LoggingExpectation delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        @Override
        public void match(LogEvent event) {
            this.delegate.match(event);
        }

        @Override
        public void assertMatched() {
            try {
                this.delegate.assertMatched();
            }
            finally {
                this.assertMatchedCalled.set(true);
            }
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    public static interface LoggingExpectation {
        public void match(LogEvent var1);

        public void assertMatched();
    }

    public static class PatternSeenEventExpectation
    implements LoggingExpectation {
        protected final String name;
        protected final String logger;
        protected final Level level;
        protected final Pattern pattern;
        volatile boolean saw;

        public PatternSeenEventExpectation(String name, String logger, Level level, String pattern) {
            this.name = name;
            this.logger = logger;
            this.level = level;
            this.pattern = Pattern.compile(pattern);
        }

        @Override
        public void match(LogEvent event) {
            if (event.getLevel().equals((Object)this.level) && event.getLoggerName().equals(this.logger) && this.pattern.matcher(event.getMessage().getFormattedMessage()).matches()) {
                this.saw = true;
            }
        }

        @Override
        public void assertMatched() {
            MatcherAssert.assertThat((String)this.name, (Object)this.saw, (Matcher)CoreMatchers.equalTo((Object)true));
        }
    }

    public static class ExceptionSeenEventExpectation
    extends SeenEventExpectation {
        private final Class<? extends Exception> clazz;
        private final String exceptionMessage;

        public ExceptionSeenEventExpectation(String name, String logger, Level level, String message, Class<? extends Exception> clazz, String exceptionMessage) {
            super(name, logger, level, message);
            this.clazz = clazz;
            this.exceptionMessage = exceptionMessage;
        }

        @Override
        public boolean innerMatch(LogEvent event) {
            return event.getThrown() != null && event.getThrown().getClass() == this.clazz && event.getThrown().getMessage().equals(this.exceptionMessage);
        }
    }

    public static class EventuallySeenEventExpectation
    extends SeenEventExpectation {
        private volatile boolean expectSeen = false;

        public EventuallySeenEventExpectation(String name, String logger, Level level, String message) {
            super(name, logger, level, message);
        }

        public void setExpectSeen() {
            this.expectSeen = true;
        }

        @Override
        public void assertMatched() {
            if (this.expectSeen) {
                super.assertMatched();
            } else {
                MatcherAssert.assertThat((String)("expected not to see " + this.name + " yet but did"), (Object)this.saw, (Matcher)CoreMatchers.equalTo((Object)false));
            }
        }
    }

    public static class SeenEventExpectation
    extends AbstractEventExpectation {
        public SeenEventExpectation(String name, String logger, Level level, String message) {
            super(name, logger, level, message);
        }

        @Override
        public void assertMatched() {
            MatcherAssert.assertThat((String)("expected to see " + this.name + " but did not"), (Object)this.saw, (Matcher)CoreMatchers.equalTo((Object)true));
        }
    }

    public static class UnseenEventExpectation
    extends AbstractEventExpectation {
        public UnseenEventExpectation(String name, String logger, Level level, String message) {
            super(name, logger, level, message);
        }

        @Override
        public void assertMatched() {
            MatcherAssert.assertThat((String)("expected not to see " + this.name + " but did"), (Object)this.saw, (Matcher)CoreMatchers.equalTo((Object)false));
        }
    }

    public static abstract class AbstractEventExpectation
    implements LoggingExpectation {
        protected final String name;
        protected final String logger;
        protected final Level level;
        protected final String message;
        volatile boolean saw;

        public AbstractEventExpectation(String name, String logger, Level level, String message) {
            this.name = name;
            this.logger = MockLogAppender.getLoggerName(logger);
            this.level = level;
            this.message = message;
            this.saw = false;
        }

        @Override
        public void match(LogEvent event) {
            if (event.getLevel().equals((Object)this.level) && event.getLoggerName().equals(this.logger) && this.innerMatch(event)) {
                if (Regex.isSimpleMatchPattern((String)this.message)) {
                    if (Regex.simpleMatch((String)this.message, (String)event.getMessage().getFormattedMessage())) {
                        this.saw = true;
                    }
                } else if (event.getMessage().getFormattedMessage().contains(this.message)) {
                    this.saw = true;
                }
            }
        }

        public boolean innerMatch(LogEvent event) {
            return true;
        }
    }
}

