/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.elasticsearch.core.Nullable;

public class NotEqualMessageBuilder {
    private final StringBuilder message = new StringBuilder();
    private int indent = 0;

    public String toString() {
        return this.message.toString();
    }

    public void compareMaps(Map<String, Object> actual, Map<String, Object> expected) {
        actual = new TreeMap<String, Object>(actual);
        expected = new TreeMap<String, Object>(expected);
        for (Map.Entry<String, Object> expectedEntry : expected.entrySet()) {
            boolean hadKey = actual.containsKey(expectedEntry.getKey());
            Object actualValue = actual.remove(expectedEntry.getKey());
            this.compare(expectedEntry.getKey(), hadKey, actualValue, expectedEntry.getValue());
        }
        for (Map.Entry<String, Object> unmatchedEntry : actual.entrySet()) {
            this.field(unmatchedEntry.getKey(), "unexpected but found [" + unmatchedEntry.getValue() + "]");
        }
    }

    public void compareLists(List<Object> actual, List<Object> expected) {
        int i;
        for (i = 0; i < actual.size() && i < expected.size(); ++i) {
            this.compare(Integer.toString(i), true, actual.get(i), expected.get(i));
        }
        if (actual.size() == expected.size()) {
            return;
        }
        this.indent();
        if (actual.size() < expected.size()) {
            this.message.append("expected [").append(expected.size() - i).append("] more entries\n");
            return;
        }
        this.message.append("received [").append(actual.size() - i).append("] more entries than expected\n");
    }

    public void compare(String field, boolean hadKey, @Nullable Object actual, Object expected) {
        if (expected instanceof Map) {
            if (!hadKey) {
                this.field(field, "expected map but not found");
                return;
            }
            if (actual == null) {
                this.field(field, "expected map but was [null]");
                return;
            }
            if (!(actual instanceof Map)) {
                this.field(field, "expected map but found [" + actual + "]");
                return;
            }
            Map expectedMap = (Map)expected;
            Map actualMap = (Map)actual;
            if (expectedMap.isEmpty() && actualMap.isEmpty()) {
                this.field(field, "same [empty map]");
                return;
            }
            this.field(field, null);
            ++this.indent;
            this.compareMaps(actualMap, expectedMap);
            --this.indent;
            return;
        }
        if (expected instanceof List) {
            if (!hadKey) {
                this.field(field, "expected list but not found");
                return;
            }
            if (actual == null) {
                this.field(field, "expected list but was [null]");
                return;
            }
            if (!(actual instanceof List)) {
                this.field(field, "expected list but found [" + actual + "]");
                return;
            }
            List expectedList = (List)expected;
            List actualList = (List)actual;
            if (expectedList.isEmpty() && actualList.isEmpty()) {
                this.field(field, "same [empty list]");
                return;
            }
            this.field(field, null);
            ++this.indent;
            this.compareLists(actualList, expectedList);
            --this.indent;
            return;
        }
        if (!hadKey) {
            this.field(field, "expected [" + expected + "] but not found");
            return;
        }
        if (actual == null) {
            if (expected == null) {
                this.field(field, "same [" + expected + "]");
                return;
            }
            this.field(field, "expected [" + expected + "] but was [null]");
            return;
        }
        if (Objects.equals(expected, actual)) {
            if (expected instanceof String) {
                Object expectedString = (String)expected;
                if (((String)expectedString).length() > 50) {
                    expectedString = ((String)expectedString).substring(0, 50) + "...";
                }
                this.field(field, "same [" + (String)expectedString + "]");
                return;
            }
            this.field(field, "same [" + expected + "]");
            return;
        }
        this.field(field, "expected " + expected.getClass().getSimpleName() + " [" + expected + "] but was " + actual.getClass().getSimpleName() + " [" + actual + "]");
    }

    private void indent() {
        for (int i = 0; i < this.indent; ++i) {
            this.message.append("  ");
        }
    }

    private void field(Object name, String info) {
        this.indent();
        this.message.append(String.format(Locale.ROOT, "%30s: ", name));
        if (info != null) {
            this.message.append(info);
        }
        this.message.append('\n');
    }
}

