/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.KnownTransportVersions;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.test.ESTestCase;

public class TransportVersionUtils {
    public static List<TransportVersion> allReleasedVersions() {
        return KnownTransportVersions.ALL_VERSIONS;
    }

    public static TransportVersion getFirstVersion() {
        return KnownTransportVersions.ALL_VERSIONS.get(0);
    }

    public static TransportVersion randomVersion() {
        return ESTestCase.randomFrom(KnownTransportVersions.ALL_VERSIONS);
    }

    public static TransportVersion randomVersion(Set<TransportVersion> ignore) {
        return (TransportVersion)ESTestCase.randomFrom(KnownTransportVersions.ALL_VERSIONS.stream().filter(v -> !ignore.contains(v)).collect(Collectors.toList()));
    }

    public static TransportVersion randomVersion(Random random) {
        return KnownTransportVersions.ALL_VERSIONS.get(random.nextInt(KnownTransportVersions.ALL_VERSIONS.size()));
    }

    public static TransportVersion randomVersionBetween(Random random, @Nullable TransportVersion minVersion, @Nullable TransportVersion maxVersion) {
        if (minVersion != null && maxVersion != null && maxVersion.before(minVersion)) {
            throw new IllegalArgumentException("maxVersion [" + maxVersion + "] cannot be less than minVersion [" + minVersion + "]");
        }
        int minVersionIndex = 0;
        if (minVersion != null) {
            minVersionIndex = Collections.binarySearch(KnownTransportVersions.ALL_VERSIONS, minVersion);
        }
        int maxVersionIndex = KnownTransportVersions.ALL_VERSIONS.size() - 1;
        if (maxVersion != null) {
            maxVersionIndex = Collections.binarySearch(KnownTransportVersions.ALL_VERSIONS, maxVersion);
        }
        if (minVersionIndex < 0) {
            throw new IllegalArgumentException("minVersion [" + minVersion + "] does not exist.");
        }
        if (maxVersionIndex < 0) {
            throw new IllegalArgumentException("maxVersion [" + maxVersion + "] does not exist.");
        }
        int range = maxVersionIndex + 1 - minVersionIndex;
        return KnownTransportVersions.ALL_VERSIONS.get(minVersionIndex + random.nextInt(range));
    }

    public static TransportVersion getPreviousVersion() {
        TransportVersion version = TransportVersionUtils.getPreviousVersion(TransportVersion.CURRENT);
        assert (version.before(TransportVersion.CURRENT));
        return version;
    }

    public static TransportVersion getPreviousVersion(TransportVersion version) {
        int place = Collections.binarySearch(KnownTransportVersions.ALL_VERSIONS, version);
        if (place < 0) {
            place = -(place + 1);
        }
        if (place < 1) {
            throw new IllegalArgumentException("couldn't find any released versions before [" + version + "]");
        }
        return KnownTransportVersions.ALL_VERSIONS.get(place - 1);
    }

    public static TransportVersion getNextVersion(TransportVersion version) {
        int place = Collections.binarySearch(KnownTransportVersions.ALL_VERSIONS, version);
        place = place < 0 ? -(place + 1) : ++place;
        if (place < 0 || place >= KnownTransportVersions.ALL_VERSIONS.size()) {
            throw new IllegalArgumentException("couldn't find any released versions after [" + version + "]");
        }
        return KnownTransportVersions.ALL_VERSIONS.get(place);
    }

    public static TransportVersion randomCompatibleVersion(Random random) {
        return TransportVersionUtils.randomVersionBetween(random, TransportVersion.MINIMUM_COMPATIBLE, TransportVersion.CURRENT);
    }
}

