/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.WarningsHandler;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.ssl.PemUtils;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.CharArrays;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.seqno.ReplicationTracker;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.rest.ObjectPath;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;

public abstract class ESRestTestCase
extends ESTestCase {
    public static final String TRUSTSTORE_PATH = "truststore.path";
    public static final String TRUSTSTORE_PASSWORD = "truststore.password";
    public static final String CERTIFICATE_AUTHORITIES = "certificate_authorities";
    public static final String CLIENT_CERT_PATH = "client.cert.path";
    public static final String CLIENT_KEY_PATH = "client.key.path";
    public static final String CLIENT_KEY_PASSWORD = "client.key.password";
    public static final String CLIENT_SOCKET_TIMEOUT = "client.socket.timeout";
    public static final String CLIENT_PATH_PREFIX = "client.path.prefix";
    private static List<HttpHost> clusterHosts;
    private static RestClient client;
    private static RestClient adminClient;
    private static Boolean hasXPack;
    private static Boolean hasIlm;
    private static Boolean hasRollups;
    private static Boolean hasCcr;
    private static Boolean hasShutdown;
    private static TreeSet<Version> nodeVersions;
    private static final String WAIT_FOR_ACTIVE_SHARDS_DEFAULT_DEPRECATION_MESSAGE = "the default value for the ?wait_for_active_shards parameter will change from '0' to 'index-setting' in version 8; specify '?wait_for_active_shards=index-setting' to adopt the future default behaviour, or '?wait_for_active_shards=0' to preserve today's behaviour";
    static final Pattern CREATE_INDEX_MULTIPLE_MATCHING_TEMPLATES;
    static final Pattern PUT_TEMPLATE_MULTIPLE_MATCHING_TEMPLATES;

    public static Map<String, Object> entityAsMap(Response response) throws IOException {
        XContentType xContentType = XContentType.fromMediaType((String)response.getEntity().getContentType().getValue());
        try (XContentParser parser = xContentType.xContent().createParser(XContentParserConfiguration.EMPTY.withRegistry(NamedXContentRegistry.EMPTY).withDeprecationHandler(DeprecationHandler.THROW_UNSUPPORTED_OPERATION), response.getEntity().getContent());){
            Map map = parser.map();
            return map;
        }
    }

    public static List<Object> entityAsList(Response response) throws IOException {
        XContentType xContentType = XContentType.fromMediaType((String)response.getEntity().getContentType().getValue());
        try (XContentParser parser = xContentType.xContent().createParser(XContentParserConfiguration.EMPTY.withRegistry(NamedXContentRegistry.EMPTY).withDeprecationHandler(DeprecationHandler.THROW_UNSUPPORTED_OPERATION), response.getEntity().getContent());){
            List list = parser.list();
            return list;
        }
    }

    public static boolean hasXPack() {
        if (hasXPack == null) {
            throw new IllegalStateException("must be called inside of a rest test case test");
        }
        return hasXPack;
    }

    @Before
    public void initClient() throws IOException {
        if (client == null) {
            assert (adminClient == null);
            assert (clusterHosts == null);
            assert (hasXPack == null);
            assert (hasIlm == null);
            assert (hasRollups == null);
            assert (hasCcr == null);
            assert (hasShutdown == null);
            assert (nodeVersions == null);
            String cluster = this.getTestRestCluster();
            String[] stringUrls = cluster.split(",");
            ArrayList<HttpHost> hosts = new ArrayList<HttpHost>(stringUrls.length);
            for (String stringUrl : stringUrls) {
                int portSeparator = stringUrl.lastIndexOf(58);
                if (portSeparator < 0) {
                    throw new IllegalArgumentException("Illegal cluster url [" + stringUrl + "]");
                }
                String host = stringUrl.substring(0, portSeparator);
                int port = Integer.valueOf(stringUrl.substring(portSeparator + 1));
                hosts.add(this.buildHttpHost(host, port));
            }
            clusterHosts = Collections.unmodifiableList(hosts);
            this.logger.info("initializing REST clients against {}", clusterHosts);
            client = this.buildClient(this.restClientSettings(), clusterHosts.toArray(new HttpHost[clusterHosts.size()]));
            adminClient = this.buildClient(this.restAdminSettings(), clusterHosts.toArray(new HttpHost[clusterHosts.size()]));
            hasXPack = false;
            hasIlm = false;
            hasRollups = false;
            hasCcr = false;
            hasShutdown = false;
            nodeVersions = new TreeSet();
            Map<String, Object> response = ESRestTestCase.entityAsMap(adminClient.performRequest(new Request("GET", "_nodes/plugins")));
            Map nodes = (Map)response.get("nodes");
            for (Map.Entry node : nodes.entrySet()) {
                Map nodeInfo = (Map)node.getValue();
                nodeVersions.add(Version.fromString((String)nodeInfo.get("version").toString()));
                for (Object module : (List)nodeInfo.get("modules")) {
                    Map moduleInfo = (Map)module;
                    String moduleName = moduleInfo.get("name").toString();
                    if (moduleName.startsWith("x-pack")) {
                        hasXPack = true;
                    }
                    if (moduleName.equals("x-pack-ilm")) {
                        hasIlm = true;
                    }
                    if (moduleName.equals("x-pack-rollup")) {
                        hasRollups = true;
                    }
                    if (moduleName.equals("x-pack-ccr")) {
                        hasCcr = true;
                    }
                    if (!moduleName.equals("x-pack-shutdown")) continue;
                    hasShutdown = true;
                }
            }
        }
        assert (client != null);
        assert (adminClient != null);
        assert (clusterHosts != null);
        assert (hasXPack != null);
        assert (hasIlm != null);
        assert (hasRollups != null);
        assert (hasCcr != null);
        assert (hasShutdown != null);
        assert (nodeVersions != null);
    }

    protected String getTestRestCluster() {
        String cluster = System.getProperty("tests.rest.cluster");
        if (cluster == null) {
            throw new RuntimeException("Must specify [tests.rest.cluster] system property with a comma delimited list of [host:port] to which to send REST requests");
        }
        return cluster;
    }

    protected String getTestReadinessPorts() {
        String ports = System.getProperty("tests.cluster.readiness");
        if (ports == null) {
            throw new RuntimeException("Must specify [tests.rest.cluster.readiness] system property with a comma delimited list to which to send readiness requests");
        }
        return ports;
    }

    public static RequestOptions expectVersionSpecificWarnings(Consumer<VersionSensitiveWarningsHandler> expectationsSetter) {
        RequestOptions.Builder builder = RequestOptions.DEFAULT.toBuilder();
        VersionSensitiveWarningsHandler warningsHandler = new VersionSensitiveWarningsHandler(nodeVersions);
        expectationsSetter.accept(warningsHandler);
        builder.setWarningsHandler((WarningsHandler)warningsHandler);
        return builder.build();
    }

    public static RequestOptions expectWarnings(String ... warnings) {
        return ESRestTestCase.expectVersionSpecificWarnings(consumer -> consumer.current(warnings));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String basicAuthHeaderValue(String username, SecureString passwd) {
        String string;
        CharBuffer chars = CharBuffer.allocate(username.length() + passwd.length() + 1);
        byte[] charBytes = null;
        try {
            chars.put(username).put(':').put(passwd.getChars());
            charBytes = CharArrays.toUtf8Bytes((char[])chars.array());
            String basicToken = Base64.getEncoder().encodeToString(charBytes);
            string = "Basic " + basicToken;
        }
        catch (Throwable throwable) {
            Arrays.fill(chars.array(), '\u0000');
            if (charBytes != null) {
                Arrays.fill(charBytes, (byte)0);
            }
            throw throwable;
        }
        Arrays.fill(chars.array(), '\u0000');
        if (charBytes != null) {
            Arrays.fill(charBytes, (byte)0);
        }
        return string;
    }

    protected HttpHost buildHttpHost(String host, int port) {
        return new HttpHost(host, port, this.getProtocol());
    }

    @After
    public final void cleanUpCluster() throws Exception {
        if (!this.preserveClusterUponCompletion()) {
            ESRestTestCase.ensureNoInitializingShards();
            this.wipeCluster();
            this.waitForClusterStateUpdatesToFinish();
            this.checkForUnexpectedlyRecreatedObjects();
            this.logIfThereAreRunningTasks();
        }
    }

    @AfterClass
    public static void closeClients() throws IOException {
        try {
            IOUtils.close((Closeable[])new Closeable[]{client, adminClient});
        }
        finally {
            clusterHosts = null;
            client = null;
            adminClient = null;
            hasXPack = null;
            hasRollups = null;
            hasCcr = null;
            hasShutdown = null;
            hasIlm = null;
            nodeVersions = null;
        }
    }

    protected static RestClient client() {
        return client;
    }

    protected static RestClient adminClient() {
        return adminClient;
    }

    public static void waitForPendingTasks(RestClient restClient) throws Exception {
        ESRestTestCase.waitForPendingTasks(restClient, taskName -> false);
    }

    public static void waitForPendingTasks(RestClient restClient, Predicate<String> taskFilter) throws Exception {
        ESRestTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            block8: {
                try {
                    Request request = new Request("GET", "/_cat/tasks");
                    request.addParameter("detailed", "true");
                    Response response = restClient.performRequest(request);
                    if (response.getStatusLine().getStatusCode() != 200) break block8;
                    try (BufferedReader responseReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));){
                        String line;
                        int activeTasks = 0;
                        StringBuilder tasksListString = new StringBuilder();
                        while ((line = responseReader.readLine()) != null) {
                            String taskName = line.split("\\s+")[0];
                            if (taskName.startsWith("cluster:monitor/tasks/lists") || taskName.startsWith("health-node") || taskFilter.test(taskName)) continue;
                            ++activeTasks;
                            tasksListString.append(line);
                            tasksListString.append('\n');
                        }
                        ESRestTestCase.assertEquals((String)(activeTasks + " active tasks found:\n" + tasksListString), (long)0L, (long)activeTasks);
                    }
                }
                catch (IOException e) {
                    throw new AssertionError("error getting active tasks list", e);
                }
            }
        }), 30L, TimeUnit.SECONDS);
    }

    protected boolean preserveClusterUponCompletion() {
        return false;
    }

    protected boolean preserveIndicesUponCompletion() {
        return false;
    }

    protected boolean preserveSecurityIndicesUponCompletion() {
        return false;
    }

    protected boolean preserveTemplatesUponCompletion() {
        return false;
    }

    protected boolean resetFeatureStates() {
        try {
            if (!ESRestTestCase.isMlEnabled() && ESRestTestCase.minimumNodeVersion().before(Version.V_8_7_0)) {
                return false;
            }
        }
        catch (IOException e) {
            throw new AssertionError("Failed to find a minimum node version.", e);
        }
        return true;
    }

    protected boolean preserveDataStreamsUponCompletion() {
        return false;
    }

    protected boolean preserveClusterSettings() {
        return false;
    }

    protected boolean preserveReposUponCompletion() {
        return false;
    }

    protected boolean preserveSnapshotsUponCompletion() {
        return false;
    }

    protected boolean preserveRollupJobsUponCompletion() {
        return false;
    }

    protected boolean preserveILMPoliciesUponCompletion() {
        return false;
    }

    protected Set<String> preserveILMPolicyIds() {
        return Sets.newHashSet((Object[])new String[]{"ilm-history-ilm-policy", "slm-history-ilm-policy", "watch-history-ilm-policy", "watch-history-ilm-policy-16", "ml-size-based-ilm-policy", "logs", "metrics", "synthetics", "7-days-default", "30-days-default", "90-days-default", "180-days-default", "365-days-default", ".fleet-actions-results-ilm-policy", ".fleet-file-data-ilm-policy", ".fleet-files-ilm-policy", ".deprecation-indexing-ilm-policy", ".monitoring-8-ilm-policy", "behavioral_analytics-events-default_policy"});
    }

    protected boolean preserveAutoFollowPatternsUponCompletion() {
        return false;
    }

    protected boolean preserveSLMPoliciesUponCompletion() {
        return false;
    }

    protected boolean preserveSearchableSnapshotsIndicesUponCompletion() {
        return false;
    }

    private void wipeCluster() throws Exception {
        if (hasRollups.booleanValue() && !this.preserveRollupJobsUponCompletion()) {
            this.wipeRollupJobs();
            this.waitForPendingRollupTasks();
        }
        if (!this.preserveSLMPoliciesUponCompletion()) {
            ESRestTestCase.deleteAllSLMPolicies();
        }
        if (ESRestTestCase.hasXPack() && nodeVersions.first().onOrAfter(Version.V_7_8_0) && !this.preserveSearchableSnapshotsIndicesUponCompletion()) {
            this.wipeSearchableSnapshotsIndices();
        }
        this.wipeSnapshots();
        if (this.resetFeatureStates()) {
            Request postRequest = new Request("POST", "/_features/_reset");
            ESRestTestCase.adminClient().performRequest(postRequest);
        }
        if (!this.preserveDataStreamsUponCompletion()) {
            ESRestTestCase.wipeDataStreams();
        }
        if (!this.preserveIndicesUponCompletion()) {
            ESRestTestCase.wipeAllIndices(this.preserveSecurityIndicesUponCompletion());
        }
        if (!this.preserveTemplatesUponCompletion()) {
            if (hasXPack.booleanValue()) {
                if (nodeVersions.stream().allMatch(version -> version.onOrAfter(Version.V_7_7_0))) {
                    try {
                        Request getTemplatesRequest = new Request("GET", "_index_template");
                        Map composableIndexTemplates = XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)EntityUtils.toString((HttpEntity)ESRestTestCase.adminClient().performRequest(getTemplatesRequest).getEntity()), (boolean)false);
                        List names = ((List)composableIndexTemplates.get("index_templates")).stream().map(ct -> (String)((Map)ct).get("name")).filter(name -> !ESRestTestCase.isXPackTemplate(name)).collect(Collectors.toList());
                        if (!names.isEmpty()) {
                            if (nodeVersions.stream().allMatch(version -> version.onOrAfter(Version.V_7_13_0))) {
                                try {
                                    ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_index_template/" + String.join((CharSequence)",", names)));
                                }
                                catch (ResponseException e) {
                                    this.logger.warn(() -> Strings.format((String)"unable to remove multiple composable index templates %s", (Object[])new Object[]{names}), (Throwable)e);
                                }
                            } else {
                                for (String name2 : names) {
                                    try {
                                        ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_index_template/" + name2));
                                    }
                                    catch (ResponseException e) {
                                        this.logger.warn(() -> Strings.format((String)"unable to remove composable index template %s", (Object[])new Object[]{name2}), (Throwable)e);
                                    }
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        this.logger.debug("ignoring exception removing all composable index templates", (Throwable)e);
                    }
                    try {
                        Request compReq = new Request("GET", "_component_template");
                        String componentTemplates = EntityUtils.toString((HttpEntity)ESRestTestCase.adminClient().performRequest(compReq).getEntity());
                        Map cTemplates = XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)componentTemplates, (boolean)false);
                        List names = ((List)cTemplates.get("component_templates")).stream().map(ct -> (String)((Map)ct).get("name")).filter(name -> !ESRestTestCase.isXPackTemplate(name)).collect(Collectors.toList());
                        if (!names.isEmpty()) {
                            if (nodeVersions.stream().allMatch(version -> version.onOrAfter(Version.V_7_13_0))) {
                                try {
                                    ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_component_template/" + String.join((CharSequence)",", names)));
                                }
                                catch (ResponseException e) {
                                    this.logger.warn(() -> Strings.format((String)"unable to remove multiple component templates %s", (Object[])new Object[]{names}), (Throwable)e);
                                }
                            } else {
                                for (String componentTemplate : names) {
                                    try {
                                        ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_component_template/" + componentTemplate));
                                    }
                                    catch (ResponseException e) {
                                        this.logger.warn(() -> Strings.format((String)"unable to remove component template %s", (Object[])new Object[]{componentTemplate}), (Throwable)e);
                                    }
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        this.logger.debug("ignoring exception removing all component templates", (Throwable)e);
                    }
                }
                Request getLegacyTemplatesRequest = new Request("GET", "_template");
                Map legacyTemplates = XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)EntityUtils.toString((HttpEntity)ESRestTestCase.adminClient().performRequest(getLegacyTemplatesRequest).getEntity()), (boolean)false);
                for (String name3 : legacyTemplates.keySet()) {
                    if (ESRestTestCase.isXPackTemplate(name3)) continue;
                    try {
                        ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_template/" + name3));
                    }
                    catch (ResponseException e) {
                        this.logger.debug(() -> Strings.format((String)"unable to remove index template %s", (Object[])new Object[]{name3}), (Throwable)e);
                    }
                }
            } else {
                this.logger.debug("Clearing all templates");
                ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_template/*"));
                try {
                    ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_index_template/*"));
                    ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_component_template/*"));
                }
                catch (ResponseException responseException) {
                    // empty catch block
                }
            }
        }
        if (!this.preserveClusterSettings()) {
            this.wipeClusterSettings();
        }
        if (hasIlm.booleanValue() && !this.preserveILMPoliciesUponCompletion()) {
            ESRestTestCase.deleteAllILMPolicies(this.preserveILMPolicyIds());
        }
        if (hasCcr.booleanValue() && !this.preserveAutoFollowPatternsUponCompletion()) {
            ESRestTestCase.deleteAllAutoFollowPatterns();
        }
        this.deleteAllNodeShutdownMetadata();
    }

    private void checkForUnexpectedlyRecreatedObjects() throws IOException {
        if (hasIlm.booleanValue() && !this.preserveILMPoliciesUponCompletion()) {
            Set<String> unexpectedIlmPlicies = this.getAllUnexpectedIlmPolicies(this.preserveILMPolicyIds());
            ESRestTestCase.assertTrue((String)("Expected no ILM policies after deletions, but found " + unexpectedIlmPlicies.stream().collect(Collectors.joining(", "))), (boolean)unexpectedIlmPlicies.isEmpty());
        }
        Set<String> unexpectedTemplates = this.getAllUnexpectedTemplates();
        ESRestTestCase.assertTrue((String)("Expected no templates after deletions, but found " + unexpectedTemplates.stream().collect(Collectors.joining(", "))), (boolean)unexpectedTemplates.isEmpty());
    }

    private Set<String> getAllUnexpectedIlmPolicies(Set<String> exclusions) throws IOException {
        Map<String, Object> policies;
        try {
            Response response = ESRestTestCase.adminClient().performRequest(new Request("GET", "/_ilm/policy"));
            policies = ESRestTestCase.entityAsMap(response);
        }
        catch (ResponseException e) {
            if (RestStatus.METHOD_NOT_ALLOWED.getStatus() == e.getResponse().getStatusLine().getStatusCode() || RestStatus.BAD_REQUEST.getStatus() == e.getResponse().getStatusLine().getStatusCode()) {
                policies = new HashMap<String, Object>();
            }
            throw e;
        }
        Set<String> unexpectedPolicies = policies.keySet().stream().filter(p -> !exclusions.contains(p)).collect(Collectors.toSet());
        return unexpectedPolicies;
    }

    private Set<String> getAllUnexpectedTemplates() throws IOException {
        HashSet<String> unexpectedTemplates = new HashSet<String>();
        if (!this.preserveDataStreamsUponCompletion() && !this.preserveTemplatesUponCompletion() && hasXPack.booleanValue()) {
            if (nodeVersions.stream().allMatch(version -> version.onOrAfter(Version.V_7_8_0))) {
                Request getTemplatesRequest = new Request("GET", "_index_template");
                Map composableIndexTemplates = XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)EntityUtils.toString((HttpEntity)ESRestTestCase.adminClient().performRequest(getTemplatesRequest).getEntity()), (boolean)false);
                unexpectedTemplates.addAll(((List)composableIndexTemplates.get("index_templates")).stream().map(ct -> (String)((Map)ct).get("name")).filter(name -> !ESRestTestCase.isXPackTemplate(name)).collect(Collectors.toSet()));
                Request compReq = new Request("GET", "_component_template");
                String componentTemplates = EntityUtils.toString((HttpEntity)ESRestTestCase.adminClient().performRequest(compReq).getEntity());
                Map cTemplates = XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)componentTemplates, (boolean)false);
                unexpectedTemplates.addAll(((List)cTemplates.get("component_templates")).stream().map(ct -> (String)((Map)ct).get("name")).filter(name -> !ESRestTestCase.isXPackTemplate(name)).collect(Collectors.toList()));
            }
            Request getLegacyTemplatesRequest = new Request("GET", "_template");
            Map legacyTemplates = XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)EntityUtils.toString((HttpEntity)ESRestTestCase.adminClient().performRequest(getLegacyTemplatesRequest).getEntity()), (boolean)false);
            unexpectedTemplates.addAll(legacyTemplates.keySet().stream().filter(template -> !ESRestTestCase.isXPackTemplate(template)).collect(Collectors.toSet()));
        }
        return unexpectedTemplates;
    }

    protected void deleteAllNodeShutdownMetadata() throws IOException {
        if (!hasShutdown.booleanValue() || ESRestTestCase.minimumNodeVersion().before(Version.V_7_15_0)) {
            return;
        }
        Request getShutdownStatus = new Request("GET", "_nodes/shutdown");
        Map<String, Object> statusResponse = ESRestTestCase.responseAsMap(ESRestTestCase.adminClient().performRequest(getShutdownStatus));
        List nodesArray = (List)statusResponse.get("nodes");
        List<String> nodeIds = nodesArray.stream().map(nodeShutdownMetadata -> (String)nodeShutdownMetadata.get("node_id")).toList();
        for (String nodeId : nodeIds) {
            Request deleteRequest = new Request("DELETE", "_nodes/" + nodeId + "/shutdown");
            ESRestTestCase.assertOK(ESRestTestCase.adminClient().performRequest(deleteRequest));
        }
    }

    protected static void wipeAllIndices() throws IOException {
        ESRestTestCase.wipeAllIndices(false);
    }

    protected static void wipeAllIndices(boolean preserveSecurityIndices) throws IOException {
        block9: {
            boolean includeHidden = ESRestTestCase.minimumNodeVersion().onOrAfter(Version.V_7_7_0);
            try {
                ArrayList<String> indexPatterns = new ArrayList<String>(List.of("*", "-.ds-ilm-history-*"));
                if (preserveSecurityIndices) {
                    indexPatterns.add("-.security-*");
                }
                Request deleteRequest = new Request("DELETE", org.elasticsearch.common.Strings.collectionToCommaDelimitedString(indexPatterns));
                deleteRequest.addParameter("expand_wildcards", "open,closed" + (includeHidden ? ",hidden" : ""));
                Response response = ESRestTestCase.adminClient().performRequest(deleteRequest);
                try (InputStream is = response.getEntity().getContent();){
                    ESRestTestCase.assertTrue((boolean)((Boolean)XContentHelper.convertToMap((XContent)XContentType.JSON.xContent(), (InputStream)is, (boolean)true).get("acknowledged")));
                }
            }
            catch (ResponseException e) {
                if (e.getResponse().getStatusLine().getStatusCode() == 404) break block9;
                throw e;
            }
        }
    }

    protected static void wipeDataStreams() throws IOException {
        block6: {
            try {
                if (ESRestTestCase.hasXPack()) {
                    ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_data_stream/*?expand_wildcards=all"));
                }
            }
            catch (ResponseException e) {
                try {
                    if (ESRestTestCase.hasXPack()) {
                        ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_data_stream/*"));
                    }
                }
                catch (ResponseException ee) {
                    int statusCode = ee.getResponse().getStatusLine().getStatusCode();
                    if (statusCode >= 404 && statusCode <= 405) break block6;
                    throw ee;
                }
            }
        }
    }

    protected void wipeSearchableSnapshotsIndices() throws IOException {
        Request request = new Request("GET", "_cluster/state/metadata");
        request.addParameter("filter_path", "metadata.indices.*.settings.index.store.snapshot");
        Response response = ESRestTestCase.adminClient().performRequest(request);
        Map indices = (Map)XContentMapValues.extractValue((String)"metadata.indices", ESRestTestCase.entityAsMap(response));
        if (indices != null) {
            for (String index : indices.keySet()) {
                try {
                    ESRestTestCase.assertAcked("Failed to delete searchable snapshot index [" + index + "]", ESRestTestCase.adminClient().performRequest(new Request("DELETE", index)));
                }
                catch (ResponseException e) {
                    if (ESRestTestCase.isNotFoundResponseException((IOException)((Object)e))) continue;
                    throw e;
                }
            }
        }
    }

    protected void wipeSnapshots() throws IOException {
        for (Map.Entry<String, Object> repo : ESRestTestCase.entityAsMap(adminClient.performRequest(new Request("GET", "/_snapshot/_all"))).entrySet()) {
            String repoName = repo.getKey();
            Map repoSpec = (Map)repo.getValue();
            String repoType = (String)repoSpec.get("type");
            if (!this.preserveSnapshotsUponCompletion() && repoType.equals("fs")) {
                ESRestTestCase.adminClient().performRequest(new Request("DELETE", "/_snapshot/" + repoName + "/*"));
            }
            if (this.preserveReposUponCompletion()) continue;
            this.deleteRepository(repoName);
        }
    }

    protected void deleteRepository(String repoName) throws IOException {
        this.logger.debug("wiping snapshot repository [{}]", (Object)repoName);
        ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_snapshot/" + repoName));
    }

    private void wipeClusterSettings() throws IOException {
        Map<String, Object> getResponse = ESRestTestCase.entityAsMap(ESRestTestCase.adminClient().performRequest(new Request("GET", "/_cluster/settings")));
        boolean mustClear = false;
        XContentBuilder clearCommand = JsonXContent.contentBuilder();
        clearCommand.startObject();
        for (Map.Entry<String, Object> entry : getResponse.entrySet()) {
            String type = entry.getKey().toString();
            Map settings = (Map)entry.getValue();
            if (settings.isEmpty()) continue;
            mustClear = true;
            clearCommand.startObject(type);
            for (Object key : settings.keySet()) {
                clearCommand.field(key + ".*").nullValue();
            }
            clearCommand.endObject();
        }
        clearCommand.endObject();
        if (mustClear) {
            Request request = new Request("PUT", "/_cluster/settings");
            request.setOptions(RequestOptions.DEFAULT.toBuilder().setWarningsHandler(warnings -> {
                if (warnings.isEmpty()) {
                    return false;
                }
                if (warnings.size() > 1) {
                    return true;
                }
                return !((String)warnings.get(0)).contains("xpack.monitoring");
            }));
            request.setJsonEntity(org.elasticsearch.common.Strings.toString((XContentBuilder)clearCommand));
            ESRestTestCase.adminClient().performRequest(request);
        }
    }

    private void wipeRollupJobs() throws IOException {
        Request request;
        String jobId;
        Response response;
        try {
            response = ESRestTestCase.adminClient().performRequest(new Request("GET", "/_rollup/job/_all"));
        }
        catch (ResponseException e) {
            if (e.getResponse().getStatusLine().getStatusCode() == RestStatus.NOT_FOUND.getStatus()) {
                return;
            }
            throw e;
        }
        Map<String, Object> jobs = ESRestTestCase.entityAsMap(response);
        List jobConfigs = (List)XContentMapValues.extractValue((String)"jobs", jobs);
        if (jobConfigs == null) {
            return;
        }
        for (Map jobConfig : jobConfigs) {
            jobId = (String)((Map)jobConfig.get("config")).get("id");
            request = new Request("POST", "/_rollup/job/" + jobId + "/_stop");
            request.addParameter("ignore", "404");
            request.addParameter("wait_for_completion", "true");
            request.addParameter("timeout", "10s");
            this.logger.debug("stopping rollup job [{}]", (Object)jobId);
            ESRestTestCase.adminClient().performRequest(request);
        }
        for (Map jobConfig : jobConfigs) {
            jobId = (String)((Map)jobConfig.get("config")).get("id");
            request = new Request("DELETE", "/_rollup/job/" + jobId);
            request.addParameter("ignore", "404");
            this.logger.debug("deleting rollup job [{}]", (Object)jobId);
            ESRestTestCase.adminClient().performRequest(request);
        }
    }

    protected void refreshAllIndices() throws IOException {
        boolean includeHidden = ESRestTestCase.minimumNodeVersion().onOrAfter(Version.V_7_7_0);
        Request refreshRequest = new Request("POST", "/_refresh");
        refreshRequest.addParameter("expand_wildcards", "open" + (includeHidden ? ",hidden" : ""));
        refreshRequest.setOptions(RequestOptions.DEFAULT.toBuilder().setWarningsHandler(warnings -> {
            if (warnings.isEmpty()) {
                return false;
            }
            if (warnings.size() > 1) {
                return true;
            }
            return !((String)warnings.get(0)).startsWith("this request accesses system indices:");
        }));
        ESRestTestCase.client().performRequest(refreshRequest);
    }

    protected static RefreshResponse refresh(String index) throws IOException {
        return ESRestTestCase.refresh(ESRestTestCase.client(), index);
    }

    protected static RefreshResponse refresh(RestClient client, String index) throws IOException {
        Request refreshRequest = new Request("POST", "/" + index + "/_refresh");
        Response response = client.performRequest(refreshRequest);
        return RefreshResponse.fromXContent((XContentParser)ESRestTestCase.responseAsParser(response));
    }

    private void waitForPendingRollupTasks() throws Exception {
        ESRestTestCase.waitForPendingTasks(ESRestTestCase.adminClient(), taskName -> !taskName.startsWith("xpack/rollup/job"));
    }

    private static void deleteAllILMPolicies(Set<String> exclusions) throws IOException {
        Map<String, Object> policies;
        try {
            Response response = ESRestTestCase.adminClient().performRequest(new Request("GET", "/_ilm/policy"));
            policies = ESRestTestCase.entityAsMap(response);
        }
        catch (ResponseException e) {
            if (RestStatus.METHOD_NOT_ALLOWED.getStatus() == e.getResponse().getStatusLine().getStatusCode() || RestStatus.BAD_REQUEST.getStatus() == e.getResponse().getStatusLine().getStatusCode()) {
                return;
            }
            throw e;
        }
        if (policies == null || policies.isEmpty()) {
            return;
        }
        policies.keySet().stream().filter(p -> !exclusions.contains(p)).forEach(policyName -> {
            try {
                ESRestTestCase.adminClient().performRequest(new Request("DELETE", "/_ilm/policy/" + policyName));
            }
            catch (IOException e) {
                throw new RuntimeException("failed to delete policy: " + policyName, e);
            }
        });
    }

    private static void deleteAllSLMPolicies() throws IOException {
        Map<String, Object> policies;
        try {
            Response response = ESRestTestCase.adminClient().performRequest(new Request("GET", "/_slm/policy"));
            policies = ESRestTestCase.entityAsMap(response);
        }
        catch (ResponseException e) {
            if (RestStatus.METHOD_NOT_ALLOWED.getStatus() == e.getResponse().getStatusLine().getStatusCode() || RestStatus.BAD_REQUEST.getStatus() == e.getResponse().getStatusLine().getStatusCode()) {
                return;
            }
            throw e;
        }
        if (policies == null || policies.isEmpty()) {
            return;
        }
        for (String policyName : policies.keySet()) {
            ESRestTestCase.adminClient().performRequest(new Request("DELETE", "/_slm/policy/" + policyName));
        }
    }

    private static void deleteAllAutoFollowPatterns() throws IOException {
        List patterns;
        try {
            Response response = ESRestTestCase.adminClient().performRequest(new Request("GET", "/_ccr/auto_follow"));
            patterns = (List)ESRestTestCase.entityAsMap(response).get("patterns");
        }
        catch (ResponseException e) {
            if (RestStatus.METHOD_NOT_ALLOWED.getStatus() == e.getResponse().getStatusLine().getStatusCode() || RestStatus.BAD_REQUEST.getStatus() == e.getResponse().getStatusLine().getStatusCode()) {
                return;
            }
            throw e;
        }
        if (patterns == null || patterns.isEmpty()) {
            return;
        }
        for (Map pattern : patterns) {
            String patternName = (String)pattern.get("name");
            ESRestTestCase.adminClient().performRequest(new Request("DELETE", "/_ccr/auto_follow/" + patternName));
        }
    }

    private void logIfThereAreRunningTasks() throws IOException {
        Set<String> runningTasks = this.runningTasks(ESRestTestCase.adminClient().performRequest(new Request("GET", "/_tasks")));
        runningTasks.remove("cluster:monitor/tasks/lists");
        runningTasks.remove("cluster:monitor/tasks/lists[n]");
        if (runningTasks.isEmpty()) {
            return;
        }
        ArrayList<String> stillRunning = new ArrayList<String>(runningTasks);
        Collections.sort(stillRunning);
        this.logger.info("There are still tasks running after this test that might break subsequent tests {}.", stillRunning);
    }

    private void waitForClusterStateUpdatesToFinish() throws Exception {
        ESRestTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            try {
                Response response = ESRestTestCase.adminClient().performRequest(new Request("GET", "/_cluster/pending_tasks"));
                List tasks = (List)ESRestTestCase.entityAsMap(response).get("tasks");
                if (!tasks.isEmpty()) {
                    StringBuilder message = new StringBuilder("there are still running tasks:");
                    for (Object task : tasks) {
                        message.append('\n').append(task.toString());
                    }
                    ESRestTestCase.fail((String)message.toString());
                }
            }
            catch (IOException e) {
                ESRestTestCase.fail((String)("cannot get cluster's pending tasks: " + e.getMessage()));
            }
        }), 30L, TimeUnit.SECONDS);
    }

    protected Settings restClientSettings() {
        Settings.Builder builder = Settings.builder();
        if (System.getProperty("tests.rest.client_path_prefix") != null) {
            builder.put(CLIENT_PATH_PREFIX, System.getProperty("tests.rest.client_path_prefix"));
        }
        return builder.build();
    }

    protected Settings restAdminSettings() {
        return this.restClientSettings();
    }

    protected final List<HttpHost> getClusterHosts() {
        return clusterHosts;
    }

    protected String getProtocol() {
        return "http";
    }

    protected RestClient buildClient(Settings settings, HttpHost[] hosts) throws IOException {
        RestClientBuilder builder = RestClient.builder((HttpHost[])hosts);
        ESRestTestCase.configureClient(builder, settings);
        builder.setStrictDeprecationMode(true);
        return builder.build();
    }

    protected static void configureClient(RestClientBuilder builder, Settings settings) throws IOException {
        SSLIOSessionStrategy sessionStrategy;
        SSLContext sslcontext;
        String truststorePath = settings.get(TRUSTSTORE_PATH);
        String certificateAuthorities = settings.get(CERTIFICATE_AUTHORITIES);
        String clientCertificatePath = settings.get(CLIENT_CERT_PATH);
        if (certificateAuthorities != null && truststorePath != null) {
            throw new IllegalStateException("Cannot set both certificate_authorities and truststore.path. Please configure one of these.");
        }
        if (truststorePath != null) {
            if (ESRestTestCase.inFipsJvm()) {
                throw new IllegalStateException("Keystore " + truststorePath + "cannot be used in FIPS 140 mode. Please configure certificate_authorities with a PEM encoded trusted CA/certificate instead");
            }
            String keystorePass = settings.get(TRUSTSTORE_PASSWORD);
            if (keystorePass == null) {
                throw new IllegalStateException("truststore.path is provided but not truststore.password");
            }
            Path path = PathUtils.get((String)truststorePath, (String[])new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                throw new IllegalStateException("truststore.path is set but points to a non-existing file");
            }
            try {
                String keyStoreType = truststorePath.endsWith(".p12") ? "PKCS12" : "jks";
                KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                    keyStore.load(is, keystorePass.toCharArray());
                }
                sslcontext = SSLContexts.custom().loadTrustMaterial(keyStore, null).build();
                sessionStrategy = new SSLIOSessionStrategy(sslcontext);
                builder.setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setSSLStrategy((SchemeIOSessionStrategy)sessionStrategy));
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new RuntimeException("Error setting up ssl", e);
            }
        }
        if (certificateAuthorities != null) {
            Path caPath = PathUtils.get((String)certificateAuthorities, (String[])new String[0]);
            if (!Files.exists(caPath, new LinkOption[0])) {
                throw new IllegalStateException("certificate_authorities is set but points to a non-existing file");
            }
            try {
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(null, null);
                Certificate caCert = (Certificate)PemUtils.readCertificates(List.of(caPath)).get(0);
                keyStore.setCertificateEntry(caCert.toString(), caCert);
                SSLContextBuilder sslContextBuilder = SSLContexts.custom();
                if (clientCertificatePath != null) {
                    Path certPath = PathUtils.get((String)clientCertificatePath, (String[])new String[0]);
                    Path keyPath = PathUtils.get((String)Objects.requireNonNull(settings.get(CLIENT_KEY_PATH), "No key provided"), (String[])new String[0]);
                    String password = settings.get(CLIENT_KEY_PASSWORD);
                    char[] passwordChars = password == null ? null : password.toCharArray();
                    PrivateKey key = PemUtils.readPrivateKey((Path)keyPath, () -> passwordChars);
                    Certificate[] clientCertChain = (Certificate[])PemUtils.readCertificates(List.of(certPath)).toArray(Certificate[]::new);
                    keyStore.setKeyEntry("client", key, passwordChars, clientCertChain);
                    sslContextBuilder.loadKeyMaterial(keyStore, passwordChars);
                }
                sslcontext = sslContextBuilder.loadTrustMaterial(keyStore, null).build();
                sessionStrategy = new SSLIOSessionStrategy(sslcontext);
                builder.setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setSSLStrategy((SchemeIOSessionStrategy)sessionStrategy));
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException("Error setting up ssl", e);
            }
        } else if (clientCertificatePath != null) {
            throw new IllegalStateException("Client certificates are currently only supported when using a custom CA");
        }
        Map headers = ThreadContext.buildDefaultHeaders((Settings)settings);
        Header[] defaultHeaders = new Header[headers.size()];
        int i = 0;
        for (Map.Entry entry : headers.entrySet()) {
            defaultHeaders[i++] = new BasicHeader((String)entry.getKey(), (String)entry.getValue());
        }
        builder.setDefaultHeaders(defaultHeaders);
        String socketTimeoutString = Objects.requireNonNullElse(settings.get(CLIENT_SOCKET_TIMEOUT), "60s");
        TimeValue socketTimeout = TimeValue.parseTimeValue((String)socketTimeoutString, (String)CLIENT_SOCKET_TIMEOUT);
        builder.setRequestConfigCallback(conf -> conf.setSocketTimeout(Math.toIntExact(socketTimeout.getMillis())));
        if (settings.hasValue(CLIENT_PATH_PREFIX)) {
            builder.setPathPrefix(settings.get(CLIENT_PATH_PREFIX));
        }
    }

    private Set<String> runningTasks(Response response) throws IOException {
        HashSet<String> runningTasks = new HashSet<String>();
        Map nodes = (Map)ESRestTestCase.entityAsMap(response).get("nodes");
        for (Map.Entry node : nodes.entrySet()) {
            Map nodeInfo = (Map)node.getValue();
            Map nodeTasks = (Map)nodeInfo.get("tasks");
            for (Map.Entry taskAndName : nodeTasks.entrySet()) {
                Map task = (Map)taskAndName.getValue();
                runningTasks.add(task.get("action").toString());
            }
        }
        return runningTasks;
    }

    public static void assertOK(Response response) {
        ESRestTestCase.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)200), (Matcher)Matchers.equalTo((Object)201)));
    }

    public static ObjectPath assertOKAndCreateObjectPath(Response response) throws IOException {
        ESRestTestCase.assertOK(response);
        return ObjectPath.createFromResponse(response);
    }

    public static void assertDocCount(RestClient client, String indexName, long docCount) throws IOException {
        Request countReq = new Request("GET", "/" + indexName + "/_count");
        ObjectPath resp = ObjectPath.createFromResponse(client.performRequest(countReq));
        ESRestTestCase.assertEquals((String)("expected " + docCount + " documents but it was a different number"), (long)docCount, (long)Long.parseLong(resp.evaluate("count").toString()));
    }

    public static void assertAcknowledged(Response response) throws IOException {
        ESRestTestCase.assertOK(response);
        String jsonBody = EntityUtils.toString((HttpEntity)response.getEntity());
        ESRestTestCase.assertThat((Object)jsonBody, (Matcher)Matchers.containsString((String)"\"acknowledged\":true"));
    }

    public static void updateClusterSettings(Settings settings) throws IOException {
        ESRestTestCase.updateClusterSettings(ESRestTestCase.client(), settings);
    }

    public static void updateClusterSettings(RestClient client, Settings settings) throws IOException {
        Request request = new Request("PUT", "/_cluster/settings");
        String entity = "{ \"persistent\":" + org.elasticsearch.common.Strings.toString((ToXContent)settings) + "}";
        request.setJsonEntity(entity);
        Response response = client.performRequest(request);
        ESRestTestCase.assertOK(response);
    }

    @Nullable
    protected String getEnsureGreenTimeout() {
        return null;
    }

    public final void ensureGreen(String index) throws IOException {
        ESRestTestCase.ensureHealth(index, (Request request) -> {
            request.addParameter("wait_for_status", "green");
            request.addParameter("wait_for_no_relocating_shards", "true");
            String ensureGreenTimeout = this.getEnsureGreenTimeout();
            if (ensureGreenTimeout != null) {
                request.addParameter("timeout", ensureGreenTimeout);
            }
            request.addParameter("level", "shards");
        });
    }

    protected static void ensureHealth(Consumer<Request> requestConsumer) throws IOException {
        ESRestTestCase.ensureHealth("", requestConsumer);
    }

    public static void ensureHealth(String index, Consumer<Request> requestConsumer) throws IOException {
        ESRestTestCase.ensureHealth(ESRestTestCase.client(), index, requestConsumer);
    }

    public static void ensureHealth(RestClient restClient, Consumer<Request> requestConsumer) throws IOException {
        ESRestTestCase.ensureHealth(restClient, "", requestConsumer);
    }

    protected static void ensureHealth(RestClient restClient, String index, Consumer<Request> requestConsumer) throws IOException {
        Request request = new Request("GET", "/_cluster/health" + (String)(index.isBlank() ? "" : "/" + index));
        requestConsumer.accept(request);
        try {
            restClient.performRequest(request);
        }
        catch (ResponseException e) {
            if (e.getResponse().getStatusLine().getStatusCode() == 408) {
                try {
                    Response clusterStateResponse = restClient.performRequest(new Request("GET", "/_cluster/state?pretty"));
                    ESRestTestCase.fail((String)("timed out waiting for green state for index [" + index + "] cluster state [" + EntityUtils.toString((HttpEntity)clusterStateResponse.getEntity()) + "]"));
                }
                catch (Exception inner) {
                    e.addSuppressed((Throwable)inner);
                }
            }
            throw e;
        }
    }

    protected static void ensureNoInitializingShards() throws IOException {
        Request request = new Request("GET", "/_cluster/health");
        request.addParameter("wait_for_no_initializing_shards", "true");
        request.addParameter("timeout", "70s");
        request.addParameter("level", "shards");
        ESRestTestCase.adminClient().performRequest(request);
    }

    protected static CreateIndexResponse createIndex(String name) throws IOException {
        return ESRestTestCase.createIndex(name, null, null, null);
    }

    protected static CreateIndexResponse createIndex(String name, Settings settings) throws IOException {
        return ESRestTestCase.createIndex(name, settings, null, null);
    }

    protected static CreateIndexResponse createIndex(RestClient client, String name, Settings settings) throws IOException {
        return ESRestTestCase.createIndex(client, name, settings, null, null);
    }

    protected static CreateIndexResponse createIndex(String name, Settings settings, String mapping) throws IOException {
        return ESRestTestCase.createIndex(name, settings, mapping, null);
    }

    protected static CreateIndexResponse createIndex(String name, Settings settings, String mapping, String aliases) throws IOException {
        return ESRestTestCase.createIndex(ESRestTestCase.client(), name, settings, mapping, aliases);
    }

    public static CreateIndexResponse createIndex(RestClient client, String name, Settings settings, String mapping, String aliases) throws IOException {
        Request request = new Request("PUT", "/" + name);
        Object entity = "{";
        if (settings != null) {
            entity = (String)entity + "\"settings\": " + org.elasticsearch.common.Strings.toString((ToXContent)settings);
            if (!settings.getAsBoolean(IndexSettings.INDEX_SOFT_DELETES_SETTING.getKey(), Boolean.valueOf(true)).booleanValue()) {
                ESRestTestCase.expectSoftDeletesWarning(request, name);
            }
        }
        if (mapping != null) {
            if (settings != null) {
                entity = (String)entity + ",";
            }
            entity = mapping.trim().startsWith("{") ? (String)entity + "\"mappings\" : " + mapping : (String)entity + "\"mappings\" : {" + mapping + "}";
        }
        if (aliases != null) {
            if (settings != null || mapping != null) {
                entity = (String)entity + ",";
            }
            entity = (String)entity + "\"aliases\": {" + aliases + "}";
        }
        entity = (String)entity + "}";
        request.setJsonEntity((String)entity);
        Response response = client.performRequest(request);
        return CreateIndexResponse.fromXContent((XContentParser)ESRestTestCase.responseAsParser(response));
    }

    protected static AcknowledgedResponse deleteIndex(String name) throws IOException {
        return ESRestTestCase.deleteIndex(ESRestTestCase.client(), name);
    }

    protected static AcknowledgedResponse deleteIndex(RestClient restClient, String name) throws IOException {
        Request request = new Request("DELETE", "/" + name);
        Response response = restClient.performRequest(request);
        return AcknowledgedResponse.fromXContent((XContentParser)ESRestTestCase.responseAsParser(response));
    }

    protected static void updateIndexSettings(String index, Settings.Builder settings) throws IOException {
        ESRestTestCase.updateIndexSettings(index, settings.build());
    }

    private static void updateIndexSettings(String index, Settings settings) throws IOException {
        Request request = new Request("PUT", "/" + index + "/_settings");
        request.setJsonEntity(org.elasticsearch.common.Strings.toString((ToXContent)settings));
        ESRestTestCase.client().performRequest(request);
    }

    protected static void expectSoftDeletesWarning(Request request, String indexName) {
        List<CallSite> expectedWarnings = List.of("Creating indices with soft-deletes disabled is deprecated and will be removed in future Elasticsearch versions. Please do not specify value for setting [index.soft_deletes.enabled] of index [" + indexName + "].");
        if (nodeVersions.stream().allMatch(version -> version.onOrAfter(Version.V_7_6_0))) {
            request.setOptions(RequestOptions.DEFAULT.toBuilder().setWarningsHandler(warnings -> !warnings.equals(expectedWarnings)));
        } else if (nodeVersions.stream().anyMatch(version -> version.onOrAfter(Version.V_7_6_0))) {
            request.setOptions(RequestOptions.DEFAULT.toBuilder().setWarningsHandler(warnings -> !warnings.isEmpty() && !warnings.equals(expectedWarnings)));
        }
    }

    protected static Map<String, Object> getIndexSettings(String index) throws IOException {
        Request request = new Request("GET", "/" + index + "/_settings");
        request.addParameter("flat_settings", "true");
        Response response = ESRestTestCase.client().performRequest(request);
        try (InputStream is = response.getEntity().getContent();){
            Map map = XContentHelper.convertToMap((XContent)XContentType.JSON.xContent(), (InputStream)is, (boolean)true);
            return map;
        }
    }

    protected Map<String, Object> getIndexSettingsAsMap(String index) throws IOException {
        Map<String, Object> indexSettings = ESRestTestCase.getIndexSettings(index);
        return (Map)((Map)indexSettings.get(index)).get("settings");
    }

    protected static Map<String, Object> getIndexMapping(String index) throws IOException {
        return ESRestTestCase.entityAsMap(ESRestTestCase.client().performRequest(new Request("GET", "/" + index + "/_mapping")));
    }

    protected Map<String, Object> getIndexMappingAsMap(String index) throws IOException {
        Map<String, Object> indexSettings = ESRestTestCase.getIndexMapping(index);
        return (Map)((Map)indexSettings.get(index)).get("mappings");
    }

    protected static boolean indexExists(String index) throws IOException {
        Response response = ESRestTestCase.client().performRequest(new Request("HEAD", "/" + index));
        return RestStatus.OK.getStatus() == response.getStatusLine().getStatusCode();
    }

    protected static void closeIndex(String index) throws IOException {
        Request closeRequest = new Request("POST", "/" + index + "/_close");
        closeRequest.setOptions(ESRestTestCase.expectVersionSpecificWarnings(v -> v.compatible(WAIT_FOR_ACTIVE_SHARDS_DEFAULT_DEPRECATION_MESSAGE)));
        ESRestTestCase.assertOK(ESRestTestCase.client().performRequest(closeRequest));
    }

    protected static void openIndex(String index) throws IOException {
        Response response = ESRestTestCase.client().performRequest(new Request("POST", "/" + index + "/_open"));
        ESRestTestCase.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.equalTo((Object)RestStatus.OK.getStatus()));
    }

    protected static boolean aliasExists(String alias) throws IOException {
        Response response = ESRestTestCase.client().performRequest(new Request("HEAD", "/_alias/" + alias));
        return RestStatus.OK.getStatus() == response.getStatusLine().getStatusCode();
    }

    protected static boolean aliasExists(String index, String alias) throws IOException {
        Response response = ESRestTestCase.client().performRequest(new Request("HEAD", "/" + index + "/_alias/" + alias));
        return RestStatus.OK.getStatus() == response.getStatusLine().getStatusCode();
    }

    protected static Map<String, Object> getAlias(String index, String alias) throws IOException {
        Object endpoint = "/_alias";
        if (!org.elasticsearch.common.Strings.isEmpty((CharSequence)index)) {
            endpoint = index + (String)endpoint;
        }
        if (!org.elasticsearch.common.Strings.isEmpty((CharSequence)alias)) {
            endpoint = (String)endpoint + "/" + alias;
        }
        Map<String, Object> getAliasResponse = ESRestTestCase.getAsMap((String)endpoint);
        return (Map)XContentMapValues.extractValue((String)(index + ".aliases." + alias), getAliasResponse);
    }

    protected static Map<String, Object> getAsMap(String endpoint) throws IOException {
        return ESRestTestCase.getAsMap(ESRestTestCase.client(), endpoint);
    }

    protected static Map<String, Object> getAsMap(RestClient client, String endpoint) throws IOException {
        Response response = client.performRequest(new Request("GET", endpoint));
        return ESRestTestCase.responseAsMap(response);
    }

    protected static Map<String, Object> responseAsMap(Response response) throws IOException {
        XContentType entityContentType = XContentType.fromMediaType((String)response.getEntity().getContentType().getValue());
        Map responseEntity = XContentHelper.convertToMap((XContent)entityContentType.xContent(), (InputStream)response.getEntity().getContent(), (boolean)false);
        ESRestTestCase.assertNotNull((Object)responseEntity);
        return responseEntity;
    }

    protected static XContentParser responseAsParser(Response response) throws IOException {
        return XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)ESRestTestCase.responseAsBytes(response), (XContentType)XContentType.JSON);
    }

    protected static BytesReference responseAsBytes(Response response) throws IOException {
        return new BytesArray(EntityUtils.toByteArray((HttpEntity)response.getEntity()));
    }

    protected static void registerRepository(String repository, String type, boolean verify, Settings settings) throws IOException {
        ESRestTestCase.registerRepository(ESRestTestCase.client(), repository, type, verify, settings);
    }

    protected static void registerRepository(RestClient restClient, String repository, String type, boolean verify, Settings settings) throws IOException {
        Request request = new Request("PUT", "_snapshot/" + repository);
        request.addParameter("verify", Boolean.toString(verify));
        request.setJsonEntity(org.elasticsearch.common.Strings.toString((ToXContent)new PutRepositoryRequest(repository).type(type).settings(settings)));
        Response response = restClient.performRequest(request);
        ESRestTestCase.assertAcked("Failed to create repository [" + repository + "] of type [" + type + "]: " + response, response);
    }

    protected static void createSnapshot(String repository, String snapshot, boolean waitForCompletion) throws IOException {
        ESRestTestCase.createSnapshot(ESRestTestCase.client(), repository, snapshot, waitForCompletion);
    }

    protected static void createSnapshot(RestClient restClient, String repository, String snapshot, boolean waitForCompletion) throws IOException {
        Request request = new Request("PUT", "_snapshot/" + repository + "/" + snapshot);
        request.addParameter("wait_for_completion", Boolean.toString(waitForCompletion));
        Response response = restClient.performRequest(request);
        ESRestTestCase.assertThat((String)("Failed to create snapshot [" + snapshot + "] in repository [" + repository + "]: " + response), (Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.equalTo((Object)RestStatus.OK.getStatus()));
    }

    protected static void restoreSnapshot(String repository, String snapshot, boolean waitForCompletion) throws IOException {
        Request request = new Request("POST", "_snapshot/" + repository + "/" + snapshot + "/_restore");
        request.addParameter("wait_for_completion", Boolean.toString(waitForCompletion));
        Response response = ESRestTestCase.client().performRequest(request);
        ESRestTestCase.assertThat((String)("Failed to restore snapshot [" + snapshot + "] from repository [" + repository + "]: " + response), (Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.equalTo((Object)RestStatus.OK.getStatus()));
    }

    protected static void deleteSnapshot(String repository, String snapshot, boolean ignoreMissing) throws IOException {
        ESRestTestCase.deleteSnapshot(ESRestTestCase.client(), repository, snapshot, ignoreMissing);
    }

    protected static void deleteSnapshot(RestClient restClient, String repository, String snapshot, boolean ignoreMissing) throws IOException {
        Request request = new Request("DELETE", "_snapshot/" + repository + "/" + snapshot);
        if (ignoreMissing) {
            request.addParameter("ignore", "404");
        }
        Response response = restClient.performRequest(request);
        ESRestTestCase.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)(ignoreMissing ? Matchers.anyOf((Matcher)Matchers.equalTo((Object)200), (Matcher)Matchers.equalTo((Object)404)) : Matchers.equalTo((Object)200)));
    }

    private static void assertAcked(String message, Response response) throws IOException {
        int responseStatusCode = response.getStatusLine().getStatusCode();
        ESRestTestCase.assertThat((String)(message + ": expecting response code [200] but got [" + responseStatusCode + "]"), (Object)responseStatusCode, (Matcher)Matchers.equalTo((Object)RestStatus.OK.getStatus()));
        Map<String, Object> responseAsMap = ESRestTestCase.responseAsMap(response);
        Boolean acknowledged = (Boolean)XContentMapValues.extractValue(responseAsMap, (String[])new String[]{"acknowledged"});
        ESRestTestCase.assertThat((String)(message + ": response is not acknowledged"), (Object)acknowledged, (Matcher)Matchers.equalTo((Object)Boolean.TRUE));
    }

    protected static boolean isXPackTemplate(String name) {
        if (name.startsWith(".monitoring-")) {
            return true;
        }
        if (name.startsWith(".watch") || name.startsWith(".triggered_watches")) {
            return true;
        }
        if (name.startsWith(".data-frame-")) {
            return true;
        }
        if (name.startsWith(".ml-")) {
            return true;
        }
        if (name.startsWith(".transform-")) {
            return true;
        }
        if (name.startsWith(".deprecation-")) {
            return true;
        }
        if (name.startsWith(".fleet-")) {
            return true;
        }
        if (name.startsWith("behavioral_analytics-")) {
            return true;
        }
        switch (name) {
            case ".watches": 
            case "security_audit_log": 
            case ".slm-history": 
            case ".async-search": 
            case "saml-service-provider": 
            case "logs": 
            case "logs-settings": 
            case "logs-mappings": 
            case "metrics": 
            case "metrics-settings": 
            case "metrics-mappings": 
            case "synthetics": 
            case "synthetics-settings": 
            case "synthetics-mappings": 
            case ".snapshot-blob-cache": 
            case "ilm-history": 
            case "logstash-index-template": 
            case "security-index-template": 
            case "data-streams-mappings": {
                return true;
            }
        }
        return false;
    }

    public void flush(String index, boolean force) throws IOException {
        this.logger.info("flushing index {} force={}", (Object)index, (Object)force);
        Request flushRequest = new Request("POST", "/" + index + "/_flush");
        flushRequest.addParameter("force", Boolean.toString(force));
        flushRequest.addParameter("wait_if_ongoing", "true");
        ESRestTestCase.assertOK(ESRestTestCase.client().performRequest(flushRequest));
    }

    public void assertNoFileBasedRecovery(String indexName, Predicate<String> targetNode) throws IOException {
        Map<String, Object> recoveries = ESRestTestCase.entityAsMap(ESRestTestCase.client().performRequest(new Request("GET", indexName + "/_recovery?detailed=true")));
        List shards = (List)XContentMapValues.extractValue((String)(indexName + ".shards"), recoveries);
        ESRestTestCase.assertNotNull((Object)shards);
        boolean foundReplica = false;
        this.logger.info("index {} recovery stats {}", (Object)indexName, (Object)shards);
        for (Map shard : shards) {
            if (shard.get("primary") != Boolean.FALSE || !targetNode.test((String)XContentMapValues.extractValue((String)"target.name", (Map)shard))) continue;
            List details = (List)XContentMapValues.extractValue((String)"index.files.details", (Map)shard);
            if (details == null) {
                long totalFiles = ((Number)XContentMapValues.extractValue((String)"index.files.total", (Map)shard)).longValue();
                long reusedFiles = ((Number)XContentMapValues.extractValue((String)"index.files.reused", (Map)shard)).longValue();
                this.logger.info("total [{}] reused [{}]", (Object)totalFiles, (Object)reusedFiles);
                ESRestTestCase.assertThat((String)("must reuse all files, recoveries [" + recoveries + "]"), (Object)totalFiles, (Matcher)Matchers.equalTo((Object)reusedFiles));
            } else {
                ESRestTestCase.assertNotNull((Object)details);
                ESRestTestCase.assertThat((Object)details, (Matcher)Matchers.empty());
            }
            foundReplica = true;
        }
        ESRestTestCase.assertTrue((String)"must find replica", (boolean)foundReplica);
    }

    public void assertEmptyTranslog(String index) throws Exception {
        Map<String, Object> stats = ESRestTestCase.entityAsMap(ESRestTestCase.client().performRequest(new Request("GET", index + "/_stats?level=shards")));
        ESRestTestCase.assertThat((Object)XContentMapValues.extractValue((String)("indices." + index + ".total.translog.uncommitted_operations"), stats), (Matcher)Matchers.equalTo((Object)0));
        ESRestTestCase.assertThat((Object)XContentMapValues.extractValue((String)("indices." + index + ".total.translog.operations"), stats), (Matcher)Matchers.equalTo((Object)0));
    }

    public void ensurePeerRecoveryRetentionLeasesRenewedAndSynced(String index) throws Exception {
        boolean mustHavePRRLs = ESRestTestCase.minimumNodeVersion().onOrAfter(Version.V_7_6_0);
        ESRestTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            Map<String, Object> stats = ESRestTestCase.entityAsMap(ESRestTestCase.client().performRequest(new Request("GET", index + "/_stats?level=shards")));
            Map shards = (Map)XContentMapValues.extractValue((String)("indices." + index + ".shards"), stats);
            for (List shard : shards.values()) {
                for (Map copy : shard) {
                    Integer globalCheckpoint = (Integer)XContentMapValues.extractValue((String)"seq_no.global_checkpoint", (Map)copy);
                    ESRestTestCase.assertThat((Object)XContentMapValues.extractValue((String)"seq_no.max_seq_no", (Map)copy), (Matcher)Matchers.equalTo((Object)globalCheckpoint));
                    ESRestTestCase.assertNotNull((Object)globalCheckpoint);
                    List retentionLeases = (List)XContentMapValues.extractValue((String)"retention_leases.leases", (Map)copy);
                    if (!mustHavePRRLs && retentionLeases == null) continue;
                    ESRestTestCase.assertNotNull((Object)retentionLeases);
                    for (Map retentionLease : retentionLeases) {
                        if (!((String)retentionLease.get("id")).startsWith("peer_recovery/")) continue;
                        ESRestTestCase.assertThat(retentionLease.get("retaining_seq_no"), (Matcher)Matchers.equalTo((Object)(globalCheckpoint + 1)));
                    }
                    if (!mustHavePRRLs) continue;
                    List existingLeaseIds = retentionLeases.stream().map(lease -> (String)lease.get("id")).collect(Collectors.toList());
                    List expectedLeaseIds = shard.stream().map(shr -> (String)XContentMapValues.extractValue((String)"routing.node", (Map)shr)).map(ReplicationTracker::getPeerRecoveryRetentionLeaseId).collect(Collectors.toList());
                    ESRestTestCase.assertThat((String)"not every active copy has established its PPRL", expectedLeaseIds, (Matcher)Matchers.everyItem((Matcher)Matchers.in(existingLeaseIds)));
                }
            }
        }), 60L, TimeUnit.SECONDS);
    }

    protected static Version minimumNodeVersion() throws IOException {
        Request request = new Request("GET", "_nodes");
        request.addParameter("filter_path", "nodes.*.version");
        Response response = ESRestTestCase.adminClient().performRequest(request);
        Map nodes = (Map)ObjectPath.createFromResponse(response).evaluate("nodes");
        Version minVersion = null;
        for (Map.Entry node : nodes.entrySet()) {
            Version nodeVersion = Version.fromString((String)((String)((Map)node.getValue()).get("version")));
            if (minVersion != null && !minVersion.after(nodeVersion)) continue;
            minVersion = nodeVersion;
        }
        ESRestTestCase.assertNotNull(minVersion);
        return minVersion;
    }

    private void ensureGlobalCheckpointSynced(String index) throws Exception {
        ESRestTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            Map<String, Object> stats = ESRestTestCase.entityAsMap(ESRestTestCase.client().performRequest(new Request("GET", index + "/_stats?level=shards")));
            List shardStats = (List)XContentMapValues.extractValue((String)("indices." + index + ".shards.0"), stats);
            shardStats.stream().map(shard -> (Map)XContentMapValues.extractValue((String)"seq_no", (Map)shard)).filter(Objects::nonNull).forEach(seqNoStat -> {
                long globalCheckpoint = ((Number)XContentMapValues.extractValue((String)"global_checkpoint", (Map)seqNoStat)).longValue();
                long localCheckpoint = ((Number)XContentMapValues.extractValue((String)"local_checkpoint", (Map)seqNoStat)).longValue();
                long maxSeqNo = ((Number)XContentMapValues.extractValue((String)"max_seq_no", (Map)seqNoStat)).longValue();
                ESRestTestCase.assertThat((String)shardStats.toString(), (Object)localCheckpoint, (Matcher)Matchers.equalTo((Object)maxSeqNo));
                ESRestTestCase.assertThat((String)shardStats.toString(), (Object)globalCheckpoint, (Matcher)Matchers.equalTo((Object)maxSeqNo));
            });
        }), 60L, TimeUnit.SECONDS);
    }

    protected static void waitForActiveLicense(RestClient restClient) throws Exception {
        ESRestTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            Request request = new Request("GET", "/_xpack");
            request.setOptions(RequestOptions.DEFAULT.toBuilder());
            Response response = restClient.performRequest(request);
            ESRestTestCase.assertOK(response);
            try (InputStream is = response.getEntity().getContent();){
                XContentType xContentType = XContentType.fromMediaType((String)response.getEntity().getContentType().getValue());
                Map map = XContentHelper.convertToMap((XContent)xContentType.xContent(), (InputStream)is, (boolean)true);
                ESRestTestCase.assertThat((Object)map, (Matcher)Matchers.notNullValue());
                ESRestTestCase.assertThat((String)"License must exist", (Object)map.containsKey("license"), (Matcher)Matchers.equalTo((Object)true));
                Map license = (Map)map.get("license");
                ESRestTestCase.assertThat((String)"Expecting non-null license", (Object)license, (Matcher)Matchers.notNullValue());
                ESRestTestCase.assertThat((String)"License status must exist", (Object)license.containsKey("status"), (Matcher)Matchers.equalTo((Object)true));
                String status = (String)license.get("status");
                ESRestTestCase.assertThat((String)"Expecting non-null license status", (Object)status, (Matcher)Matchers.notNullValue());
                ESRestTestCase.assertThat((String)"Expecting active license", (Object)status, (Matcher)Matchers.equalTo((Object)"active"));
            }
        }));
    }

    protected static void useIgnoreMultipleMatchingTemplatesWarningsHandler(Request request) throws IOException {
        RequestOptions.Builder options = request.getOptions().toBuilder();
        options.setWarningsHandler(warnings -> {
            if (warnings.size() > 0) {
                boolean matches = warnings.stream().anyMatch(message -> CREATE_INDEX_MULTIPLE_MATCHING_TEMPLATES.matcher((CharSequence)message).matches() || PUT_TEMPLATE_MULTIPLE_MATCHING_TEMPLATES.matcher((CharSequence)message).matches());
                return !matches;
            }
            return false;
        });
        request.setOptions(options);
    }

    protected static boolean isNotFoundResponseException(IOException ioe) {
        if (ioe instanceof ResponseException) {
            Response response = ((ResponseException)((Object)ioe)).getResponse();
            return response.getStatusLine().getStatusCode() == 404;
        }
        return false;
    }

    protected FieldCapabilitiesResponse fieldCaps(List<String> indices, List<String> fields, QueryBuilder indexFilter, String fieldTypes, String fieldFilters) throws IOException {
        return this.fieldCaps(ESRestTestCase.client(), indices, fields, indexFilter, fieldTypes, fieldFilters);
    }

    protected FieldCapabilitiesResponse fieldCaps(RestClient restClient, List<String> indices, List<String> fields, QueryBuilder indexFilter, String fieldTypes, String fieldFilters) throws IOException {
        Request request = new Request("POST", "/_field_caps");
        request.addParameter("index", String.join((CharSequence)",", indices));
        request.addParameter("fields", String.join((CharSequence)",", fields));
        if (fieldTypes != null) {
            request.addParameter("types", fieldTypes);
        }
        if (fieldFilters != null) {
            request.addParameter("filters", fieldFilters);
        }
        if (indexFilter != null) {
            XContentBuilder body = JsonXContent.contentBuilder();
            body.startObject();
            body.field("index_filter", (ToXContent)indexFilter);
            body.endObject();
            request.setJsonEntity(org.elasticsearch.common.Strings.toString((XContentBuilder)body));
        }
        Response response = restClient.performRequest(request);
        ESRestTestCase.assertOK(response);
        try (XContentParser parser = this.createParser(JsonXContent.jsonXContent, response.getEntity().getContent());){
            FieldCapabilitiesResponse fieldCapabilitiesResponse = FieldCapabilitiesResponse.fromXContent((XContentParser)parser);
            return fieldCapabilitiesResponse;
        }
    }

    private static boolean isMlEnabled() {
        try {
            ESRestTestCase.adminClient().performRequest(new Request("GET", "_ml/info"));
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    static {
        CREATE_INDEX_MULTIPLE_MATCHING_TEMPLATES = Pattern.compile("^index \\[(.+)\\] matches multiple legacy templates \\[(.+)\\], composable templates will only match a single template$");
        PUT_TEMPLATE_MULTIPLE_MATCHING_TEMPLATES = Pattern.compile("^index template \\[(.+)\\] has index patterns \\[(.+)\\] matching patterns from existing older templates \\[(.+)\\] with patterns \\((.+)\\); this template \\[(.+)\\] will take precedence during new index creation$");
    }

    public static class VersionSensitiveWarningsHandler
    implements WarningsHandler {
        Set<String> requiredSameVersionClusterWarnings = new HashSet<String>();
        Set<String> allowedWarnings = new HashSet<String>();
        final Set<Version> testNodeVersions;

        public VersionSensitiveWarningsHandler(Set<Version> nodeVersions) {
            this.testNodeVersions = nodeVersions;
        }

        public void current(String ... requiredWarnings) {
            this.requiredSameVersionClusterWarnings.addAll(Arrays.asList(requiredWarnings));
        }

        public void compatible(String ... allowedWarningsToAdd) {
            this.allowedWarnings.addAll(Arrays.asList(allowedWarningsToAdd));
        }

        public boolean warningsShouldFailRequest(List<String> warnings) {
            if (this.isExclusivelyTargetingCurrentVersionCluster()) {
                HashSet<String> actual = new HashSet<String>(warnings);
                return false == this.requiredSameVersionClusterWarnings.equals(actual);
            }
            for (String actualWarning : warnings) {
                if (this.allowedWarnings.contains(actualWarning) || this.requiredSameVersionClusterWarnings.contains(actualWarning)) continue;
                return true;
            }
            return false;
        }

        private boolean isExclusivelyTargetingCurrentVersionCluster() {
            Assert.assertFalse((String)"Node versions running in the cluster are missing", (boolean)this.testNodeVersions.isEmpty());
            return this.testNodeVersions.size() == 1 && this.testNodeVersions.iterator().next().equals((Object)Version.CURRENT);
        }
    }
}

