/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.transport;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import junit.framework.TestCase;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.io.stream.RecyclerBytesStreamOutput;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.MockPageCacheRecycler;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.BytesRefRecycler;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.RequestHandlerRegistry;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportMessageListener;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportStats;

public class StubbableTransport
implements Transport {
    private final ConcurrentHashMap<TransportAddress, SendRequestBehavior> sendBehaviors = new ConcurrentHashMap();
    private final ConcurrentHashMap<TransportAddress, OpenConnectionBehavior> connectBehaviors = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, RequestHandlerRegistry<?>> replacedRequestRegistries = new ConcurrentHashMap();
    private volatile SendRequestBehavior defaultSendRequest = null;
    private volatile OpenConnectionBehavior defaultConnectBehavior = null;
    private final Transport delegate;
    private final PageCacheRecycler recycler = new MockPageCacheRecycler(Settings.EMPTY);

    public StubbableTransport(Transport transport) {
        this.delegate = transport;
    }

    boolean setDefaultSendBehavior(SendRequestBehavior sendBehavior) {
        SendRequestBehavior prior = this.defaultSendRequest;
        this.defaultSendRequest = sendBehavior;
        return prior == null;
    }

    public boolean setDefaultConnectBehavior(OpenConnectionBehavior openConnectionBehavior) {
        OpenConnectionBehavior prior = this.defaultConnectBehavior;
        this.defaultConnectBehavior = openConnectionBehavior;
        return prior == null;
    }

    boolean addSendBehavior(TransportAddress transportAddress, SendRequestBehavior sendBehavior) {
        return this.sendBehaviors.put(transportAddress, sendBehavior) == null;
    }

    boolean addConnectBehavior(TransportAddress transportAddress, OpenConnectionBehavior connectBehavior) {
        return this.connectBehaviors.put(transportAddress, connectBehavior) == null;
    }

    <Request extends TransportRequest> void addRequestHandlingBehavior(String actionName, RequestHandlingBehavior<Request> behavior) {
        Transport.RequestHandlers requestHandlers = this.delegate.getRequestHandlers();
        RequestHandlerRegistry realRegistry = requestHandlers.getHandler(actionName);
        if (realRegistry == null) {
            throw new IllegalStateException("Cannot find registered action for: " + actionName);
        }
        this.replacedRequestRegistries.put(actionName, realRegistry);
        TransportRequestHandler realHandler = realRegistry.getHandler();
        RequestHandlerRegistry newRegistry = RequestHandlerRegistry.replaceHandler((RequestHandlerRegistry)realRegistry, (request, channel, task) -> behavior.messageReceived(realHandler, request, channel, task));
        requestHandlers.forceRegister(newRegistry);
    }

    void clearBehaviors() {
        this.clearOutboundBehaviors();
        this.clearInboundBehaviors();
    }

    void clearInboundBehaviors() {
        for (Map.Entry<String, RequestHandlerRegistry<?>> entry : this.replacedRequestRegistries.entrySet()) {
            this.getRequestHandlers().forceRegister(entry.getValue());
        }
        this.replacedRequestRegistries.clear();
    }

    void clearOutboundBehaviors() {
        this.defaultSendRequest = null;
        Iterator<SendRequestBehavior> sendBehaviorIterator = this.sendBehaviors.values().iterator();
        while (sendBehaviorIterator.hasNext()) {
            SendRequestBehavior behavior = sendBehaviorIterator.next();
            sendBehaviorIterator.remove();
            behavior.clearCallback();
        }
        TestCase.assertTrue((boolean)this.sendBehaviors.isEmpty());
        this.defaultConnectBehavior = null;
        Iterator<OpenConnectionBehavior> connectBehaviorIterator = this.connectBehaviors.values().iterator();
        while (connectBehaviorIterator.hasNext()) {
            OpenConnectionBehavior behavior = connectBehaviorIterator.next();
            connectBehaviorIterator.remove();
            behavior.clearCallback();
        }
        TestCase.assertTrue((boolean)this.connectBehaviors.isEmpty());
    }

    void clearOutboundBehaviors(TransportAddress transportAddress) {
        OpenConnectionBehavior openConnectionBehavior;
        SendRequestBehavior behavior = this.sendBehaviors.remove(transportAddress);
        if (behavior != null) {
            behavior.clearCallback();
        }
        if ((openConnectionBehavior = this.connectBehaviors.remove(transportAddress)) != null) {
            openConnectionBehavior.clearCallback();
        }
    }

    Transport getDelegate() {
        return this.delegate;
    }

    public TransportVersion getVersion() {
        return this.delegate.getVersion();
    }

    public void setMessageListener(TransportMessageListener listener) {
        this.delegate.setMessageListener(listener);
    }

    public BoundTransportAddress boundAddress() {
        return this.delegate.boundAddress();
    }

    public BoundTransportAddress boundRemoteIngressAddress() {
        return this.delegate.boundRemoteIngressAddress();
    }

    public TransportAddress[] addressesFromString(String address) throws UnknownHostException {
        return this.delegate.addressesFromString(address);
    }

    public List<String> getDefaultSeedAddresses() {
        return this.delegate.getDefaultSeedAddresses();
    }

    public void openConnection(DiscoveryNode node, ConnectionProfile profile, ActionListener<Transport.Connection> listener) {
        TransportAddress address = node.getAddress();
        OpenConnectionBehavior behavior = this.connectBehaviors.getOrDefault(address, this.defaultConnectBehavior);
        ActionListener wrappedListener = listener.delegateFailure((delegatedListener, connection) -> delegatedListener.onResponse((Object)new WrappedConnection((Transport.Connection)connection)));
        if (behavior == null) {
            this.delegate.openConnection(node, profile, wrappedListener);
        } else {
            behavior.openConnection(this.delegate, node, profile, (ActionListener<Transport.Connection>)wrappedListener);
        }
    }

    public TransportStats getStats() {
        return this.delegate.getStats();
    }

    public Transport.ResponseHandlers getResponseHandlers() {
        return this.delegate.getResponseHandlers();
    }

    public Transport.RequestHandlers getRequestHandlers() {
        return this.delegate.getRequestHandlers();
    }

    public Lifecycle.State lifecycleState() {
        return this.delegate.lifecycleState();
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.delegate.addLifecycleListener(listener);
    }

    public void start() {
        this.delegate.start();
    }

    public void stop() {
        this.delegate.stop();
    }

    public void close() {
        this.delegate.close();
    }

    public Map<String, BoundTransportAddress> profileBoundAddresses() {
        return this.delegate.profileBoundAddresses();
    }

    public RecyclerBytesStreamOutput newNetworkBytesStream() {
        return new RecyclerBytesStreamOutput((Recycler)new BytesRefRecycler(this.recycler));
    }

    @FunctionalInterface
    public static interface SendRequestBehavior {
        public void sendRequest(Transport.Connection var1, long var2, String var4, TransportRequest var5, TransportRequestOptions var6) throws IOException;

        default public void clearCallback() {
        }
    }

    @FunctionalInterface
    public static interface OpenConnectionBehavior {
        public void openConnection(Transport var1, DiscoveryNode var2, ConnectionProfile var3, ActionListener<Transport.Connection> var4);

        default public void clearCallback() {
        }
    }

    @FunctionalInterface
    public static interface RequestHandlingBehavior<Request extends TransportRequest> {
        public void messageReceived(TransportRequestHandler<Request> var1, Request var2, TransportChannel var3, Task var4) throws Exception;

        default public void clearCallback() {
        }
    }

    public class WrappedConnection
    implements Transport.Connection {
        private final Transport.Connection connection;

        private WrappedConnection(Transport.Connection connection) {
            this.connection = connection;
        }

        public DiscoveryNode getNode() {
            return this.connection.getNode();
        }

        public void sendRequest(long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
            TransportAddress address = this.connection.getNode().getAddress();
            SendRequestBehavior behavior = StubbableTransport.this.sendBehaviors.getOrDefault(address, StubbableTransport.this.defaultSendRequest);
            if (behavior == null) {
                this.connection.sendRequest(requestId, action, request, options);
            } else {
                behavior.sendRequest(this.connection, requestId, action, request, options);
            }
        }

        public void addCloseListener(ActionListener<Void> listener) {
            this.connection.addCloseListener(listener);
        }

        public void addRemovedListener(ActionListener<Void> listener) {
            this.connection.addRemovedListener(listener);
        }

        public boolean isClosed() {
            return this.connection.isClosed();
        }

        public Version getVersion() {
            return this.connection.getVersion();
        }

        public TransportVersion getTransportVersion() {
            return this.connection.getTransportVersion();
        }

        public Object getCacheKey() {
            return this.connection.getCacheKey();
        }

        public void close() {
            this.connection.close();
        }

        public void onRemoved() {
            this.connection.onRemoved();
        }

        public Transport.Connection getConnection() {
            return this.connection;
        }

        public String toString() {
            return "WrappedConnection[" + this.connection + "]";
        }

        public void incRef() {
            this.connection.incRef();
        }

        public boolean tryIncRef() {
            return this.connection.tryIncRef();
        }

        public boolean decRef() {
            return this.connection.decRef();
        }

        public boolean hasReferences() {
            return this.connection.hasReferences();
        }
    }
}

