/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeUtils;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.AllocationId;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.TestShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.health.node.selection.HealthNodeTaskParams;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.shard.IndexLongFieldRange;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.test.ESTestCase;

public class ClusterStateCreationUtils {
    public static ClusterState state(String index, boolean activePrimaryLocal, ShardRoutingState primaryState, ShardRoutingState ... replicaStates) {
        return ClusterStateCreationUtils.state(index, activePrimaryLocal, primaryState, Arrays.stream(replicaStates).map(shardRoutingState -> new Tuple(shardRoutingState, (Object)ShardRouting.Role.DEFAULT)).toList());
    }

    public static ClusterState state(String index, boolean activePrimaryLocal, ShardRoutingState primaryState, List<Tuple<ShardRoutingState, ShardRouting.Role>> replicaStates) {
        return ClusterStateCreationUtils.state(index, activePrimaryLocal, primaryState, ShardRouting.Role.DEFAULT, replicaStates);
    }

    public static ClusterState state(String index, boolean activePrimaryLocal, ShardRoutingState primaryState, ShardRouting.Role primaryRole, List<Tuple<ShardRoutingState, ShardRouting.Role>> replicaStates) {
        assert (primaryState == ShardRoutingState.STARTED || primaryState == ShardRoutingState.RELOCATING || replicaStates.stream().allMatch(s -> s.v1() == ShardRoutingState.UNASSIGNED)) : "invalid shard states [" + String.valueOf(primaryState) + "] vs [" + Arrays.toString(replicaStates.stream().map(t -> (ShardRoutingState)t.v1()).toArray(String[]::new)) + "]";
        int numberOfReplicas = replicaStates.size();
        int numberOfNodes = numberOfReplicas + 1;
        if (primaryState == ShardRoutingState.RELOCATING) {
            ++numberOfNodes;
        }
        for (Tuple<ShardRoutingState, ShardRouting.Role> state : replicaStates) {
            if (state.v1() != ShardRoutingState.RELOCATING) continue;
            ++numberOfNodes;
        }
        numberOfNodes = Math.max(2, numberOfNodes);
        ShardId shardId = new ShardId(index, "_na_", 0);
        DiscoveryNodes.Builder discoBuilder = DiscoveryNodes.builder();
        HashSet<String> unassignedNodes = new HashSet<String>();
        for (int i = 0; i < numberOfNodes + 1; ++i) {
            DiscoveryNode node = ClusterStateCreationUtils.newNode(i);
            discoBuilder = discoBuilder.add(node);
            unassignedNodes.add(node.getId());
        }
        discoBuilder.localNodeId(ClusterStateCreationUtils.newNode(0).getId());
        discoBuilder.masterNodeId(ClusterStateCreationUtils.newNode(1).getId());
        int primaryTerm = 1 + ESTestCase.randomInt(200);
        IndexLongFieldRange timeFieldRange = primaryState == ShardRoutingState.STARTED || primaryState == ShardRoutingState.RELOCATING ? IndexLongFieldRange.UNKNOWN : IndexLongFieldRange.NO_SHARDS;
        IndexMetadata indexMetadata = IndexMetadata.builder((String)index).settings(ESTestCase.indexSettings(IndexVersion.current(), 1, numberOfReplicas).put("index.creation_date", System.currentTimeMillis())).primaryTerm(0, (long)primaryTerm).timestampRange(timeFieldRange).eventIngestedRange(timeFieldRange).build();
        IndexShardRoutingTable.Builder indexShardRoutingBuilder = new IndexShardRoutingTable.Builder(shardId);
        String primaryNode = null;
        String relocatingNode = null;
        UnassignedInfo unassignedInfo = null;
        if (primaryState != ShardRoutingState.UNASSIGNED) {
            if (activePrimaryLocal) {
                primaryNode = ClusterStateCreationUtils.newNode(0).getId();
                unassignedNodes.remove(primaryNode);
            } else {
                HashSet<String> unassignedNodesExecludingPrimary = new HashSet<String>(unassignedNodes);
                unassignedNodesExecludingPrimary.remove(ClusterStateCreationUtils.newNode(0).getId());
                primaryNode = ClusterStateCreationUtils.selectAndRemove(unassignedNodesExecludingPrimary);
                unassignedNodes.remove(primaryNode);
            }
            if (primaryState == ShardRoutingState.RELOCATING) {
                relocatingNode = ClusterStateCreationUtils.selectAndRemove(unassignedNodes);
            } else if (primaryState == ShardRoutingState.INITIALIZING) {
                unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.INDEX_CREATED, null);
            }
        } else {
            unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.INDEX_CREATED, null);
        }
        indexShardRoutingBuilder.addShard(TestShardRouting.shardRoutingBuilder(index, 0, primaryNode, true, primaryState).withRelocatingNodeId(relocatingNode).withUnassignedInfo(unassignedInfo).withRole(primaryRole).build());
        for (Tuple tuple : replicaStates) {
            String replicaNode = null;
            relocatingNode = null;
            unassignedInfo = null;
            if (tuple.v1() != ShardRoutingState.UNASSIGNED) {
                assert (primaryNode != null) : "a replica is assigned but the primary isn't";
                replicaNode = ClusterStateCreationUtils.selectAndRemove(unassignedNodes);
                if (tuple.v1() == ShardRoutingState.RELOCATING) {
                    relocatingNode = ClusterStateCreationUtils.selectAndRemove(unassignedNodes);
                }
            } else {
                unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.INDEX_CREATED, null);
            }
            indexShardRoutingBuilder.addShard(TestShardRouting.shardRoutingBuilder(index, shardId.id(), replicaNode, false, (ShardRoutingState)tuple.v1()).withRelocatingNodeId(relocatingNode).withUnassignedInfo(unassignedInfo).withRole((ShardRouting.Role)tuple.v2()).build());
        }
        IndexShardRoutingTable indexShardRoutingTable = indexShardRoutingBuilder.build();
        IndexMetadata.Builder builder = new IndexMetadata.Builder(indexMetadata);
        builder.putInSyncAllocationIds(0, indexShardRoutingTable.activeShards().stream().map(ShardRouting::allocationId).map(AllocationId::getId).collect(Collectors.toSet()));
        ClusterState.Builder state = ClusterState.builder((ClusterName)new ClusterName("test"));
        state.nodes(discoBuilder);
        state.metadata(Metadata.builder().put(builder.build(), false).generateClusterUuidIfNeeded());
        state.routingTable(RoutingTable.builder().add(IndexRoutingTable.builder((Index)indexMetadata.getIndex()).addIndexShard(indexShardRoutingBuilder)).build());
        return state.build();
    }

    public static ClusterState state(String index, int numberOfNodes, int numberOfPrimaries) {
        DiscoveryNodes.Builder discoBuilder = DiscoveryNodes.builder();
        HashSet<String> nodes = new HashSet<String>();
        for (int i = 0; i < numberOfNodes; ++i) {
            DiscoveryNode node = ClusterStateCreationUtils.newNode(i);
            discoBuilder = discoBuilder.add(node);
            nodes.add(node.getId());
        }
        discoBuilder.localNodeId(ClusterStateCreationUtils.newNode(0).getId());
        discoBuilder.masterNodeId((String)ESTestCase.randomFrom(nodes));
        IndexMetadata indexMetadata = IndexMetadata.builder((String)index).settings(ESTestCase.indexSettings(IndexVersion.current(), numberOfPrimaries, 0).put("index.creation_date", System.currentTimeMillis())).build();
        IndexRoutingTable.Builder indexRoutingTable = IndexRoutingTable.builder((Index)indexMetadata.getIndex());
        for (int i = 0; i < numberOfPrimaries; ++i) {
            ShardId shardId = new ShardId(indexMetadata.getIndex(), i);
            IndexShardRoutingTable.Builder indexShardRoutingBuilder = IndexShardRoutingTable.builder((ShardId)shardId);
            indexShardRoutingBuilder.addShard(TestShardRouting.newShardRouting(shardId, (String)ESTestCase.randomFrom(nodes), true, ShardRoutingState.STARTED));
            indexRoutingTable.addIndexShard(indexShardRoutingBuilder);
        }
        ClusterState.Builder state = ClusterState.builder((ClusterName)new ClusterName("test"));
        state.nodes(discoBuilder);
        state.metadata(Metadata.builder().put(indexMetadata, false).generateClusterUuidIfNeeded());
        state.routingTable(RoutingTable.builder().add(indexRoutingTable).build());
        return state.build();
    }

    public static ClusterState state(int numberOfNodes, String[] indices, int numberOfPrimaries) {
        DiscoveryNodes.Builder discoBuilder = DiscoveryNodes.builder();
        HashSet<String> nodes = new HashSet<String>();
        for (int i = 0; i < numberOfNodes; ++i) {
            DiscoveryNode node = ClusterStateCreationUtils.newNode(i);
            discoBuilder = discoBuilder.add(node);
            nodes.add(node.getId());
        }
        discoBuilder.localNodeId(ClusterStateCreationUtils.newNode(0).getId());
        discoBuilder.masterNodeId(ClusterStateCreationUtils.newNode(0).getId());
        Metadata.Builder metadata = Metadata.builder();
        RoutingTable.Builder routingTable = RoutingTable.builder();
        ArrayList nodesList = new ArrayList(nodes);
        int currentNodeToAssign = 0;
        for (String index : indices) {
            IndexMetadata indexMetadata = IndexMetadata.builder((String)index).settings(ESTestCase.indexSettings(IndexVersion.current(), numberOfPrimaries, 0).put("index.creation_date", System.currentTimeMillis())).eventIngestedRange(IndexLongFieldRange.UNKNOWN).build();
            IndexRoutingTable.Builder indexRoutingTable = IndexRoutingTable.builder((Index)indexMetadata.getIndex());
            for (int i = 0; i < numberOfPrimaries; ++i) {
                ShardId shardId = new ShardId(indexMetadata.getIndex(), i);
                IndexShardRoutingTable.Builder indexShardRoutingBuilder = IndexShardRoutingTable.builder((ShardId)shardId);
                indexShardRoutingBuilder.addShard(TestShardRouting.newShardRouting(shardId, (String)nodesList.get(currentNodeToAssign++), true, ShardRoutingState.STARTED));
                if (currentNodeToAssign == nodesList.size()) {
                    currentNodeToAssign = 0;
                }
                indexRoutingTable.addIndexShard(indexShardRoutingBuilder);
            }
            metadata.put(indexMetadata, false);
            routingTable.add(indexRoutingTable);
        }
        ClusterState.Builder state = ClusterState.builder((ClusterName)new ClusterName("test"));
        state.nodes(discoBuilder);
        state.metadata(metadata.generateClusterUuidIfNeeded().build());
        state.routingTable(routingTable.build());
        return state.build();
    }

    public static ClusterState stateWithAssignedPrimariesAndOneReplica(String index, int numberOfShards) {
        int numberOfNodes = 2;
        DiscoveryNodes.Builder discoBuilder = DiscoveryNodes.builder();
        for (int i = 0; i < numberOfNodes + 1; ++i) {
            DiscoveryNode node = ClusterStateCreationUtils.newNode(i);
            discoBuilder = discoBuilder.add(node);
        }
        discoBuilder.localNodeId(ClusterStateCreationUtils.newNode(0).getId());
        discoBuilder.masterNodeId(ClusterStateCreationUtils.newNode(1).getId());
        IndexMetadata indexMetadata = IndexMetadata.builder((String)index).settings(ESTestCase.indexSettings(IndexVersion.current(), numberOfShards, 1).put("index.creation_date", System.currentTimeMillis())).build();
        ClusterState.Builder state = ClusterState.builder((ClusterName)new ClusterName("test"));
        state.nodes(discoBuilder);
        state.metadata(Metadata.builder().put(indexMetadata, false).generateClusterUuidIfNeeded());
        IndexRoutingTable.Builder indexRoutingTableBuilder = IndexRoutingTable.builder((Index)indexMetadata.getIndex());
        for (int i = 0; i < numberOfShards; ++i) {
            ShardId shardId = new ShardId(index, "_na_", i);
            IndexShardRoutingTable.Builder indexShardRoutingBuilder = IndexShardRoutingTable.builder((ShardId)shardId);
            indexShardRoutingBuilder.addShard(TestShardRouting.newShardRouting(index, i, ClusterStateCreationUtils.newNode(0).getId(), null, true, ShardRoutingState.STARTED));
            indexShardRoutingBuilder.addShard(TestShardRouting.newShardRouting(index, i, ClusterStateCreationUtils.newNode(1).getId(), null, false, ShardRoutingState.STARTED));
            indexRoutingTableBuilder.addIndexShard(indexShardRoutingBuilder);
        }
        state.routingTable(RoutingTable.builder().add(indexRoutingTableBuilder.build()).build());
        return state.build();
    }

    public static ClusterState stateWithAssignedPrimariesAndReplicas(String[] indices, int numberOfShards, int numberOfReplicas) {
        return ClusterStateCreationUtils.stateWithAssignedPrimariesAndReplicas(indices, numberOfShards, Collections.nCopies(numberOfReplicas, ShardRouting.Role.DEFAULT));
    }

    public static ClusterState stateWithAssignedPrimariesAndReplicas(String[] indices, int numberOfShards, List<ShardRouting.Role> replicaRoles) {
        return ClusterStateCreationUtils.stateWithAssignedPrimariesAndReplicasWithState(indices, numberOfShards, replicaRoles.stream().map(role -> Tuple.tuple((Object)ShardRoutingState.STARTED, (Object)role)).toList());
    }

    public static ClusterState stateWithAssignedPrimariesAndReplicasWithState(String[] indices, int numberOfShards, List<Tuple<ShardRoutingState, ShardRouting.Role>> replicaRoleAndStates) {
        return ClusterStateCreationUtils.stateWithAssignedPrimariesAndReplicasWithState(indices, numberOfShards, ShardRouting.Role.DEFAULT, replicaRoleAndStates);
    }

    public static ClusterState stateWithAssignedPrimariesAndReplicasWithState(String[] indices, int numberOfShards, ShardRouting.Role primaryRole, List<Tuple<ShardRoutingState, ShardRouting.Role>> replicasStateAndRoles) {
        int numberOfDataNodes = replicasStateAndRoles.size() + 1;
        DiscoveryNodes.Builder discoBuilder = DiscoveryNodes.builder();
        for (int i = 0; i < numberOfDataNodes + 1; ++i) {
            DiscoveryNode node = ClusterStateCreationUtils.newNode(i);
            discoBuilder = discoBuilder.add(node);
            if (i == 0) {
                discoBuilder.localNodeId(node.getId());
                continue;
            }
            if (i != numberOfDataNodes) continue;
            discoBuilder.masterNodeId(node.getId());
        }
        ClusterState.Builder state = ClusterState.builder((ClusterName)new ClusterName("test"));
        state.nodes(discoBuilder);
        RoutingTable.Builder routingTableBuilder = RoutingTable.builder();
        Metadata.Builder metadataBuilder = Metadata.builder();
        for (String index : indices) {
            IndexMetadata indexMetadata = IndexMetadata.builder((String)index).settings(ESTestCase.indexSettings(IndexVersion.current(), numberOfShards, replicasStateAndRoles.size()).put("index.creation_date", System.currentTimeMillis())).timestampRange(IndexLongFieldRange.UNKNOWN).eventIngestedRange(IndexLongFieldRange.UNKNOWN).build();
            metadataBuilder.put(indexMetadata, false).generateClusterUuidIfNeeded();
            IndexRoutingTable.Builder indexRoutingTableBuilder = IndexRoutingTable.builder((Index)indexMetadata.getIndex());
            for (int i = 0; i < numberOfShards; ++i) {
                ShardId shardId = new ShardId(index, "_na_", i);
                IndexShardRoutingTable.Builder indexShardRoutingBuilder = IndexShardRoutingTable.builder((ShardId)shardId);
                indexShardRoutingBuilder.addShard(TestShardRouting.shardRoutingBuilder(index, i, ClusterStateCreationUtils.newNode(0).getId(), true, ShardRoutingState.STARTED).withRole(primaryRole).build());
                for (int replica = 0; replica < replicasStateAndRoles.size(); ++replica) {
                    Tuple<ShardRoutingState, ShardRouting.Role> replicaStateAndRole = replicasStateAndRoles.get(replica);
                    ShardRoutingState shardRoutingState = (ShardRoutingState)replicaStateAndRole.v1();
                    String currentNodeId = shardRoutingState.equals((Object)ShardRoutingState.UNASSIGNED) ? null : ClusterStateCreationUtils.newNode(replica + 1).getId();
                    TestShardRouting.Builder shardRoutingBuilder = TestShardRouting.shardRoutingBuilder(index, i, currentNodeId, false, shardRoutingState).withRole((ShardRouting.Role)replicaStateAndRole.v2());
                    if (shardRoutingState.equals((Object)ShardRoutingState.RELOCATING)) {
                        shardRoutingBuilder.withRelocatingNodeId(DiscoveryNodeUtils.create("relocating_" + replica).getId());
                    }
                    indexShardRoutingBuilder.addShard(shardRoutingBuilder.build());
                }
                indexRoutingTableBuilder.addIndexShard(indexShardRoutingBuilder);
            }
            routingTableBuilder.add(indexRoutingTableBuilder.build());
        }
        state.metadata(metadataBuilder);
        state.routingTable(routingTableBuilder.build());
        return state.build();
    }

    public static ClusterState stateWithActivePrimary(String index, boolean activePrimaryLocal, int numberOfReplicas) {
        int assignedReplicas = ESTestCase.randomIntBetween(0, numberOfReplicas);
        return ClusterStateCreationUtils.stateWithActivePrimary(index, activePrimaryLocal, assignedReplicas, numberOfReplicas - assignedReplicas);
    }

    public static ClusterState stateWithActivePrimary(String index, boolean activePrimaryLocal, int assignedReplicas, int unassignedReplicas) {
        int i;
        ShardRoutingState[] replicaStates = new ShardRoutingState[assignedReplicas + unassignedReplicas];
        for (i = 0; i < assignedReplicas; ++i) {
            replicaStates[i] = ESTestCase.randomFrom(ShardRoutingState.INITIALIZING, ShardRoutingState.STARTED, ShardRoutingState.RELOCATING);
        }
        for (i = assignedReplicas; i < replicaStates.length; ++i) {
            replicaStates[i] = ShardRoutingState.UNASSIGNED;
        }
        return ClusterStateCreationUtils.state(index, activePrimaryLocal, ESTestCase.randomFrom(ShardRoutingState.STARTED, ShardRoutingState.RELOCATING), replicaStates);
    }

    public static ClusterState stateWithNoShard() {
        DiscoveryNodes.Builder discoBuilder = DiscoveryNodes.builder();
        DiscoveryNode localNode = ClusterStateCreationUtils.newNode(0);
        discoBuilder.add(localNode);
        discoBuilder.localNodeId(localNode.getId());
        DiscoveryNode masterNode = ClusterStateCreationUtils.newNode(1);
        discoBuilder.add(masterNode);
        discoBuilder.masterNodeId(masterNode.getId());
        ClusterState.Builder state = ClusterState.builder((ClusterName)new ClusterName("test"));
        state.nodes(discoBuilder);
        state.metadata(Metadata.builder().generateClusterUuidIfNeeded());
        state.routingTable(RoutingTable.builder().build());
        return state.build();
    }

    public static ClusterState state(DiscoveryNode localNode, DiscoveryNode masterNode, DiscoveryNode ... allNodes) {
        return ClusterStateCreationUtils.state(localNode, masterNode, null, allNodes);
    }

    public static ClusterState state(DiscoveryNode localNode, DiscoveryNode masterNode, DiscoveryNode[] allNodes, TransportVersion transportVersion) {
        return ClusterStateCreationUtils.state(localNode, masterNode, null, allNodes, transportVersion);
    }

    public static ClusterState state(DiscoveryNode localNode, DiscoveryNode masterNode, DiscoveryNode healthNode, DiscoveryNode ... allNodes) {
        return ClusterStateCreationUtils.state(localNode, masterNode, healthNode, allNodes, TransportVersion.current());
    }

    public static ClusterState state(DiscoveryNode localNode, DiscoveryNode masterNode, DiscoveryNode healthNode, DiscoveryNode[] allNodes, TransportVersion transportVersion) {
        DiscoveryNodes.Builder discoBuilder = DiscoveryNodes.builder();
        for (DiscoveryNode node : allNodes) {
            discoBuilder.add(node);
        }
        if (masterNode != null) {
            discoBuilder.masterNodeId(masterNode.getId());
            discoBuilder.add(masterNode);
        }
        discoBuilder.localNodeId(localNode.getId());
        ClusterState.Builder state = ClusterState.builder((ClusterName)new ClusterName("test"));
        state.nodes(discoBuilder);
        for (DiscoveryNode node : allNodes) {
            state.putCompatibilityVersions(node.getId(), transportVersion, SystemIndices.SERVER_SYSTEM_MAPPINGS_VERSIONS);
        }
        Metadata.Builder metadataBuilder = Metadata.builder().generateClusterUuidIfNeeded();
        if (healthNode != null) {
            ClusterStateCreationUtils.addHealthNode(metadataBuilder, healthNode);
        }
        state.metadata(metadataBuilder);
        return state.build();
    }

    private static DiscoveryNode newNode(int nodeId) {
        return DiscoveryNodeUtils.create("node_" + nodeId);
    }

    private static String selectAndRemove(Set<String> strings) {
        String selection = ESTestCase.randomFrom(strings.toArray(new String[strings.size()]));
        strings.remove(selection);
        return selection;
    }

    private static Metadata.Builder addHealthNode(Metadata.Builder metadataBuilder, DiscoveryNode healthNode) {
        PersistentTasksCustomMetadata.Builder tasks = PersistentTasksCustomMetadata.builder();
        PersistentTasksCustomMetadata.Assignment assignment = new PersistentTasksCustomMetadata.Assignment(healthNode.getId(), ESTestCase.randomAlphaOfLength(10));
        tasks.addTask("health-node", "health-node", (PersistentTaskParams)HealthNodeTaskParams.INSTANCE, assignment);
        return metadataBuilder.putCustom("persistent_tasks", (Metadata.Custom)tasks.build());
    }
}

