/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.test.ESTestCase;

public class TestIngestDocument {
    public static final long DEFAULT_VERSION = 12345L;
    private static final String VERSION = IngestDocument.Metadata.VERSION.getFieldName();

    public static IngestDocument withDefaultVersion(Map<String, Object> sourceAndMetadata, Map<String, Object> ingestMetadata) {
        if (!sourceAndMetadata.containsKey(VERSION)) {
            sourceAndMetadata = new HashMap<String, Object>(sourceAndMetadata);
            sourceAndMetadata.put(VERSION, 12345L);
        }
        return new IngestDocument(sourceAndMetadata, ingestMetadata);
    }

    public static IngestDocument withDefaultVersion(Map<String, Object> sourceAndMetadata) {
        return TestIngestDocument.withDefaultVersion(sourceAndMetadata, new HashMap<String, Object>());
    }

    public static IngestDocument emptyIngestDocument() {
        HashMap<String, Long> sourceAndMetadata = new HashMap<String, Long>();
        sourceAndMetadata.put(VERSION, 12345L);
        return new IngestDocument(sourceAndMetadata, new HashMap());
    }

    public static Tuple<String, Object> randomMetadata() {
        IngestDocument.Metadata metadata = ESTestCase.randomFrom(IngestDocument.Metadata.values());
        String string = metadata.getFieldName();
        return new Tuple((Object)string, (Object)(switch (metadata) {
            case IngestDocument.Metadata.VERSION, IngestDocument.Metadata.IF_SEQ_NO, IngestDocument.Metadata.IF_PRIMARY_TERM -> ESTestCase.randomIntBetween(0, 124);
            case IngestDocument.Metadata.VERSION_TYPE -> VersionType.toString((VersionType)ESTestCase.randomFrom(VersionType.values()));
            case IngestDocument.Metadata.DYNAMIC_TEMPLATES -> Map.of(ESTestCase.randomAlphaOfLengthBetween(5, 10), ESTestCase.randomAlphaOfLengthBetween(5, 10));
            default -> ESTestCase.randomAlphaOfLengthBetween(5, 10);
        }));
    }

    public static long randomVersion() {
        return ESTestCase.randomLongBetween(-4L, Long.MAX_VALUE);
    }
}

