/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.logsdb.datageneration.matchers.source;

import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.sandbox.document.HalfFloatPoint;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.logsdb.datageneration.matchers.MatchResult;
import org.elasticsearch.logsdb.datageneration.matchers.Messages;
import org.elasticsearch.xcontent.XContentBuilder;

interface FieldSpecificMatcher {
    public MatchResult match(List<Object> var1, List<Object> var2, Map<String, Object> var3, Map<String, Object> var4);

    public static class UnsignedLongMatcher
    implements FieldSpecificMatcher {
        private final XContentBuilder actualMappings;
        private final Settings.Builder actualSettings;
        private final XContentBuilder expectedMappings;
        private final Settings.Builder expectedSettings;

        UnsignedLongMatcher(XContentBuilder actualMappings, Settings.Builder actualSettings, XContentBuilder expectedMappings, Settings.Builder expectedSettings) {
            this.actualMappings = actualMappings;
            this.actualSettings = actualSettings;
            this.expectedMappings = expectedMappings;
            this.expectedSettings = expectedSettings;
        }

        @Override
        public MatchResult match(List<Object> actual, List<Object> expected, Map<String, Object> actualMapping, Map<String, Object> expectedMapping) {
            Set<BigInteger> expectedNormalized = UnsignedLongMatcher.normalize(expected);
            Set<BigInteger> actualNormalized = UnsignedLongMatcher.normalize(actual);
            return actualNormalized.equals(expectedNormalized) ? MatchResult.match() : MatchResult.noMatch(Messages.formatErrorMessage(this.actualMappings, this.actualSettings, this.expectedMappings, this.expectedSettings, "Values of type [unsigned_long] don't match after normalization, normalized " + Messages.prettyPrintCollections(actualNormalized, expectedNormalized)));
        }

        private static Set<BigInteger> normalize(List<Object> values) {
            if (values == null) {
                return Set.of();
            }
            return values.stream().filter(Objects::nonNull).map(UnsignedLongMatcher::toBigInteger).collect(Collectors.toSet());
        }

        private static BigInteger toBigInteger(Object value) {
            if (value instanceof String) {
                String s = (String)value;
                return new BigInteger(s, 10);
            }
            if (value instanceof Long) {
                Long l = (Long)value;
                return BigInteger.valueOf(l);
            }
            return (BigInteger)value;
        }
    }

    public static class ScaledFloatMatcher
    implements FieldSpecificMatcher {
        private final XContentBuilder actualMappings;
        private final Settings.Builder actualSettings;
        private final XContentBuilder expectedMappings;
        private final Settings.Builder expectedSettings;

        ScaledFloatMatcher(XContentBuilder actualMappings, Settings.Builder actualSettings, XContentBuilder expectedMappings, Settings.Builder expectedSettings) {
            this.actualMappings = actualMappings;
            this.actualSettings = actualSettings;
            this.expectedMappings = expectedMappings;
            this.expectedSettings = expectedSettings;
        }

        @Override
        public MatchResult match(List<Object> actual, List<Object> expected, Map<String, Object> actualMapping, Map<String, Object> expectedMapping) {
            Object expectedScalingFactor;
            Object scalingFactor = actualMapping.get("scaling_factor");
            if (!Objects.equals(scalingFactor, expectedScalingFactor = expectedMapping.get("scaling_factor"))) {
                throw new IllegalStateException("Scaling factor for scaled_float field does not match between actual and expected mapping");
            }
            assert (scalingFactor instanceof Number);
            double scalingFactorDouble = ((Number)scalingFactor).doubleValue();
            Set<Double> expectedNormalized = ScaledFloatMatcher.normalizeValues(expected);
            Set<Double> actualNormalized = ScaledFloatMatcher.normalizeValues(actual);
            for (Double expectedValue : expectedNormalized) {
                if (actualNormalized.contains(expectedValue) || actualNormalized.contains(this.encodeDecodeWithPrecisionLoss(expectedValue, scalingFactorDouble))) continue;
                return MatchResult.noMatch(Messages.formatErrorMessage(this.actualMappings, this.actualSettings, this.expectedMappings, this.expectedSettings, "Values of type [scaled_float] don't match after normalization, normalized " + Messages.prettyPrintCollections(actualNormalized, expectedNormalized)));
            }
            return MatchResult.match();
        }

        private Double encodeDecodeWithPrecisionLoss(double value, double scalingFactor) {
            long encoded = Math.round(value * scalingFactor);
            return (double)encoded / scalingFactor;
        }

        private static Set<Double> normalizeValues(List<Object> values) {
            if (values == null) {
                return Set.of();
            }
            return values.stream().filter(Objects::nonNull).map(ScaledFloatMatcher::toDouble).collect(Collectors.toSet());
        }

        private static double toDouble(Object value) {
            return ((Number)value).doubleValue();
        }
    }

    public static class HalfFloatMatcher
    implements FieldSpecificMatcher {
        private final XContentBuilder actualMappings;
        private final Settings.Builder actualSettings;
        private final XContentBuilder expectedMappings;
        private final Settings.Builder expectedSettings;

        HalfFloatMatcher(XContentBuilder actualMappings, Settings.Builder actualSettings, XContentBuilder expectedMappings, Settings.Builder expectedSettings) {
            this.actualMappings = actualMappings;
            this.actualSettings = actualSettings;
            this.expectedMappings = expectedMappings;
            this.expectedSettings = expectedSettings;
        }

        @Override
        public MatchResult match(List<Object> actual, List<Object> expected, Map<String, Object> actualMapping, Map<String, Object> expectedMapping) {
            Set<Short> expectedHalfFloatBytes;
            Set<Short> actualHalfFloatBytes = HalfFloatMatcher.normalize(actual);
            return actualHalfFloatBytes.equals(expectedHalfFloatBytes = HalfFloatMatcher.normalize(expected)) ? MatchResult.match() : MatchResult.noMatch(Messages.formatErrorMessage(this.actualMappings, this.actualSettings, this.expectedMappings, this.expectedSettings, "Values of type [half_float] don't match after normalization, normalized " + Messages.prettyPrintCollections(actualHalfFloatBytes, expectedHalfFloatBytes)));
        }

        private static Set<Short> normalize(List<Object> values) {
            if (values == null) {
                return Set.of();
            }
            Function<Object, Float> toFloat = o -> {
                Float f;
                if (o instanceof Number) {
                    Number n = (Number)o;
                    f = Float.valueOf(n.floatValue());
                } else {
                    f = Float.valueOf(Float.parseFloat((String)o));
                }
                return f;
            };
            return values.stream().filter(Objects::nonNull).map(toFloat).map(HalfFloatPoint::halfFloatToSortableShort).collect(Collectors.toSet());
        }
    }
}

