/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.logsdb.datageneration.matchers.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;

class SourceTransforms {
    SourceTransforms() {
    }

    public static Map<String, List<Object>> normalize(Map<String, Object> map) {
        TreeMap<String, List<Object>> flattened = new TreeMap<String, List<Object>>();
        SourceTransforms.descend(null, map, flattened);
        return flattened;
    }

    public static <T> List<T> normalizeValues(List<T> values) {
        if (values == null) {
            return Collections.emptyList();
        }
        return SourceTransforms.normalizeValues(values, Function.identity());
    }

    public static <T, U> List<U> normalizeValues(List<T> values, Function<T, U> transform) {
        if (values == null) {
            return Collections.emptyList();
        }
        return new ArrayList(values.stream().filter(v -> v != null && !Objects.equals(v, "null")).map(transform).collect(Collectors.toSet()));
    }

    private static void descend(String pathFromRoot, Map<String, Object> currentLevel, Map<String, List<Object>> flattened) {
        for (Map.Entry<String, Object> entry : currentLevel.entrySet()) {
            String pathToCurrentField = pathFromRoot == null ? entry.getKey() : pathFromRoot + "." + entry.getKey();
            Iterator iterator = entry.getValue();
            if (iterator instanceof List) {
                List list = (List)((Object)iterator);
                for (Object fieldValue : list) {
                    SourceTransforms.handleField(pathToCurrentField, fieldValue, flattened);
                }
                continue;
            }
            SourceTransforms.handleField(pathToCurrentField, entry.getValue(), flattened);
        }
    }

    private static void handleField(String pathToCurrentField, Object currentField, Map<String, List<Object>> flattened) {
        if (currentField instanceof Map) {
            Map map = (Map)currentField;
            SourceTransforms.descend(pathToCurrentField, map, flattened);
        } else {
            flattened.computeIfAbsent(pathToCurrentField, k -> new ArrayList()).add(currentField);
        }
    }
}

