/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.action.support.master.IsAcknowledgedSupplier;
import org.elasticsearch.common.blobstore.BlobStoreActionStats;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.mocksocket.MockHttpServer;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.repositories.RepositoryStats;
import org.elasticsearch.repositories.blobstore.ESBlobStoreRepositoryIntegTestCase;
import org.elasticsearch.test.BackgroundIndexer;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.elasticsearch.threadpool.ThreadPool;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

@LuceneTestCase.SuppressFileSystems(value={"WindowsFS", "ExtrasFS"})
@SuppressForbidden(reason="this test uses a HttpServer to emulate a cloud-based storage service")
public abstract class ESMockAPIBasedRepositoryIntegTestCase
extends ESBlobStoreRepositoryIntegTestCase {
    private static final byte[] BUFFER = new byte[1024];
    private static HttpServer httpServer;
    private static ExecutorService executorService;
    protected Map<String, HttpHandler> handlers;
    private static final Logger log;

    @BeforeClass
    public static void startHttpServer() throws Exception {
        httpServer = MockHttpServer.createHttp((InetSocketAddress)new InetSocketAddress(InetAddress.getLoopbackAddress(), 0), (int)0);
        ThreadFactory threadFactory = EsExecutors.daemonThreadFactory((String)("[" + ESMockAPIBasedRepositoryIntegTestCase.class.getName() + "]"));
        executorService = EsExecutors.newScaling((String)ESMockAPIBasedRepositoryIntegTestCase.class.getName(), (int)1, (int)2, (long)60L, (TimeUnit)TimeUnit.SECONDS, (boolean)true, (ThreadFactory)threadFactory, (ThreadContext)new ThreadContext(Settings.EMPTY));
        httpServer.setExecutor(r -> executorService.execute(() -> {
            try {
                r.run();
            }
            catch (Throwable t) {
                log.error("Error in execution on mock http server IO thread", t);
                throw t;
            }
        }));
        httpServer.start();
    }

    @Before
    public void setUpHttpServer() {
        this.handlers = new HashMap<String, HttpHandler>(this.createHttpHandlers());
        this.handlers.replaceAll((k, h) -> ESMockAPIBasedRepositoryIntegTestCase.wrap(ESMockAPIBasedRepositoryIntegTestCase.randomBoolean() ? this.createErroneousHttpHandler((HttpHandler)h) : h, this.logger));
        this.handlers.forEach(httpServer::createContext);
    }

    @AfterClass
    public static void stopHttpServer() {
        httpServer.stop(0);
        ThreadPool.terminate((ExecutorService)executorService, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        httpServer = null;
    }

    @After
    public void tearDownHttpServer() {
        if (this.handlers != null) {
            for (Map.Entry<String, HttpHandler> handler : this.handlers.entrySet()) {
                httpServer.removeContext(handler.getKey());
                HttpHandler h = handler.getValue();
                while (h instanceof DelegatingHttpHandler) {
                    h = ((DelegatingHttpHandler)h).getDelegate();
                }
                if (!(h instanceof BlobStoreHttpHandler)) continue;
                ESMockAPIBasedRepositoryIntegTestCase.assertEmptyRepo(((BlobStoreHttpHandler)h).blobs());
            }
        }
    }

    protected static void assertEmptyRepo(Map<String, BytesReference> blobsMap) {
        List blobs = blobsMap.keySet().stream().filter(blob -> !blob.contains("index")).collect(Collectors.toList());
        ESMockAPIBasedRepositoryIntegTestCase.assertThat("Only index blobs should remain in repository but found " + String.valueOf(blobs), blobs, Matchers.hasSize((int)0));
    }

    protected abstract Map<String, HttpHandler> createHttpHandlers();

    protected abstract HttpHandler createErroneousHttpHandler(HttpHandler var1);

    public final void testSnapshotWithLargeSegmentFiles() throws Exception {
        String repository = this.createRepository(this.randomRepositoryName());
        String index = "index-no-merges";
        this.createIndex("index-no-merges", 1, 0);
        long nbDocs = ESMockAPIBasedRepositoryIntegTestCase.randomLongBetween(10000L, 20000L);
        try (BackgroundIndexer indexer = new BackgroundIndexer("index-no-merges", ESMockAPIBasedRepositoryIntegTestCase.client(), (int)nbDocs);){
            this.waitForDocs(nbDocs, indexer);
        }
        this.flushAndRefresh("index-no-merges");
        BroadcastResponse forceMerge = (BroadcastResponse)ESMockAPIBasedRepositoryIntegTestCase.client().admin().indices().prepareForceMerge(new String[]{"index-no-merges"}).setFlush(true).setMaxNumSegments(1).get();
        ESMockAPIBasedRepositoryIntegTestCase.assertThat(forceMerge.getSuccessfulShards(), Matchers.equalTo((Object)1));
        ElasticsearchAssertions.assertHitCount(ESMockAPIBasedRepositoryIntegTestCase.prepareSearch("index-no-merges").setSize(0).setTrackTotalHits(true), nbDocs);
        String snapshot = "snapshot";
        ESMockAPIBasedRepositoryIntegTestCase.assertSuccessfulSnapshot(ESMockAPIBasedRepositoryIntegTestCase.clusterAdmin().prepareCreateSnapshot(TEST_REQUEST_TIMEOUT, repository, "snapshot").setWaitForCompletion(true).setIndices(new String[]{"index-no-merges"}));
        ElasticsearchAssertions.assertAcked(ESMockAPIBasedRepositoryIntegTestCase.client().admin().indices().prepareDelete(new String[]{"index-no-merges"}));
        ESMockAPIBasedRepositoryIntegTestCase.assertSuccessfulRestore(ESMockAPIBasedRepositoryIntegTestCase.clusterAdmin().prepareRestoreSnapshot(TEST_REQUEST_TIMEOUT, repository, "snapshot").setWaitForCompletion(true));
        this.ensureGreen("index-no-merges");
        ElasticsearchAssertions.assertHitCount(ESMockAPIBasedRepositoryIntegTestCase.prepareSearch("index-no-merges").setSize(0).setTrackTotalHits(true), nbDocs);
        ElasticsearchAssertions.assertAcked((IsAcknowledgedSupplier)ESMockAPIBasedRepositoryIntegTestCase.clusterAdmin().prepareDeleteSnapshot(TEST_REQUEST_TIMEOUT, repository, new String[]{"snapshot"}).get());
    }

    public void testRequestStats() throws Exception {
        String repository = this.createRepository(this.randomRepositoryName(), false);
        String index = "index-no-merges";
        this.createIndex("index-no-merges", 1, 0);
        long nbDocs = ESMockAPIBasedRepositoryIntegTestCase.randomLongBetween(10000L, 20000L);
        try (BackgroundIndexer indexer = new BackgroundIndexer("index-no-merges", ESMockAPIBasedRepositoryIntegTestCase.client(), (int)nbDocs);){
            this.waitForDocs(nbDocs, indexer);
        }
        this.flushAndRefresh("index-no-merges");
        BroadcastResponse forceMerge = (BroadcastResponse)ESMockAPIBasedRepositoryIntegTestCase.client().admin().indices().prepareForceMerge(new String[]{"index-no-merges"}).setFlush(true).setMaxNumSegments(1).get();
        ESMockAPIBasedRepositoryIntegTestCase.assertThat(forceMerge.getSuccessfulShards(), Matchers.equalTo((Object)1));
        ElasticsearchAssertions.assertHitCount(ESMockAPIBasedRepositoryIntegTestCase.prepareSearch("index-no-merges").setSize(0).setTrackTotalHits(true), nbDocs);
        String snapshot = "snapshot";
        ESMockAPIBasedRepositoryIntegTestCase.assertSuccessfulSnapshot(ESMockAPIBasedRepositoryIntegTestCase.clusterAdmin().prepareCreateSnapshot(TEST_REQUEST_TIMEOUT, repository, "snapshot").setWaitForCompletion(true).setIndices(new String[]{"index-no-merges"}));
        ElasticsearchAssertions.assertAcked(ESMockAPIBasedRepositoryIntegTestCase.client().admin().indices().prepareDelete(new String[]{"index-no-merges"}));
        ESMockAPIBasedRepositoryIntegTestCase.assertSuccessfulRestore(ESMockAPIBasedRepositoryIntegTestCase.clusterAdmin().prepareRestoreSnapshot(TEST_REQUEST_TIMEOUT, repository, "snapshot").setWaitForCompletion(true));
        this.ensureGreen("index-no-merges");
        ElasticsearchAssertions.assertHitCount(ESMockAPIBasedRepositoryIntegTestCase.prepareSearch("index-no-merges").setSize(0).setTrackTotalHits(true), nbDocs);
        ElasticsearchAssertions.assertAcked((IsAcknowledgedSupplier)ESMockAPIBasedRepositoryIntegTestCase.clusterAdmin().prepareDeleteSnapshot(TEST_REQUEST_TIMEOUT, repository, new String[]{"snapshot"}).get());
        RepositoryStats repositoryStats = StreamSupport.stream(ESMockAPIBasedRepositoryIntegTestCase.internalCluster().getInstances(RepositoriesService.class).spliterator(), false).map(repositoriesService -> {
            try {
                return repositoriesService.repository(repository);
            }
            catch (RepositoryMissingException e) {
                return null;
            }
        }).filter(Objects::nonNull).map(Repository::stats).reduce(RepositoryStats::merge).get();
        Map<String, Long> sdkRequestCounts = repositoryStats.actionStats.entrySet().stream().filter(entry -> false == ("AbortMultipartObject".equals(entry.getKey()) && ((BlobStoreActionStats)entry.getValue()).requests() == 0L)).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> ((BlobStoreActionStats)e.getValue()).requests()));
        Map<String, Long> mockCalls = this.getMockRequestCounts();
        String assertionErrorMsg = String.format("SDK sent [%s] calls and handler measured [%s] calls", sdkRequestCounts, mockCalls);
        ESMockAPIBasedRepositoryIntegTestCase.assertEquals((String)assertionErrorMsg, mockCalls, sdkRequestCounts);
    }

    protected Map<String, Long> getMockRequestCounts() {
        for (HttpHandler h : this.handlers.values()) {
            while (h instanceof DelegatingHttpHandler) {
                if (h instanceof HttpStatsCollectorHandler) {
                    return ((HttpStatsCollectorHandler)h).getOperationsCount();
                }
                h = ((DelegatingHttpHandler)h).getDelegate();
            }
        }
        return Collections.emptyMap();
    }

    protected static String httpServerUrl() {
        return "http://" + ESMockAPIBasedRepositoryIntegTestCase.serverUrl();
    }

    protected static String serverUrl() {
        InetSocketAddress address = httpServer.getAddress();
        return InetAddresses.toUriString((InetAddress)address.getAddress()) + ":" + address.getPort();
    }

    public static void drainInputStream(InputStream inputStream) throws IOException {
        while (inputStream.read(BUFFER) >= 0) {
        }
    }

    public static DelegatingHttpHandler wrap(HttpHandler handler, Logger logger) {
        return new ExceptionCatchingHttpHandler(handler, logger);
    }

    static {
        log = LogManager.getLogger(ESMockAPIBasedRepositoryIntegTestCase.class);
    }

    @SuppressForbidden(reason="this test uses a HttpServer to emulate a cloud-based storage service")
    public static interface DelegatingHttpHandler
    extends HttpHandler {
        public HttpHandler getDelegate();
    }

    @SuppressForbidden(reason="Uses a HttpServer to emulate a cloud-based storage service")
    protected static interface BlobStoreHttpHandler
    extends HttpHandler {
        public Map<String, BytesReference> blobs();
    }

    @SuppressForbidden(reason="this test uses a HttpServer to emulate a cloud-based storage service")
    public static abstract class HttpStatsCollectorHandler
    implements DelegatingHttpHandler {
        private final HttpHandler delegate;
        private final Map<String, Long> operationCount = new HashMap<String, Long>();

        public HttpStatsCollectorHandler(HttpHandler delegate) {
            this.delegate = delegate;
        }

        @Override
        public HttpHandler getDelegate() {
            return this.delegate;
        }

        synchronized Map<String, Long> getOperationsCount() {
            return Map.copyOf(this.operationCount);
        }

        protected synchronized void trackRequest(String requestType) {
            this.operationCount.put(requestType, this.operationCount.getOrDefault(requestType, 0L) + 1L);
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            String request = exchange.getRequestMethod() + " " + exchange.getRequestURI().toString();
            this.maybeTrack(request, exchange.getRequestHeaders());
            this.delegate.handle(exchange);
        }

        protected abstract void maybeTrack(String var1, Headers var2);
    }

    @SuppressForbidden(reason="this test uses a HttpServer to emulate a cloud-based storage service")
    private static class ExceptionCatchingHttpHandler
    implements DelegatingHttpHandler {
        private final HttpHandler handler;
        private final Logger logger;

        ExceptionCatchingHttpHandler(HttpHandler handler, Logger logger) {
            this.handler = handler;
            this.logger = logger;
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            try {
                this.handler.handle(exchange);
            }
            catch (Throwable t) {
                this.logger.error(() -> Strings.format((String)"Exception when handling request %s %s %s", (Object[])new Object[]{exchange.getRemoteAddress(), exchange.getRequestMethod(), exchange.getRequestURI()}), t);
                throw t;
            }
        }

        @Override
        public HttpHandler getDelegate() {
            return this.handler;
        }
    }

    @SuppressForbidden(reason="this test uses a HttpServer to emulate a cloud-based storage service")
    protected static abstract class ErroneousHttpHandler
    implements DelegatingHttpHandler {
        private final Map<String, AtomicInteger> requests = new ConcurrentHashMap<String, AtomicInteger>();
        private final HttpHandler delegate;
        private final int maxErrorsPerRequest;

        @SuppressForbidden(reason="this test uses a HttpServer to emulate a cloud-based storage service")
        protected ErroneousHttpHandler(HttpHandler delegate, int maxErrorsPerRequest) {
            this.delegate = delegate;
            this.maxErrorsPerRequest = maxErrorsPerRequest;
            assert (maxErrorsPerRequest > 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HttpExchange exchange) throws IOException {
            try {
                String requestId = this.requestUniqueId(exchange);
                assert (org.elasticsearch.common.Strings.hasText((String)requestId));
                boolean canFailRequest = this.canFailRequest(exchange);
                int count = this.requests.computeIfAbsent(requestId, req -> new AtomicInteger(0)).incrementAndGet();
                if (count >= this.maxErrorsPerRequest || !canFailRequest) {
                    this.requests.remove(requestId);
                    this.delegate.handle(exchange);
                } else {
                    this.handleAsError(exchange);
                }
            }
            finally {
                try {
                    int read = exchange.getRequestBody().read();
                    assert (read == -1) : "Request body should have been fully read here but saw [" + read + "]";
                }
                catch (IOException iOException) {}
                exchange.close();
            }
        }

        protected void handleAsError(HttpExchange exchange) throws IOException {
            try {
                ESMockAPIBasedRepositoryIntegTestCase.drainInputStream(exchange.getRequestBody());
                exchange.sendResponseHeaders(500, -1L);
            }
            finally {
                exchange.close();
            }
        }

        protected abstract String requestUniqueId(HttpExchange var1);

        protected boolean canFailRequest(HttpExchange exchange) {
            return true;
        }

        @Override
        public HttpHandler getDelegate() {
            return this.delegate;
        }
    }
}

