/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.cluster.remote.RemoteInfoRequest;
import org.elasticsearch.action.admin.cluster.remote.RemoteInfoResponse;
import org.elasticsearch.action.admin.cluster.remote.TransportRemoteInfoAction;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Strings;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.discovery.SettingsBasedSeedHostsProvider;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.test.CloseableTestClusterWrapper;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.InternalTestCluster;
import org.elasticsearch.test.MockHttpTransport;
import org.elasticsearch.test.NodeConfigurationSource;
import org.elasticsearch.test.transport.MockTransportService;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.TransportService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;

public abstract class AbstractMultiClustersTestCase
extends ESTestCase {
    public static final String LOCAL_CLUSTER = "";
    public static final boolean DEFAULT_SKIP_UNAVAILABLE = (Boolean)RemoteClusterService.REMOTE_CLUSTER_SKIP_UNAVAILABLE.getDefault(Settings.EMPTY);
    private static final Logger LOGGER = LogManager.getLogger(AbstractMultiClustersTestCase.class);
    private static volatile ClusterGroup clusterGroup;

    protected List<String> remoteClusterAlias() {
        return AbstractMultiClustersTestCase.randomSubsetOf(List.of("cluster-a", "cluster-b"));
    }

    protected Map<String, Boolean> skipUnavailableForRemoteClusters() {
        return Map.of("cluster-a", DEFAULT_SKIP_UNAVAILABLE, "cluster-b", DEFAULT_SKIP_UNAVAILABLE);
    }

    protected Collection<Class<? extends Plugin>> nodePlugins(String clusterAlias) {
        return Collections.emptyList();
    }

    protected Settings nodeSettings() {
        return Settings.EMPTY;
    }

    protected final Client client() {
        return this.client(LOCAL_CLUSTER);
    }

    protected final Client client(String clusterAlias) {
        return this.cluster(clusterAlias).client();
    }

    protected final InternalTestCluster cluster(String clusterAlias) {
        return clusterGroup.getCluster(clusterAlias);
    }

    protected final Map<String, InternalTestCluster> clusters() {
        return Collections.unmodifiableMap(AbstractMultiClustersTestCase.clusterGroup.clusters);
    }

    protected boolean reuseClusters() {
        return true;
    }

    @Before
    public final void startClusters() throws Exception {
        if (clusterGroup != null && this.reuseClusters()) {
            return;
        }
        AbstractMultiClustersTestCase.stopClusters();
        ConcurrentHashMap clusters = new ConcurrentHashMap();
        ArrayList<String> clusterAliases = new ArrayList<String>(this.remoteClusterAlias());
        clusterAliases.add(LOCAL_CLUSTER);
        List<Class<? extends Plugin>> mockPlugins = List.of(MockHttpTransport.TestPlugin.class, MockTransportService.TestPlugin.class, AbstractMultiClustersTestCase.getTestTransportPlugin());
        AbstractMultiClustersTestCase.runInParallel(clusterAliases.size(), i -> {
            String clusterAlias = (String)clusterAliases.get(i);
            String clusterName = clusterAlias.equals(LOCAL_CLUSTER) ? "main-cluster" : clusterAlias;
            int numberOfNodes = AbstractMultiClustersTestCase.randomIntBetween(1, 3);
            Collection<Class<? extends Plugin>> nodePlugins = this.nodePlugins(clusterAlias);
            NodeConfigurationSource nodeConfigurationSource = AbstractMultiClustersTestCase.nodeConfigurationSource(this.nodeSettings(), nodePlugins);
            InternalTestCluster cluster = new InternalTestCluster(AbstractMultiClustersTestCase.randomLong(), AbstractMultiClustersTestCase.createTempDir(), true, true, numberOfNodes, numberOfNodes, clusterName, nodeConfigurationSource, 0, clusterName + "-", mockPlugins, Function.identity());
            try {
                cluster.beforeTest(AbstractMultiClustersTestCase.random());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            clusters.put(clusterAlias, cluster);
        });
        clusterGroup = new ClusterGroup(Map.copyOf(clusters));
        this.configureAndConnectsToRemoteClusters();
    }

    @After
    public void assertAfterTest() throws Exception {
        for (InternalTestCluster cluster : this.clusters().values()) {
            cluster.wipe(Set.of());
            cluster.assertAfterTest();
        }
        ESIntegTestCase.awaitGlobalNettyThreadsFinish();
    }

    @AfterClass
    public static void stopClusters() throws IOException {
        IOUtils.close((Closeable)clusterGroup);
        clusterGroup = null;
    }

    protected void disconnectFromRemoteClusters() throws Exception {
        Set<String> clusterAliases = clusterGroup.clusterAliases();
        for (String clusterAlias : clusterAliases) {
            if (clusterAlias.equals(LOCAL_CLUSTER)) continue;
            this.removeRemoteCluster(clusterAlias);
        }
    }

    protected void removeRemoteCluster(String clusterAlias) throws Exception {
        Settings.Builder settings = Settings.builder();
        settings.putNull("cluster.remote." + clusterAlias + ".seeds");
        settings.putNull("cluster.remote." + clusterAlias + ".mode");
        settings.putNull("cluster.remote." + clusterAlias + ".proxy_address");
        this.client().admin().cluster().prepareUpdateSettings(TEST_REQUEST_TIMEOUT, TEST_REQUEST_TIMEOUT).setPersistentSettings(settings).get();
        AbstractMultiClustersTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            for (TransportService transportService : this.cluster(LOCAL_CLUSTER).getInstances(TransportService.class)) {
                AbstractMultiClustersTestCase.assertThat(transportService.getRemoteClusterService().getRegisteredRemoteClusterNames(), Matchers.not((Matcher)Matchers.contains((Object[])new String[]{clusterAlias})));
            }
        }));
    }

    protected void configureAndConnectsToRemoteClusters() throws Exception {
        for (String clusterAlias : clusterGroup.clusterAliases()) {
            if (clusterAlias.equals(LOCAL_CLUSTER)) continue;
            InternalTestCluster cluster = clusterGroup.getCluster(clusterAlias);
            String[] allNodes = cluster.getNodeNames();
            List<String> seedNodes = AbstractMultiClustersTestCase.randomSubsetOf(AbstractMultiClustersTestCase.randomIntBetween(1, Math.min(3, allNodes.length)), allNodes);
            this.configureRemoteCluster(clusterAlias, seedNodes);
        }
    }

    protected void configureRemoteCluster(String clusterAlias, Collection<String> seedNodes) throws Exception {
        List<TransportAddress> seedAddresses = seedNodes.stream().map(node -> {
            TransportService transportService = this.cluster(clusterAlias).getInstance(TransportService.class, (String)node);
            return transportService.boundAddress().publishAddress();
        }).toList();
        this.configureRemoteClusterWithSeedAddresses(clusterAlias, seedAddresses);
    }

    protected void configureRemoteClusterWithSeedAddresses(String clusterAlias, Collection<TransportAddress> seedNodes) throws Exception {
        Settings.Builder builder;
        boolean skipUnavailable;
        String remoteClusterSettingPrefix = "cluster.remote." + clusterAlias + ".";
        Settings.Builder settings = Settings.builder();
        List<String> seedAddresses = seedNodes.stream().map(TransportAddress::toString).toList();
        boolean bl = skipUnavailable = this.skipUnavailableForRemoteClusters().containsKey(clusterAlias) ? this.skipUnavailableForRemoteClusters().get(clusterAlias) : DEFAULT_SKIP_UNAVAILABLE;
        if (AbstractMultiClustersTestCase.randomBoolean()) {
            LOGGER.info("--> use sniff mode with seed [{}], remote nodes [{}]", Collectors.joining(","), seedNodes);
            builder = settings.putNull(remoteClusterSettingPrefix + "proxy_address").put(remoteClusterSettingPrefix + "mode", "sniff").put(remoteClusterSettingPrefix + "seeds", String.join((CharSequence)",", seedAddresses));
        } else {
            String proxyNode = AbstractMultiClustersTestCase.randomFrom(seedAddresses);
            LOGGER.info("--> use proxy node [{}], remote nodes [{}]", (Object)proxyNode, seedNodes);
            builder = settings.putNull(remoteClusterSettingPrefix + "seeds").put(remoteClusterSettingPrefix + "mode", "proxy").put(remoteClusterSettingPrefix + "proxy_address", proxyNode);
        }
        if (skipUnavailable != DEFAULT_SKIP_UNAVAILABLE) {
            builder.put(remoteClusterSettingPrefix + "skip_unavailable", String.valueOf(skipUnavailable));
        }
        builder.build();
        ClusterUpdateSettingsResponse resp = (ClusterUpdateSettingsResponse)this.client().admin().cluster().prepareUpdateSettings(TEST_REQUEST_TIMEOUT, TEST_REQUEST_TIMEOUT).setPersistentSettings(settings).get();
        if (skipUnavailable != DEFAULT_SKIP_UNAVAILABLE) {
            String key = Strings.format((String)"cluster.remote.%s.skip_unavailable", (Object[])new Object[]{clusterAlias});
            AbstractMultiClustersTestCase.assertEquals((Object)String.valueOf(skipUnavailable), (Object)resp.getPersistentSettings().get(key));
        }
        AbstractMultiClustersTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            List remoteConnectionInfos = ((RemoteInfoResponse)this.client().execute(TransportRemoteInfoAction.TYPE, (ActionRequest)new RemoteInfoRequest()).actionGet()).getInfos().stream().filter(c -> c.isConnected() && c.getClusterAlias().equals(clusterAlias)).collect(Collectors.toList());
            AbstractMultiClustersTestCase.assertThat(remoteConnectionInfos, Matchers.not((Matcher)Matchers.empty()));
        }));
    }

    static NodeConfigurationSource nodeConfigurationSource(Settings nodeSettings, final Collection<Class<? extends Plugin>> nodePlugins) {
        final Settings.Builder builder = Settings.builder();
        builder.putList(SettingsBasedSeedHostsProvider.DISCOVERY_SEED_HOSTS_SETTING.getKey(), new String[0]);
        builder.putList(DiscoveryModule.DISCOVERY_SEED_PROVIDERS_SETTING.getKey(), new String[]{"file"});
        builder.put("transport.type", AbstractMultiClustersTestCase.getTestTransportType());
        builder.put(nodeSettings);
        return new NodeConfigurationSource(){

            @Override
            public Settings nodeSettings(int nodeOrdinal, Settings otherSettings) {
                return builder.build();
            }

            @Override
            public Path nodeConfigPath(int nodeOrdinal) {
                return null;
            }

            @Override
            public Collection<Class<? extends Plugin>> nodePlugins() {
                return nodePlugins;
            }
        };
    }

    static class ClusterGroup
    implements Closeable {
        private final Map<String, InternalTestCluster> clusters;

        ClusterGroup(Map<String, InternalTestCluster> clusters) {
            this.clusters = Collections.unmodifiableMap(clusters);
        }

        InternalTestCluster getCluster(String clusterAlias) {
            ESTestCase.assertThat(this.clusters, Matchers.hasKey((Object)clusterAlias));
            return this.clusters.get(clusterAlias);
        }

        Set<String> clusterAliases() {
            return this.clusters.keySet();
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(CloseableTestClusterWrapper.wrap(this.clusters.values()));
        }
    }
}

