/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.index;

import java.util.NavigableSet;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.KnownIndexVersions;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.VersionUtils;

public class IndexVersionUtils {
    private static final NavigableSet<IndexVersion> ALL_VERSIONS = KnownIndexVersions.ALL_VERSIONS;
    private static final NavigableSet<IndexVersion> ALL_WRITE_VERSIONS = KnownIndexVersions.ALL_WRITE_VERSIONS;

    public static NavigableSet<IndexVersion> allReleasedVersions() {
        return ALL_VERSIONS;
    }

    public static IndexVersion getLowestReadCompatibleVersion() {
        return (IndexVersion)ALL_VERSIONS.getFirst();
    }

    public static IndexVersion getLowestWriteCompatibleVersion() {
        return (IndexVersion)ALL_WRITE_VERSIONS.getFirst();
    }

    public static IndexVersion randomVersion() {
        return VersionUtils.randomFrom(LuceneTestCase.random(), ALL_VERSIONS, IndexVersion::fromId);
    }

    public static IndexVersion randomWriteVersion() {
        return VersionUtils.randomFrom(LuceneTestCase.random(), ALL_WRITE_VERSIONS, IndexVersion::fromId);
    }

    public static IndexVersion randomVersion(Set<IndexVersion> ignore) {
        return (IndexVersion)ESTestCase.randomFrom(ALL_VERSIONS.stream().filter(v -> !ignore.contains(v)).collect(Collectors.toList()));
    }

    public static IndexVersion randomVersionBetween(Random random, @Nullable IndexVersion minVersion, @Nullable IndexVersion maxVersion) {
        if (minVersion != null && maxVersion != null && maxVersion.before((VersionId)minVersion)) {
            throw new IllegalArgumentException("maxVersion [" + String.valueOf(maxVersion) + "] cannot be less than minVersion [" + String.valueOf(minVersion) + "]");
        }
        NavigableSet<IndexVersion> versions = IndexVersionUtils.allReleasedVersions();
        if (minVersion != null) {
            if (!versions.contains(minVersion)) {
                throw new IllegalArgumentException("minVersion [" + String.valueOf(minVersion) + "] does not exist.");
            }
            versions = versions.tailSet(minVersion, true);
        }
        if (maxVersion != null) {
            if (!versions.contains(maxVersion)) {
                throw new IllegalArgumentException("maxVersion [" + String.valueOf(maxVersion) + "] does not exist.");
            }
            versions = versions.headSet(maxVersion, true);
        }
        return VersionUtils.randomFrom(random, versions, IndexVersion::fromId);
    }

    public static IndexVersion getPreviousVersion() {
        IndexVersion version = IndexVersionUtils.getPreviousVersion(IndexVersion.current());
        assert (version.before((VersionId)IndexVersion.current()));
        return version;
    }

    public static IndexVersion getPreviousVersion(IndexVersion version) {
        IndexVersion lower = IndexVersionUtils.allReleasedVersions().lower(version);
        if (lower == null) {
            throw new IllegalArgumentException("couldn't find any released versions before [" + String.valueOf(version) + "]");
        }
        return lower;
    }

    public static IndexVersion getPreviousMajorVersion(IndexVersion version) {
        return IndexVersion.getMinimumCompatibleIndexVersion((int)version.id());
    }

    public static IndexVersion getNextVersion(IndexVersion version) {
        IndexVersion higher = IndexVersionUtils.allReleasedVersions().higher(version);
        if (higher == null) {
            throw new IllegalArgumentException("couldn't find any released versions after [" + String.valueOf(version) + "]");
        }
        return higher;
    }

    public static IndexVersion randomCompatibleVersion(Random random) {
        return IndexVersionUtils.randomVersionBetween(random, IndexVersions.MINIMUM_READONLY_COMPATIBLE, IndexVersion.current());
    }

    public static IndexVersion randomCompatibleWriteVersion(Random random) {
        return IndexVersionUtils.randomVersionBetween(random, IndexVersions.MINIMUM_COMPATIBLE, IndexVersion.current());
    }

    public static IndexVersion randomPreviousCompatibleVersion(Random random, IndexVersion version) {
        return IndexVersionUtils.randomVersionBetween(random, IndexVersions.MINIMUM_READONLY_COMPATIBLE, IndexVersionUtils.getPreviousVersion(version));
    }

    public static IndexVersion randomPreviousCompatibleWriteVersion(Random random, IndexVersion version) {
        return IndexVersionUtils.randomVersionBetween(random, IndexVersions.MINIMUM_COMPATIBLE, IndexVersionUtils.getPreviousVersion(version));
    }
}

