/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.http.HttpBody;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.HttpResponse;
import org.elasticsearch.rest.ChunkedRestResponseBodyPart;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class FakeRestRequest
extends RestRequest {
    public FakeRestRequest() {
        this(XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), new FakeHttpRequest(RestRequest.Method.GET, "", (BytesReference)BytesArray.EMPTY, new HashMap<String, List<String>>()), new HashMap<String, String>(), new FakeHttpChannel(null));
    }

    private FakeRestRequest(XContentParserConfiguration config, HttpRequest httpRequest, Map<String, String> params, HttpChannel httpChannel) {
        super(config, params, httpRequest.uri(), httpRequest.getHeaders(), httpRequest, httpChannel);
    }

    public static String requestToString(RestRequest restRequest) {
        return "method=" + String.valueOf(restRequest.method()) + ",path=" + restRequest.rawPath();
    }

    public static class FakeHttpRequest
    implements HttpRequest {
        private final RestRequest.Method method;
        private final String uri;
        private final HttpBody content;
        private final Map<String, List<String>> headers;
        private final Exception inboundException;

        public FakeHttpRequest(RestRequest.Method method, String uri, BytesReference content, Map<String, List<String>> headers) {
            this(method, uri, (HttpBody)(content == null ? HttpBody.empty() : HttpBody.fromBytesReference((BytesReference)content)), headers, null);
        }

        private FakeHttpRequest(RestRequest.Method method, String uri, HttpBody content, Map<String, List<String>> headers, Exception inboundException) {
            this.method = method;
            this.uri = uri;
            this.content = content;
            this.headers = headers;
            this.inboundException = inboundException;
        }

        public RestRequest.Method method() {
            return this.method;
        }

        public String uri() {
            return this.uri;
        }

        public HttpBody body() {
            return this.content;
        }

        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        public List<String> strictCookies() {
            return Collections.emptyList();
        }

        public HttpRequest.HttpVersion protocolVersion() {
            return HttpRequest.HttpVersion.HTTP_1_1;
        }

        public HttpRequest removeHeader(String header) {
            HashMap<String, List<String>> filteredHeaders = new HashMap<String, List<String>>(this.headers);
            filteredHeaders.remove(header);
            return new FakeHttpRequest(this.method, this.uri, this.content, filteredHeaders, this.inboundException);
        }

        public HttpResponse createResponse(RestStatus status, BytesReference unused) {
            final HashMap responseHeaders = new HashMap();
            return new HttpResponse(){

                public void addHeader(String name, String value) {
                    responseHeaders.put(name, value);
                }

                public boolean containsHeader(String name) {
                    return responseHeaders.containsKey(name);
                }
            };
        }

        public HttpResponse createResponse(RestStatus status, ChunkedRestResponseBodyPart firstBodyPart) {
            return this.createResponse(status, (BytesReference)BytesArray.EMPTY);
        }

        public void release() {
        }

        public Exception getInboundException() {
            return this.inboundException;
        }
    }

    public static class FakeHttpChannel
    implements HttpChannel {
        private final InetSocketAddress remoteAddress;
        private final SubscribableListener<Void> closeFuture = new SubscribableListener();

        public FakeHttpChannel(InetSocketAddress remoteAddress) {
            this.remoteAddress = remoteAddress;
        }

        public void sendResponse(HttpResponse response, ActionListener<Void> listener) {
            this.closeFuture.addListener(listener);
        }

        public InetSocketAddress getLocalAddress() {
            return null;
        }

        public InetSocketAddress getRemoteAddress() {
            return this.remoteAddress;
        }

        public void addCloseListener(ActionListener<Void> listener) {
            this.closeFuture.addListener(listener);
        }

        public boolean isOpen() {
            return true;
        }

        public void close() {
            this.closeFuture.onResponse(null);
        }
    }

    public static class Builder {
        private final XContentParserConfiguration parserConfig;
        private Map<String, List<String>> headers = new HashMap<String, List<String>>();
        private Map<String, String> params = new HashMap<String, String>();
        private HttpBody content = HttpBody.empty();
        private String path = "/";
        private RestRequest.Method method = RestRequest.Method.GET;
        private InetSocketAddress address = null;
        private Exception inboundException;

        public Builder(NamedXContentRegistry registry) {
            this.parserConfig = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE).withRegistry(registry);
        }

        public Builder withHeaders(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder withParams(Map<String, String> params) {
            this.params = params;
            return this;
        }

        public Builder withContent(BytesReference contentBytes, XContentType xContentType) {
            this.content = HttpBody.fromBytesReference((BytesReference)contentBytes);
            if (xContentType != null) {
                this.headers.put("Content-Type", Collections.singletonList(xContentType.mediaType()));
            }
            return this;
        }

        public Builder withBody(HttpBody body) {
            this.content = body;
            return this;
        }

        public Builder withPath(String path) {
            this.path = path;
            return this;
        }

        public Builder withMethod(RestRequest.Method method) {
            this.method = method;
            return this;
        }

        public Builder withRemoteAddress(InetSocketAddress remoteAddress) {
            this.address = remoteAddress;
            return this;
        }

        public Builder withInboundException(Exception exception) {
            this.inboundException = exception;
            return this;
        }

        public FakeRestRequest build() {
            FakeHttpRequest fakeHttpRequest = new FakeHttpRequest(this.method, this.path, this.content, this.headers, this.inboundException);
            return new FakeRestRequest(this.parserConfig, fakeHttpRequest, this.params, new FakeHttpChannel(this.address));
        }
    }
}

