/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Queue;
import java.util.function.Predicate;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.repositories.blobstore.ESMockAPIBasedRepositoryIntegTestCase;
import org.elasticsearch.rest.RestStatus;

@SuppressForbidden(reason="We use HttpServer for the fixtures")
public class ResponseInjectingHttpHandler
implements ESMockAPIBasedRepositoryIntegTestCase.DelegatingHttpHandler {
    private final HttpHandler delegate;
    private final Queue<RequestHandler> requestHandlerQueue;

    public ResponseInjectingHttpHandler(Queue<RequestHandler> requestHandlerQueue, HttpHandler delegate) {
        this.delegate = delegate;
        this.requestHandlerQueue = requestHandlerQueue;
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        RequestHandler nextHandler = this.requestHandlerQueue.peek();
        if (nextHandler != null && nextHandler.matchesRequest(exchange)) {
            this.requestHandlerQueue.poll().writeResponse(exchange, this.delegate);
        } else {
            this.delegate.handle(exchange);
        }
    }

    @Override
    public HttpHandler getDelegate() {
        return this.delegate;
    }

    @FunctionalInterface
    @SuppressForbidden(reason="We use HttpServer for the fixtures")
    public static interface RequestHandler {
        public void writeResponse(HttpExchange var1, HttpHandler var2) throws IOException;

        default public boolean matchesRequest(HttpExchange exchange) {
            return true;
        }
    }

    @SuppressForbidden(reason="We use HttpServer for the fixtures")
    public static class FixedRequestHandler
    implements RequestHandler {
        private final RestStatus status;
        private final String responseBody;
        private final Predicate<HttpExchange> requestMatcher;

        public FixedRequestHandler(RestStatus status) {
            this(status, null, req -> true);
        }

        public FixedRequestHandler(RestStatus status, String responseBody, Predicate<HttpExchange> requestMatcher) {
            this.status = status;
            this.responseBody = responseBody;
            this.requestMatcher = requestMatcher;
        }

        @Override
        public boolean matchesRequest(HttpExchange exchange) {
            return this.requestMatcher.test(exchange);
        }

        @Override
        public void writeResponse(HttpExchange exchange, HttpHandler delegateHandler) throws IOException {
            if (this.responseBody != null) {
                byte[] responseBytes = this.responseBody.getBytes(StandardCharsets.UTF_8);
                exchange.sendResponseHeaders(this.status.getStatus(), responseBytes.length == 0 ? -1L : (long)responseBytes.length);
                exchange.getResponseBody().write(responseBytes);
            } else {
                exchange.sendResponseHeaders(this.status.getStatus(), -1L);
            }
        }
    }
}

