/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import org.apache.lucene.index.IndexableField;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MapperTestCase;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.NumberFieldMapperTests;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.TimeSeriesRoutingHashFieldMapper;
import org.elasticsearch.xcontent.XContentBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class WholeNumberFieldMapperTests
extends NumberFieldMapperTests {
    protected void testDecimalCoerce() throws IOException {
        DocumentMapper mapper = this.createDocumentMapper(WholeNumberFieldMapperTests.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping)));
        ParsedDocument doc = mapper.parse(WholeNumberFieldMapperTests.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("field", "7.89"))));
        List fields = doc.rootDoc().getFields("field");
        IndexableField pointField = (IndexableField)fields.get(0);
        WholeNumberFieldMapperTests.assertEquals((double)7.0, (double)pointField.numericValue().doubleValue(), (double)0.0);
    }

    @Override
    public void testDimension() throws IOException {
        MapperService mapperService = this.createMapperService(WholeNumberFieldMapperTests.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> this.minimalMapping((XContentBuilder)b))));
        NumberFieldMapper.NumberFieldType ft = (NumberFieldMapper.NumberFieldType)mapperService.fieldType("field");
        WholeNumberFieldMapperTests.assertFalse((boolean)ft.isDimension());
        this.assertDimension(true, NumberFieldMapper.NumberFieldType::isDimension);
        this.assertDimension(false, NumberFieldMapper.NumberFieldType::isDimension);
    }

    public void testDimensionIndexedAndDocvalues() {
        Exception e = (Exception)WholeNumberFieldMapperTests.expectThrows(MapperParsingException.class, () -> this.createDocumentMapper(WholeNumberFieldMapperTests.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("time_series_dimension", true).field("index", false).field("doc_values", false);
        }))));
        WholeNumberFieldMapperTests.assertThat(e.getCause().getMessage(), Matchers.containsString((String)"Field [time_series_dimension] requires that [index] and [doc_values] are true"));
        e = (Exception)WholeNumberFieldMapperTests.expectThrows(MapperParsingException.class, () -> this.createDocumentMapper(WholeNumberFieldMapperTests.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("time_series_dimension", true).field("index", true).field("doc_values", false);
        }))));
        WholeNumberFieldMapperTests.assertThat(e.getCause().getMessage(), Matchers.containsString((String)"Field [time_series_dimension] requires that [index] and [doc_values] are true"));
        e = (Exception)WholeNumberFieldMapperTests.expectThrows(MapperParsingException.class, () -> this.createDocumentMapper(WholeNumberFieldMapperTests.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("time_series_dimension", true).field("index", false).field("doc_values", true);
        }))));
        WholeNumberFieldMapperTests.assertThat(e.getCause().getMessage(), Matchers.containsString((String)"Field [time_series_dimension] requires that [index] and [doc_values] are true"));
    }

    public void testDimensionMultiValuedFieldTSDB() throws IOException {
        DocumentMapper mapper = this.createDocumentMapper(WholeNumberFieldMapperTests.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("time_series_dimension", true);
        })), IndexMode.TIME_SERIES);
        ParsedDocument doc = mapper.parse(WholeNumberFieldMapperTests.source(null, (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.array("field", new Object[]{this.randomNumber(), this.randomNumber(), this.randomNumber()});
            b.field("@timestamp", (Object)Instant.now());
        }), TimeSeriesRoutingHashFieldMapper.encode((int)WholeNumberFieldMapperTests.randomInt())));
        WholeNumberFieldMapperTests.assertThat(((LuceneDocument)doc.docs().get(0)).getFields("field"), Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(1))));
    }

    public void testDimensionMultiValuedFieldNonTSDB() throws IOException {
        DocumentMapper mapper = this.createDocumentMapper(WholeNumberFieldMapperTests.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("time_series_dimension", true);
        })), WholeNumberFieldMapperTests.randomFrom(IndexMode.STANDARD, IndexMode.LOGSDB));
        ParsedDocument doc = mapper.parse(WholeNumberFieldMapperTests.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.array("field", new Object[]{this.randomNumber(), this.randomNumber(), this.randomNumber()});
            b.field("@timestamp", (Object)Instant.now());
        })));
        WholeNumberFieldMapperTests.assertThat(((LuceneDocument)doc.docs().get(0)).getFields("field"), Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(1))));
    }

    public void testMetricAndDimension() {
        Exception e = (Exception)WholeNumberFieldMapperTests.expectThrows(MapperParsingException.class, () -> this.createDocumentMapper(WholeNumberFieldMapperTests.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("time_series_metric", "counter").field("time_series_dimension", true);
        }))));
        WholeNumberFieldMapperTests.assertThat(e.getCause().getMessage(), Matchers.containsString((String)"Field [time_series_dimension] cannot be set in conjunction with field [time_series_metric]"));
    }

    @Override
    protected void registerParameters(MapperTestCase.ParameterChecker checker) throws IOException {
        super.registerParameters(checker);
        this.registerDimensionChecks(checker);
    }

    @Override
    protected MapperTestCase.SyntheticSourceSupport syntheticSourceSupport(boolean ignoreMalformed) {
        return new NumberFieldMapperTests.NumberSyntheticSourceSupport(Number::longValue, ignoreMalformed);
    }

    @Override
    protected MapperTestCase.SyntheticSourceSupport syntheticSourceSupportForKeepTests(boolean ignoreMalformed, Mapper.SourceKeepMode sourceKeepMode) {
        return new NumberFieldMapperTests.NumberSyntheticSourceSupportForKeepTests(this, Number::longValue, ignoreMalformed, sourceKeepMode);
    }
}

