/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ingest.IngestDocument;

public final class IngestDocumentMatcher {
    private IngestDocumentMatcher() {
    }

    public static void assertIngestDocument(IngestDocument expected, IngestDocument actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            throw new AssertionError((Object)("Expected [" + String.valueOf(expected) + "] but received [" + String.valueOf(actual) + "]."));
        }
        if (!(IngestDocumentMatcher.deepEquals(expected.getIngestMetadata(), actual.getIngestMetadata(), true) && IngestDocumentMatcher.deepEquals(expected.getSourceAndMetadata(), actual.getSourceAndMetadata(), false))) {
            throw new AssertionError((Object)("Expected [" + String.valueOf(expected) + "] but received [" + String.valueOf(actual) + "]."));
        }
    }

    private static boolean deepEquals(Object a, Object b, boolean isIngestMeta) {
        if (a instanceof Map) {
            Map mapA = (Map)a;
            if (!(b instanceof Map)) {
                return false;
            }
            Map mapB = (Map)b;
            if (mapA.size() != mapB.size()) {
                return false;
            }
            for (Map.Entry entry : mapA.entrySet()) {
                Object key = entry.getKey();
                if (isIngestMeta && "timestamp".equals(key) || IngestDocumentMatcher.deepEquals(entry.getValue(), mapB.get(key), false)) continue;
                return false;
            }
            return true;
        }
        if (a instanceof List) {
            List listA = (List)a;
            if (!(b instanceof List)) {
                return false;
            }
            List listB = (List)b;
            int countA = listA.size();
            if (countA != listB.size()) {
                return false;
            }
            for (int i = 0; i < countA; ++i) {
                Object value = listA.get(i);
                if (IngestDocumentMatcher.deepEquals(value, listB.get(i), false)) continue;
                return false;
            }
            return true;
        }
        return Objects.deepEquals(a, b);
    }
}

