/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ingest.DeletePipelineRequest;
import org.elasticsearch.action.ingest.DeletePipelineTransportAction;
import org.elasticsearch.action.ingest.PutPipelineRequest;
import org.elasticsearch.action.ingest.PutPipelineTransportAction;
import org.elasticsearch.action.ingest.SimulatePipelineRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.IsAcknowledgedSupplier;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;

public class IngestPipelineTestUtils {
    private static final Logger logger = LogManager.getLogger(IngestPipelineTestUtils.class);

    private IngestPipelineTestUtils() {
    }

    public static PutPipelineRequest putJsonPipelineRequest(String id, BytesReference source) {
        return new PutPipelineRequest(ESTestCase.TEST_REQUEST_TIMEOUT, ESTestCase.TEST_REQUEST_TIMEOUT, id, source, XContentType.JSON);
    }

    public static PutPipelineRequest putJsonPipelineRequest(String id, String jsonString) {
        return IngestPipelineTestUtils.putJsonPipelineRequest(id, (BytesReference)new BytesArray(jsonString));
    }

    public static void putJsonPipeline(ElasticsearchClient client, String id, BytesReference source) {
        ElasticsearchAssertions.assertAcked((IsAcknowledgedSupplier)ESTestCase.safeGet(client.execute(PutPipelineTransportAction.TYPE, (ActionRequest)IngestPipelineTestUtils.putJsonPipelineRequest(id, source))));
    }

    public static void putJsonPipeline(ElasticsearchClient client, String id, String jsonString) {
        IngestPipelineTestUtils.putJsonPipeline(client, id, (BytesReference)new BytesArray(jsonString));
    }

    public static void putJsonPipeline(ElasticsearchClient client, String id, ToXContentFragment toXContent) throws IOException {
        try (XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();){
            xContentBuilder.startObject();
            toXContent.toXContent(xContentBuilder, ToXContent.EMPTY_PARAMS);
            xContentBuilder.endObject();
            IngestPipelineTestUtils.putJsonPipeline(client, id, BytesReference.bytes((XContentBuilder)xContentBuilder));
        }
    }

    public static void deletePipelinesIgnoringExceptions(ElasticsearchClient client, Iterable<String> ids) {
        for (final String id : ids) {
            ESTestCase.safeAwait(l -> client.execute(DeletePipelineTransportAction.TYPE, (ActionRequest)new DeletePipelineRequest(ESTestCase.TEST_REQUEST_TIMEOUT, ESTestCase.TEST_REQUEST_TIMEOUT, id), (ActionListener)new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                    logger.info("delete pipeline [{}] success [acknowledged={}]", new Object[]{id, acknowledgedResponse.isAcknowledged()});
                    l.onResponse(null);
                }

                public void onFailure(Exception e) {
                    logger.warn(Strings.format((String)"delete pipeline [%s] failure", (Object[])new Object[]{id}), (Throwable)e);
                    l.onResponse(null);
                }
            }));
        }
    }

    public static SimulatePipelineRequest jsonSimulatePipelineRequest(String jsonString) {
        return IngestPipelineTestUtils.jsonSimulatePipelineRequest((BytesReference)new BytesArray(jsonString));
    }

    public static SimulatePipelineRequest jsonSimulatePipelineRequest(BytesReference jsonBytes) {
        return new SimulatePipelineRequest(ReleasableBytesReference.wrap((BytesReference)jsonBytes), XContentType.JSON);
    }
}

