/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.section;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.test.rest.yaml.section.Assertion;
import org.elasticsearch.test.rest.yaml.section.ParserUtils;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParser;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class ContainsAssertion
extends Assertion {
    private static final Logger logger = LogManager.getLogger(ContainsAssertion.class);

    public static ContainsAssertion parse(XContentParser parser) throws IOException {
        XContentLocation location = parser.getTokenLocation();
        Tuple<String, Object> stringObjectTuple = ParserUtils.parseTuple(parser);
        return new ContainsAssertion(location, (String)stringObjectTuple.v1(), stringObjectTuple.v2());
    }

    public ContainsAssertion(XContentLocation location, String field, Object expectedValue) {
        super(location, field, expectedValue);
    }

    @Override
    protected void doAssert(Object actualValue, Object expectedValue) {
        if (expectedValue instanceof Map && actualValue instanceof List) {
            logger.trace("assert that [{}] contains [{}]", actualValue, expectedValue);
            Map expectedMap = (Map)expectedValue;
            List actualList = (List)actualValue;
            List actualValues = actualList.stream().filter(each -> each instanceof Map).map(each -> (Map)each).filter(each -> each.keySet().containsAll(expectedMap.keySet())).collect(Collectors.toList());
            Assert.assertThat((String)(this.getField() + " expected to be a list with at least one object that has keys: " + expectedMap.keySet() + " but it was " + actualList), actualValues, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
            Assert.assertTrue((String)(this.getField() + " expected to be a list with at least on object that matches " + expectedMap + " but was " + actualValues), (boolean)actualValues.stream().anyMatch(each -> each.entrySet().containsAll(expectedMap.entrySet())));
        } else {
            Assert.fail((String)"'contains' only supports checking an object against a list of objects");
        }
    }
}

