/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.section;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.test.rest.yaml.section.Assertion;
import org.elasticsearch.test.rest.yaml.section.ParserUtils;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParser;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class LessThanOrEqualToAssertion
extends Assertion {
    private static final Logger logger = LogManager.getLogger(LessThanOrEqualToAssertion.class);

    public static LessThanOrEqualToAssertion parse(XContentParser parser) throws IOException {
        XContentLocation location = parser.getTokenLocation();
        Tuple<String, Object> stringObjectTuple = ParserUtils.parseTuple(parser);
        if (!(stringObjectTuple.v2() instanceof Comparable)) {
            throw new IllegalArgumentException("lte section can only be used with objects that support natural ordering, found " + stringObjectTuple.v2().getClass().getSimpleName());
        }
        return new LessThanOrEqualToAssertion(location, (String)stringObjectTuple.v1(), stringObjectTuple.v2());
    }

    public LessThanOrEqualToAssertion(XContentLocation location, String field, Object expectedValue) {
        super(location, field, expectedValue);
    }

    @Override
    protected void doAssert(Object actualValue, Object expectedValue) {
        logger.trace("assert that [{}] is less than or equal to [{}] (field: [{}])", actualValue, expectedValue, (Object)this.getField());
        Assert.assertThat((String)("value of [" + this.getField() + "] is not comparable (got [" + this.safeClass(actualValue) + "])"), (Object)actualValue, (Matcher)Matchers.instanceOf(Comparable.class));
        Assert.assertThat((String)("expected value of [" + this.getField() + "] is not comparable (got [" + expectedValue.getClass() + "])"), (Object)expectedValue, (Matcher)Matchers.instanceOf(Comparable.class));
        if (actualValue instanceof Long && expectedValue instanceof Integer) {
            expectedValue = (long)((Integer)expectedValue).intValue();
        }
        try {
            Assert.assertThat((String)this.errorMessage(), (Object)((Comparable)actualValue), (Matcher)Matchers.lessThanOrEqualTo((Comparable)((Comparable)expectedValue)));
        }
        catch (ClassCastException e) {
            throw new AssertionError("cast error while checking (" + this.errorMessage() + "): " + e, e);
        }
    }

    private String errorMessage() {
        return "field [" + this.getField() + "] is not less than or equal to [" + this.getExpectedValue() + "]";
    }
}

