/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.carrier;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import org.elastos.carrier.Base58;
import org.elastos.carrier.CarrierHandler;
import org.elastos.carrier.ConnectionStatus;
import org.elastos.carrier.FriendInfo;
import org.elastos.carrier.FriendInviteResponseHandler;
import org.elastos.carrier.FriendMessageReceiptHandler;
import org.elastos.carrier.FriendsIterator;
import org.elastos.carrier.Group;
import org.elastos.carrier.Log;
import org.elastos.carrier.PresenceStatus;
import org.elastos.carrier.UserInfo;
import org.elastos.carrier.exceptions.CarrierException;

public class Carrier {
    private Charset UTF8 = Charset.forName("UTF-8");
    public static final int MAX_ID_LEN = 45;
    public static final int MAX_KEY_LEN = 45;
    public static final int CARRIER_MAX_USER_NAME_LEN = 0x500000;
    private static final String TAG = "CarrierCore";
    private Thread carrierThread;
    private CarrierHandler handler;
    private long nativeCookie = 0L;
    private boolean didKill = false;
    private Hashtable<String, Group> groups = new Hashtable();

    private native boolean native_init(Options var1, Callbacks var2);

    private native boolean native_run(int var1);

    private native void native_kill();

    private native String get_address();

    private native String get_node_id();

    private native boolean set_nospam(byte[] var1);

    private native byte[] get_nospam();

    private native boolean set_self_info(UserInfo var1);

    private native UserInfo get_self_info();

    private native boolean set_presence(PresenceStatus var1);

    private native PresenceStatus get_presence();

    private native boolean is_ready();

    private native boolean get_friends(FriendsIterator var1, Object var2);

    private native FriendInfo get_friend(String var1);

    private native boolean label_friend(String var1, String var2);

    private native boolean is_friend(String var1);

    private native boolean add_friend(String var1, String var2);

    private native boolean accept_friend(String var1);

    private native boolean remove_friend(String var1);

    private native long send_message_with_receipt(String var1, byte[] var2, FriendMessageReceiptHandler var3);

    private native boolean friend_invite(String var1, String var2, FriendInviteResponseHandler var3);

    private native boolean reply_friend_invite(String var1, int var2, String var3, String var4);

    private static native int get_error_code();

    private static native String get_version();

    private Carrier(CarrierHandler handler) {
        this.handler = handler;
    }

    public static String getVersion() {
        return Carrier.get_version();
    }

    public static boolean isValidId(String id) {
        try {
            return Base58.decode(id).length == 32;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isValidAddress(String address) {
        try {
            return Base58.decode(address).length == 38;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getIdFromAddress(String address) {
        try {
            byte[] addr = Base58.decode(address);
            if (addr.length != 38) {
                return null;
            }
            return Base58.encode(Arrays.copyOf(addr, 32));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Carrier createInstance(Options options, CarrierHandler handler) throws CarrierException {
        if (options == null || handler == null) {
            throw new IllegalArgumentException();
        }
        Carrier tmp = new Carrier(handler);
        Callbacks callbacks = new Callbacks();
        if (!tmp.native_init(options, callbacks)) {
            throw CarrierException.fromErrorCode(Carrier.get_error_code());
        }
        Log.i(TAG, "Carrier node instance created");
        return tmp;
    }

    protected void finalize() throws Throwable {
        this.kill();
        super.finalize();
    }

    public void start(final int iterateInterval) {
        if (this.carrierThread == null) {
            this.carrierThread = new Thread(){

                @Override
                public void run() {
                    Log.i(Carrier.TAG, "Native carrier node started");
                    if (!Carrier.this.native_run(iterateInterval)) {
                        Log.e(Carrier.TAG, "Native carrier node started error(" + Carrier.get_error_code() + ")");
                        return;
                    }
                    Log.i(Carrier.TAG, "Native carrier node stoped");
                }
            };
            this.carrierThread.start();
        }
    }

    public synchronized void kill() {
        if (!this.didKill) {
            Log.i(TAG, "Killing Carrier node instance ...");
            this.native_kill();
            this.didKill = true;
            if (this.carrierThread != null) {
                try {
                    this.carrierThread.join();
                }
                catch (Exception e) {
                    Log.i(TAG, "Join carrier thread is interrupted");
                }
                this.carrierThread = null;
            }
            Log.i(TAG, "Carrier instance killed");
        }
    }

    public String getAddress() throws CarrierException {
        String address = this.get_address();
        if (address == null) {
            throw CarrierException.fromErrorCode(Carrier.get_error_code());
        }
        Log.d(TAG, "Current carrier address: " + address);
        return address;
    }

    public String getNodeId() throws CarrierException {
        String nodeId = this.get_node_id();
        if (nodeId == null) {
            throw CarrierException.fromErrorCode(Carrier.get_error_code());
        }
        Log.d(TAG, "Current carrier NodeId: " + nodeId);
        return nodeId;
    }

    public String getUserId() throws CarrierException {
        String userId = this.getNodeId();
        Log.d(TAG, "Current carrier userId: " + userId);
        return userId;
    }

    public void setNospam(int nospam) throws CarrierException {
        byte[] value = ByteBuffer.allocate(4).putInt(nospam).array();
        if (!this.set_nospam(value)) {
            throw CarrierException.fromErrorCode(Carrier.get_error_code());
        }
    }

    public int getNospam() throws CarrierException {
        byte[] nospam = this.get_nospam();
        if (nospam == null) {
            throw CarrierException.fromErrorCode(Carrier.get_error_code());
        }
        return ByteBuffer.wrap(nospam).getInt();
    }

    public void setSelfInfo(UserInfo userinfo) throws CarrierException {
        if (userinfo == null) {
            throw new IllegalArgumentException();
        }
        if (!this.set_self_info(userinfo)) {
            throw CarrierException.fromErrorCode(Carrier.get_error_code());
        }
        Log.d(TAG, "Current user information updated");
    }

    public UserInfo getSelfInfo() throws CarrierException {
        UserInfo userInfo = this.get_self_info();
        if (userInfo == null) {
            throw CarrierException.fromErrorCode(Carrier.get_error_code());
        }
        Log.d(TAG, "Current user information: " + userInfo);
        return userInfo;
    }

    public void setPresence(PresenceStatus presence) throws CarrierException {
        if (presence == null) {
            throw new IllegalArgumentException();
        }
        if (!this.set_presence(presence)) {
            throw CarrierException.fromErrorCode(Carrier.get_error_code());
        }
        Log.d(TAG, "Current presence updated to be " + (Object)((Object)presence));
    }

    public PresenceStatus getPresence() throws CarrierException {
        PresenceStatus presence = this.get_presence();
        if (presence == null) {
            throw CarrierException.fromErrorCode(Carrier.get_error_code());
        }
        Log.d(TAG, "Current presence " + (Object)((Object)presence));
        return presence;
    }

    public boolean isReady() {
        return this.is_ready();
    }

    public List<FriendInfo> getFriends() throws CarrierException {
        ArrayList<FriendInfo> friends = new ArrayList<FriendInfo>();
        boolean result = this.get_friends(new FriendsIterator(){

            @Override
            public boolean onIterated(FriendInfo info, Object context) {
                List friends = (List)context;
                if (info != null) {
                    friends.add(info);
                }
                return true;
            }
        }, friends);
        if (!result) {
            throw CarrierException.fromErrorCode(Carrier.get_error_code());
        }
        Log.d(TAG, "Current user's friends listed below: +++++>>");
        for (FriendInfo friend : friends) {
            Log.d(TAG, friend.toString());
        }
        Log.d(TAG, "<<++++++++");
        return friends;
    }

    public FriendInfo getFriend(String userId) throws CarrierException {
        if (userId == null || userId.length() == 0) {
            throw new IllegalArgumentException();
        }
        FriendInfo friendInfo = this.get_friend(userId);
        if (friendInfo == null) {
            throw CarrierException.fromErrorCode(Carrier.get_error_code());
        }
        Log.d(TAG, "The information of friend " + userId + ": " + friendInfo);
        return friendInfo;
    }

    public void labelFriend(String userId, String label) throws CarrierException {
        if (userId == null || userId.length() == 0 || label == null || label.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (!this.label_friend(userId, label)) {
            throw CarrierException.fromErrorCode(Carrier.get_error_code());
        }
        Log.d(TAG, "Label friend " + userId + " as  " + label);
    }

    public boolean isFriend(String userId) throws CarrierException {
        if (userId == null || userId.length() == 0) {
            throw new IllegalArgumentException();
        }
        return this.is_friend(userId);
    }

    public void addFriend(String address, String hello) throws CarrierException {
        if (address == null || address.length() == 0) {
            throw new IllegalArgumentException();
        }
        Log.d(TAG, "Attempt to add " + address + " to be friend by greeting with (" + hello + ")");
        if (!this.add_friend(address, hello)) {
            throw CarrierException.fromErrorCode(Carrier.get_error_code());
        }
        Log.d(TAG, "Added friend " + address + " success");
    }

    public void acceptFriend(String userId) throws CarrierException {
        if (userId == null || userId.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (!this.accept_friend(userId)) {
            throw CarrierException.fromErrorCode(Carrier.get_error_code());
        }
        Log.d(TAG, "Accepted friend request from " + userId);
    }

    public void removeFriend(String userId) throws CarrierException {
        if (userId == null || userId.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (!this.remove_friend(userId)) {
            throw CarrierException.fromErrorCode(Carrier.get_error_code());
        }
        Log.d(TAG, "Friend " + userId + " was removed");
    }

    public long sendFriendMessage(String to, String message, FriendMessageReceiptHandler handler) throws CarrierException {
        if (to == null || to.length() == 0 || message == null || message.length() == 0 || message.length() >= 0x500000) {
            throw new IllegalArgumentException();
        }
        return this.sendFriendMessage(to, message.getBytes(this.UTF8), handler);
    }

    public long sendFriendMessage(String to, byte[] message, FriendMessageReceiptHandler handler) throws CarrierException {
        if (to == null || to.length() == 0 || message == null || message.length == 0 || handler == null) {
            throw new IllegalArgumentException();
        }
        long ret = this.send_message_with_receipt(to, message, handler);
        if (ret < 0L) {
            throw CarrierException.fromErrorCode(Carrier.get_error_code());
        }
        Log.d(TAG, "Send " + message.length + " bytes message with receipt ack to friend " + to);
        return ret;
    }

    public void inviteFriend(String to, String data, FriendInviteResponseHandler handler) throws CarrierException {
        if (to == null || to.length() == 0 || data == null || data.length() == 0 || handler == null) {
            throw new IllegalArgumentException();
        }
        Log.d(TAG, "Inviting friend " + to + "with greet data " + data);
        if (!this.friend_invite(to, data, handler)) {
            throw CarrierException.fromErrorCode(Carrier.get_error_code());
        }
        Log.d(TAG, "Send friend invite request to " + to);
    }

    public void replyFriendInvite(String to, int status, String reason, String data) throws CarrierException {
        if (to == null || to.length() == 0 || status != 0 && reason == null) {
            throw new IllegalArgumentException();
        }
        if (status == 0) {
            Log.d(TAG, String.format("Attempt to confirm friend invite to %s with data [%s]", to, data));
        } else {
            Log.d(TAG, String.format("Attempt to refuse friend invite to %s with status %d,and reason %s", to, status, reason));
        }
        if (!this.reply_friend_invite(to, status, reason, data)) {
            throw CarrierException.fromErrorCode(Carrier.get_error_code());
        }
        if (status == 0) {
            Log.d(TAG, String.format("Confirmed friend invite to %s with data [%s]", to, data));
        } else {
            Log.d(TAG, String.format("Refused friend invite to %s with status %d and reason %s", to, status, reason));
        }
    }

    public Group newGroup() throws CarrierException {
        Group group = new Group(this);
        this.groups.put(group.getId(), group);
        return group;
    }

    public Group groupJoin(String friendId, byte[] cookie) throws CarrierException {
        if (friendId == null || cookie == null || friendId.length() == 0 || cookie.length == 0) {
            throw new IllegalArgumentException();
        }
        Group group = new Group(this, friendId, cookie);
        this.groups.put(group.getId(), group);
        return group;
    }

    public void groupLeave(Group group) throws CarrierException {
        if (group == null) {
            throw new IllegalArgumentException();
        }
        Group tmp = this.groups.remove(group.getId());
        if (tmp == null) {
            throw new IllegalArgumentException();
        }
        try {
            group.leave();
        }
        catch (CarrierException e) {
            this.groups.put(group.getId(), group);
            throw e;
        }
    }

    public Collection<Group> getGroups() {
        return Collections.unmodifiableCollection(this.groups.values());
    }

    static {
        System.loadLibrary("carrierjni");
    }

    public static class Options {
        private String persistentLocation;
        private byte[] secretKey;
        private boolean udpEnabled;
        private List<BootstrapNode> bootstrapNodes;
        private List<ExpressNode> expressNodes;

        public Options setPersistentLocation(String persistentLocation) {
            this.persistentLocation = persistentLocation;
            return this;
        }

        public String getPersistentLocation() {
            return this.persistentLocation;
        }

        public Options setSecretKey(byte[] secretKey) {
            if (secretKey != null && secretKey.length != 32) {
                throw new RuntimeException("Bad secret key length, the length must be 32.");
            }
            this.secretKey = secretKey;
            return this;
        }

        public byte[] getSecretKey() {
            return this.secretKey;
        }

        public Options setUdpEnabled(boolean udpEnabled) {
            this.udpEnabled = udpEnabled;
            return this;
        }

        public boolean getUdpEnabled() {
            return this.udpEnabled;
        }

        public Options setBootstrapNodes(List<BootstrapNode> bootstrapNodes) {
            this.bootstrapNodes = bootstrapNodes;
            return this;
        }

        public List<BootstrapNode> getBootstrapNodes() {
            return this.bootstrapNodes;
        }

        public Options setExpressNodes(List<ExpressNode> expressNodes) {
            this.expressNodes = expressNodes;
            return this;
        }

        public List<ExpressNode> getExpressNodes() {
            return this.expressNodes;
        }

        public static class ExpressNode {
            private String ipv4;
            private String port;
            private String publicKey;

            public ExpressNode setIpv4(String ipv4) {
                this.ipv4 = ipv4;
                return this;
            }

            public String getIpv4() {
                return this.ipv4;
            }

            public ExpressNode setPort(String port) {
                this.port = port;
                return this;
            }

            public String getPort() {
                return this.port;
            }

            public ExpressNode setPublicKey(String publicKey) {
                this.publicKey = publicKey;
                return this;
            }

            public String getPublicKey() {
                return this.publicKey;
            }
        }

        public static class BootstrapNode {
            private String ipv4;
            private String ipv6;
            private String port;
            private String publicKey;

            public BootstrapNode setIpv4(String ipv4) {
                this.ipv4 = ipv4;
                return this;
            }

            public String getIpv4() {
                return this.ipv4;
            }

            public BootstrapNode setIpv6(String ipv6) {
                this.ipv6 = ipv6;
                return this;
            }

            public String getIpv6() {
                return this.ipv6;
            }

            public BootstrapNode setPort(String port) {
                this.port = port;
                return this;
            }

            public String getPort() {
                return this.port;
            }

            public BootstrapNode setPublicKey(String publicKey) {
                this.publicKey = publicKey;
                return this;
            }

            public String getPublicKey() {
                return this.publicKey;
            }
        }
    }

    private static class Callbacks {
        private List<FriendInfo> friends;

        private Callbacks() {
        }

        void onIdle(Carrier carrier) {
            carrier.handler.onIdle(carrier);
        }

        void onConnection(Carrier carrier, ConnectionStatus status) {
            carrier.handler.onConnection(carrier, status);
        }

        void onReady(Carrier carrier) {
            carrier.handler.onReady(carrier);
        }

        void onSelfInfoChanged(Carrier carrier, UserInfo userInfo) {
            carrier.handler.onSelfInfoChanged(carrier, userInfo);
        }

        boolean onFriendsIterated(Carrier carrier, FriendInfo info) {
            if (this.friends == null) {
                this.friends = new ArrayList<FriendInfo>();
            }
            if (info != null) {
                this.friends.add(info);
            } else {
                carrier.handler.onFriends(carrier, this.friends);
                this.friends = null;
            }
            return true;
        }

        void onFriendConnection(Carrier carrier, String friendid, ConnectionStatus status) {
            carrier.handler.onFriendConnection(carrier, friendid, status);
        }

        void onFriendInfoChanged(Carrier carrier, String friendId, FriendInfo info) {
            carrier.handler.onFriendInfoChanged(carrier, friendId, info);
        }

        void onFriendPresence(Carrier carrier, String friendId, PresenceStatus presence) {
            carrier.handler.onFriendPresence(carrier, friendId, presence);
        }

        void onFriendRequest(Carrier carrier, String userId, UserInfo info, String hello) {
            carrier.handler.onFriendRequest(carrier, userId, info, hello);
        }

        void onFriendAdded(Carrier carrier, FriendInfo friendInfo) {
            carrier.handler.onFriendAdded(carrier, friendInfo);
        }

        void onFriendRemoved(Carrier carrier, String friendId) {
            carrier.handler.onFriendRemoved(carrier, friendId);
        }

        void onFriendMessage(Carrier carrier, String from, byte[] message, Date timestamp, boolean isOffline) {
            carrier.handler.onFriendMessage(carrier, from, message, timestamp, isOffline);
        }

        void onFriendInviteRequest(Carrier carrier, String from, String data) {
            carrier.handler.onFriendInviteRequest(carrier, from, data);
        }

        void onGroupInvite(Carrier carrier, String from, byte[] cookie) {
            carrier.handler.onGroupInvite(carrier, from, cookie);
        }

        void onGroupConnected(Carrier carrier, String groupId) {
            Group group = (Group)carrier.groups.get(groupId);
            if (group != null) {
                carrier.handler.onGroupConnected(group);
            }
        }

        void onGroupMessage(Carrier carrier, String groupId, String from, byte[] message) {
            Group group = (Group)carrier.groups.get(groupId);
            if (group != null) {
                carrier.handler.onGroupMessage(group, from, message);
            }
        }

        void onGroupTitle(Carrier carrier, String groupId, String from, String title) {
            Group group = (Group)carrier.groups.get(groupId);
            if (group != null) {
                carrier.handler.onGroupTitle(group, from, title);
            }
        }

        void onPeerName(Carrier carrier, String groupId, String peerId, String peerName) {
            Group group = (Group)carrier.groups.get(groupId);
            if (group != null) {
                carrier.handler.onPeerName(group, peerId, peerName);
            }
        }

        void onPeerListChanged(Carrier carrier, String groupId) {
            Group group = (Group)carrier.groups.get(groupId);
            if (group != null) {
                carrier.handler.onPeerListChanged(group);
            }
        }
    }
}

