/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.carrier;

import org.elastos.carrier.Carrier;
import org.elastos.carrier.FriendInviteResponseHandler;
import org.elastos.carrier.Log;
import org.elastos.carrier.exceptions.CarrierException;

public abstract class CarrierExtension {
    private static final String TAG = "CarrierExtension";
    private Carrier carrier;
    private long nativeCookie = 0L;

    private native boolean native_init(Carrier var1);

    private native boolean invite_friend(Carrier var1, String var2, String var3, FriendInviteResponseHandler var4);

    private native boolean reply_friend(Carrier var1, String var2, int var3, String var4, String var5);

    private native TurnServerInfo get_turn_server(Carrier var1);

    private native void native_cleanup(Carrier var1);

    private static native int get_error_code();

    protected abstract void onFriendInvite(Carrier var1, String var2, String var3);

    protected CarrierExtension(Carrier carrier) {
        if (carrier == null) {
            throw new IllegalArgumentException();
        }
        this.carrier = carrier;
        Log.i(TAG, "CarrierExtension instance created");
    }

    protected TurnServerInfo getTurnServerInfo() throws CarrierException {
        if (this.nativeCookie == 0L) {
            throw new IllegalStateException();
        }
        TurnServerInfo sinfo = this.get_turn_server(this.carrier);
        if (sinfo == null) {
            throw CarrierException.fromErrorCode(CarrierExtension.get_error_code());
        }
        Log.d(TAG, String.format("Get TURN server info {\n  server: %s\n  username: %s\n  password: %s\n  realm: %s\n  port: %d\n}", sinfo.getServer(), sinfo.getUsername(), sinfo.getPassword(), sinfo.getRealm(), sinfo.getPort()));
        return sinfo;
    }

    protected void inviteFriend(String to, String data, FriendInviteResponseHandler handler) throws CarrierException {
        if (this.nativeCookie == 0L) {
            throw new IllegalStateException();
        }
        if (to == null || to.length() == 0 || data == null || data.length() == 0 || handler == null) {
            throw new IllegalArgumentException();
        }
        Log.d(TAG, "Inviting friend " + to + "with greet data " + data);
        if (!this.invite_friend(this.carrier, to, data, handler)) {
            throw CarrierException.fromErrorCode(CarrierExtension.get_error_code());
        }
        Log.d(TAG, "Send friend invite request to " + to);
    }

    protected void replyFriendInvite(String to, int status, String reason, String data) throws CarrierException {
        if (this.nativeCookie == 0L) {
            throw new IllegalStateException();
        }
        if (to == null || to.length() == 0 || status != 0 && reason == null) {
            throw new IllegalArgumentException();
        }
        if (status == 0) {
            Log.d(TAG, String.format("Attempt to confirm friend invite to %s with data [%s]", to, data));
        } else {
            Log.d(TAG, String.format("Attempt to refuse friend invite to %s with status %d,and reason %s", to, status, reason));
        }
        if (!this.reply_friend(this.carrier, to, status, reason, data)) {
            throw CarrierException.fromErrorCode(CarrierExtension.get_error_code());
        }
        if (status == 0) {
            Log.d(TAG, String.format("Confirmed friend invite to %s with data [%s]", to, data));
        } else {
            Log.d(TAG, String.format("Refused friend invite to %s with status %d and reason %s", to, status, reason));
        }
    }

    protected void registerExtension() throws CarrierException {
        if (this.nativeCookie != 0L) {
            return;
        }
        if (!this.native_init(this.carrier)) {
            throw CarrierException.fromErrorCode(CarrierExtension.get_error_code());
        }
    }

    protected void finalize() throws Throwable {
        if (this.nativeCookie != 0L) {
            this.native_cleanup(this.carrier);
        }
        super.finalize();
    }

    protected static class TurnServerInfo {
        private String server;
        private String username;
        private String password;
        private String realm;
        private int port;

        TurnServerInfo(String server, String username, String password, String realm, int port) {
            this.server = server;
            this.username = username;
            this.password = password;
            this.realm = realm;
            this.port = port;
        }

        public String getServer() {
            return this.server;
        }

        public int getPort() {
            return this.port;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getRealm() {
            return this.realm;
        }
    }
}

