/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.carrier;

public enum ConnectionStatus {
    Connected,
    Disconnected;


    public static ConnectionStatus valueOf(int status) {
        switch (status) {
            case 0: {
                return Connected;
            }
            case 1: {
                return Disconnected;
            }
        }
        throw new IllegalArgumentException("Invalid Connection Status (expected: 0 ~ 1, Gieven:" + status);
    }

    public int value() {
        switch (this) {
            case Connected: {
                return 0;
            }
        }
        return 1;
    }

    static String format(ConnectionStatus status) {
        return String.format("%s[%d]", status.name(), status.value());
    }

    public String toString() {
        return ConnectionStatus.format(this);
    }
}

