/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.carrier;

import java.util.ArrayList;
import java.util.List;
import org.elastos.carrier.Carrier;
import org.elastos.carrier.GroupPeersIterator;
import org.elastos.carrier.exceptions.CarrierException;

public class Group {
    public static final int MAX_APP_MESSAGE_LEN = 1024;
    public static final int MAX_GROUP_TITLE_LEN = 127;
    private String groupId;
    private Carrier carrier;

    private static native String new_group(Carrier var0);

    private static native String group_join(Carrier var0, String var1, byte[] var2);

    private native boolean leave_group(Carrier var1, String var2);

    private native boolean group_invite(Carrier var1, String var2, String var3);

    private native boolean group_send_message(Carrier var1, String var2, byte[] var3);

    private native String group_get_title(Carrier var1, String var2);

    private native boolean group_set_title(Carrier var1, String var2, String var3);

    private native boolean group_get_peers(Carrier var1, String var2, GroupPeersIterator var3, Object var4);

    private native PeerInfo group_get_peer(Carrier var1, String var2, String var3);

    private static native int get_error_code();

    Group(Carrier carrier, String groupId) {
        this.carrier = carrier;
        this.groupId = groupId;
    }

    Group(Carrier carrier) throws CarrierException {
        this.groupId = Group.new_group(carrier);
        if (this.groupId == null) {
            throw CarrierException.fromErrorCode(Group.get_error_code());
        }
        this.carrier = carrier;
    }

    Group(Carrier carrier, String friendId, byte[] cookie) throws CarrierException {
        this.groupId = Group.group_join(carrier, friendId, cookie);
        if (this.groupId == null) {
            throw CarrierException.fromErrorCode(Group.get_error_code());
        }
        this.carrier = carrier;
    }

    void leave() throws CarrierException {
        if (!this.leave_group(this.carrier, this.groupId)) {
            throw CarrierException.fromErrorCode(Group.get_error_code());
        }
    }

    public String getId() {
        return this.groupId;
    }

    public void invite(String friendId) throws CarrierException {
        if (friendId == null || friendId.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (!this.group_invite(this.carrier, this.groupId, friendId)) {
            throw CarrierException.fromErrorCode(Group.get_error_code());
        }
    }

    public void sendMessage(byte[] message) throws CarrierException {
        if (message == null || message.length == 0 || message.length > 1024) {
            throw new IllegalArgumentException();
        }
        if (!this.group_send_message(this.carrier, this.groupId, message)) {
            throw CarrierException.fromErrorCode(Group.get_error_code());
        }
    }

    public String getTitle() throws CarrierException {
        String title = this.group_get_title(this.carrier, this.groupId);
        if (title == null) {
            throw CarrierException.fromErrorCode(Group.get_error_code());
        }
        return title;
    }

    public void setTitle(String title) throws CarrierException {
        if (title == null || title.length() == 0 || title.length() > 127) {
            throw new IllegalArgumentException();
        }
        if (!this.group_set_title(this.carrier, this.groupId, title)) {
            throw CarrierException.fromErrorCode(Group.get_error_code());
        }
    }

    public List<PeerInfo> getPeers() throws CarrierException {
        ArrayList<PeerInfo> peers = new ArrayList<PeerInfo>();
        boolean result = this.group_get_peers(this.carrier, this.groupId, new GroupPeersIterator(){

            @Override
            public boolean onIterated(PeerInfo peerInfo, Object context) {
                List peers = (List)context;
                if (peerInfo != null) {
                    peers.add(peerInfo);
                }
                return true;
            }
        }, peers);
        if (!result) {
            throw CarrierException.fromErrorCode(Group.get_error_code());
        }
        return peers;
    }

    public PeerInfo getPeer(String peerId) throws CarrierException {
        if (peerId == null || peerId.length() == 0) {
            throw new IllegalArgumentException();
        }
        PeerInfo peerInfo = this.group_get_peer(this.carrier, this.groupId, peerId);
        if (peerInfo == null) {
            throw CarrierException.fromErrorCode(Group.get_error_code());
        }
        return peerInfo;
    }

    public static class PeerInfo {
        private String userId;
        private String name;

        private PeerInfo(String name, String userId) {
            this.userId = userId;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getUserId() {
            return this.userId;
        }
    }
}

