/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.carrier;

public enum PresenceStatus {
    None,
    Away,
    Busy;


    public static PresenceStatus valueOf(int status) {
        switch (status) {
            case 0: {
                return None;
            }
            case 1: {
                return Away;
            }
            case 2: {
                return Busy;
            }
        }
        throw new IllegalArgumentException("Invalid presence status (expected: 0 ~ 2, Gieven:" + status);
    }

    public int value() {
        switch (this) {
            case None: {
                return 0;
            }
            case Away: {
                return 1;
            }
        }
        return 0;
    }

    public static String format(PresenceStatus status) {
        return String.format("%s[%d]", status.name(), status.value());
    }

    public String toString() {
        return PresenceStatus.format(this);
    }
}

