/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.carrier;

public enum ReceiptState {
    ReceiptByFriend,
    DeliveredAsOffline,
    Error;


    public static ReceiptState valueOf(int state) {
        switch (state) {
            case 0: {
                return ReceiptByFriend;
            }
            case 1: {
                return DeliveredAsOffline;
            }
            case 2: {
                return Error;
            }
        }
        throw new IllegalArgumentException("Invalid receipt state (expected: 0 ~ 2, Gieven:" + state);
    }

    public int value() {
        switch (this) {
            case ReceiptByFriend: {
                return 0;
            }
            case DeliveredAsOffline: {
                return 1;
            }
        }
        return 2;
    }

    public static String format(ReceiptState state) {
        return String.format("%s[%d]", state.name(), state.value());
    }

    public String toString() {
        return ReceiptState.format(this);
    }
}

