/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.carrier.exceptions;

import org.elastos.carrier.exceptions.DHTException;
import org.elastos.carrier.exceptions.GeneralException;
import org.elastos.carrier.exceptions.ICEException;
import org.elastos.carrier.exceptions.SystemException;
import org.elastos.carrier.exceptions.UnknownException;

public abstract class CarrierException
extends Exception {
    public static final int FACILITY_GENERAL = 1;
    public static final int FACILITY_SYSTEM = 2;
    public static final int FACILITY_RESERVED1 = 3;
    public static final int FACILITY_RESERVED2 = 4;
    public static final int FACILITY_ICE = 5;
    public static final int FACILITY_DHT = 6;
    private static final long serialVersionUID = -1729415961509977814L;
    private int errorCode;

    protected CarrierException(int errorCode) {
        this.errorCode = errorCode;
    }

    protected CarrierException(int errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
    }

    protected CarrierException(int errorCode, String message, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
    }

    protected CarrierException(int errorCode, Throwable cause) {
        super(cause);
        this.errorCode = errorCode;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (message != null) {
            return message;
        }
        return message;
    }

    public abstract int getFacility();

    public int getCode() {
        return this.errorCode & 0xFFFFFF;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    private static int getFacility(int errorCode) {
        return (errorCode & Integer.MAX_VALUE) >> 24;
    }

    public static CarrierException fromErrorCode(int errorCode, String message, Throwable cause) {
        CarrierException e;
        int facility = CarrierException.getFacility(errorCode);
        switch (facility) {
            case 1: {
                e = new GeneralException(errorCode, message, cause);
                break;
            }
            case 2: {
                e = new SystemException(errorCode, message, cause);
                break;
            }
            case 5: {
                e = new ICEException(errorCode, message, cause);
                break;
            }
            case 6: {
                e = new DHTException(errorCode, message, cause);
                break;
            }
            default: {
                e = new UnknownException(errorCode, message, cause);
            }
        }
        return e;
    }

    public static CarrierException fromErrorCode(int errorCode, String message) {
        return CarrierException.fromErrorCode(errorCode, message, null);
    }

    public static CarrierException fromErrorCode(int errorCode, Throwable cause) {
        return CarrierException.fromErrorCode(errorCode, null, cause);
    }

    public static CarrierException fromErrorCode(int errorCode) {
        return CarrierException.fromErrorCode(errorCode, null, null);
    }
}

