/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.carrier.filetransfer;

import java.io.IOException;
import java.io.OutputStream;
import org.elastos.carrier.exceptions.CarrierException;
import org.elastos.carrier.filetransfer.FileTransferInfo;

public class FileTransfer {
    private long nativeCookie;
    private long nativeContext;

    private static native String generate_fileId();

    private native void native_close();

    private native String get_fileId(String var1);

    private native String get_filename(String var1);

    private native boolean native_connect();

    private native boolean accept_connect();

    private native boolean native_add(FileTransferInfo var1);

    private native boolean native_pull(String var1, long var2);

    private native int native_send(String var1, byte[] var2, int var3, int var4);

    private native boolean native_cancel(String var1, int var2, String var3);

    private native boolean native_pend(String var1);

    private native boolean native_resume(String var1);

    private static native int get_error_code();

    private FileTransfer() {
    }

    public static String generateFileId() throws CarrierException {
        String fileId = FileTransfer.generate_fileId();
        if (fileId == null) {
            throw CarrierException.fromErrorCode(FileTransfer.get_error_code());
        }
        return fileId;
    }

    public void close() {
        this.native_close();
    }

    public String getFileId(String filename) throws CarrierException {
        if (filename == null || filename.isEmpty()) {
            throw new IllegalArgumentException();
        }
        String fileId = this.get_fileId(filename);
        if (fileId == null) {
            throw CarrierException.fromErrorCode(FileTransfer.get_error_code());
        }
        return fileId;
    }

    public String getFileName(String fileId) throws CarrierException {
        if (fileId == null || fileId.isEmpty()) {
            throw new IllegalArgumentException();
        }
        String filename = this.get_filename(fileId);
        if (filename == null) {
            throw CarrierException.fromErrorCode(FileTransfer.get_error_code());
        }
        return filename;
    }

    public void connect() throws CarrierException {
        if (!this.native_connect()) {
            throw CarrierException.fromErrorCode(FileTransfer.get_error_code());
        }
    }

    public void acceptConnect() throws CarrierException {
        if (!this.accept_connect()) {
            throw CarrierException.fromErrorCode(FileTransfer.get_error_code());
        }
    }

    public void addFile(FileTransferInfo fileinfo) throws CarrierException {
        if (fileinfo == null) {
            throw new IllegalArgumentException();
        }
        if (!this.native_add(fileinfo)) {
            throw CarrierException.fromErrorCode(FileTransfer.get_error_code());
        }
    }

    public void pullData(String fileId, long offset) throws CarrierException {
        if (fileId == null || fileId.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (!this.native_pull(fileId, offset)) {
            throw CarrierException.fromErrorCode(FileTransfer.get_error_code());
        }
    }

    public int writeData(String fileId, byte[] data, int offset, int len) throws CarrierException {
        if (fileId == null || fileId.isEmpty() || data == null || data.length == 0 || offset < 0 || len <= 0 || offset + len < len || offset + len > data.length) {
            throw new IllegalArgumentException();
        }
        int bytes = this.native_send(fileId, data, offset, len);
        if (bytes < 0) {
            throw CarrierException.fromErrorCode(FileTransfer.get_error_code());
        }
        return bytes;
    }

    public int writeData(String fileId, byte[] data) throws CarrierException {
        return this.writeData(fileId, data, 0, data.length);
    }

    public int writeData(String fileId, byte data) throws CarrierException {
        byte[] _data = new byte[]{data};
        return this.writeData(fileId, _data);
    }

    public OutputStream getOutputStream(String fileId) {
        return new FileTransferOutputStream(fileId);
    }

    public void sendFinish(String fileId) throws CarrierException {
        if (fileId == null || fileId.isEmpty()) {
            throw new IllegalArgumentException();
        }
        int bytes = this.native_send(fileId, null, 0, 0);
        if (bytes < 0) {
            throw CarrierException.fromErrorCode(FileTransfer.get_error_code());
        }
    }

    public void cancelTransfer(String fileId, int status, String reason) throws CarrierException {
        if (fileId == null || fileId.isEmpty() || reason == null) {
            throw new IllegalArgumentException();
        }
        if (!this.native_cancel(fileId, status, reason)) {
            throw CarrierException.fromErrorCode(FileTransfer.get_error_code());
        }
    }

    public void pendTransfer(String fileId) throws CarrierException {
        if (fileId == null || fileId.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (!this.native_pend(fileId)) {
            throw CarrierException.fromErrorCode(FileTransfer.get_error_code());
        }
    }

    public void resumeTransfer(String fileId) throws CarrierException {
        if (fileId == null || fileId.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (!this.native_resume(fileId)) {
            throw CarrierException.fromErrorCode(FileTransfer.get_error_code());
        }
    }

    private class FileTransferOutputStream
    extends OutputStream {
        private String fileId;

        FileTransferOutputStream(String fileId) {
            this.fileId = fileId;
        }

        @Override
        public void write(int i) throws IOException {
            try {
                FileTransfer.this.writeData(this.fileId, (byte)i);
            }
            catch (CarrierException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            try {
                FileTransfer.this.writeData(this.fileId, b);
            }
            catch (CarrierException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void write(byte[] b, int offset, int len) throws IOException {
            try {
                FileTransfer.this.writeData(this.fileId, b, offset, len);
            }
            catch (CarrierException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }
}

