/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.carrier.filetransfer;

import org.elastos.carrier.Carrier;
import org.elastos.carrier.Log;
import org.elastos.carrier.exceptions.CarrierException;
import org.elastos.carrier.filetransfer.FileTransfer;
import org.elastos.carrier.filetransfer.FileTransferHandler;
import org.elastos.carrier.filetransfer.FileTransferInfo;
import org.elastos.carrier.filetransfer.ManagerHandler;

public class Manager {
    private static final String TAG = "FileTransMgr";
    private Carrier carrier;
    private boolean didCleanup;
    private long nativeCookie = 0L;

    private native boolean native_init(Carrier var1, ManagerHandler var2);

    private native void native_cleanup(Carrier var1);

    private static native FileTransfer create_filetransfer(Carrier var0, String var1, FileTransferInfo var2, FileTransferHandler var3);

    private static native int get_error_code();

    public static Manager createInstance(Carrier carrier) throws CarrierException {
        return Manager.createInstance(carrier, null);
    }

    public static Manager createInstance(Carrier carrier, ManagerHandler handler) throws CarrierException {
        if (carrier == null) {
            throw new IllegalArgumentException();
        }
        Log.d(TAG, "Attempt to create carrier file transfer manager instance ...");
        Manager tmp = new Manager(carrier);
        if (!tmp.native_init(carrier, handler)) {
            throw CarrierException.fromErrorCode(Manager.get_error_code());
        }
        Log.d(TAG, "Carrier file transfer manager instance created");
        return tmp;
    }

    private Manager(Carrier carrier) {
        this.carrier = carrier;
        this.didCleanup = false;
    }

    protected void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }

    public synchronized void cleanup() {
        if (!this.didCleanup) {
            this.native_cleanup(this.carrier);
            this.carrier = null;
            this.didCleanup = true;
        }
    }

    public FileTransfer newFileTransfer(String to, FileTransferInfo fileinfo, FileTransferHandler handler) throws CarrierException {
        if (to == null || handler == null) {
            throw new IllegalArgumentException();
        }
        Log.d(TAG, "Attempt to create a new file transfer to:" + to);
        FileTransfer filetransfer = Manager.create_filetransfer(this.carrier, to, fileinfo, handler);
        if (filetransfer == null) {
            throw CarrierException.fromErrorCode(Manager.get_error_code());
        }
        Log.d(TAG, "Filetransfer to " + to + " created");
        return filetransfer;
    }
}

